//+------------------------------------------------------------------+ 
//|                                              InverseReaction.mq5 | 
//|                                      Copyright  2013, Erdem Sen | 
//|                         http://login.mql5.com/en/users/erdogenes | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2013, Erdem Sen"
#property link "http://login.mql5.com/en/users/erdogenes" 
//----   
#property version   "1.00"
//---     
#property indicator_separate_window 
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   2
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----   1   
#property indicator_type1   DRAW_FILLING
//----      
#property indicator_color1  clrLavender
//----    
#property indicator_label1  "InverseReaction Cloud"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----   2    
#property indicator_type2 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color2 clrMagenta,clrGray,clrMediumSpringGreen
//----   - 
#property indicator_style2 STYLE_SOLID
//----     2
#property indicator_width2 2
//----   
#property indicator_label2 "InverseReaction Histogram"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+
//|    CXMA             |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CMomentum  CJJMA   SmoothAlgorithms.mqh
CMomentum Mom;
CXMA XMA;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint     MomPeriod   = 1;                    // Momentum period
input Applied_price_   MOMPrice = PRICE_CLOSE;     // Momentum price
input uint     MaPeriod    = 3;                    // Moving average period
input int      MaPhase=15;                         //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input  Smooth_Method   MaType = MODE_EMA;          // Moving average type
input double   Coefficient = 1.618;                // Confidence coefficient
//+-----------------------------------+
//----   ,    
//      
double UpIndBuffer[],DnIndBuffer[],IndBuffer[],ColorIndBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| InverseReaction indicator initialization function                | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=int(MomPeriod+MaPeriod);

//----      
   SetIndexBuffer(0,UpIndBuffer,INDICATOR_DATA);

//----      
   SetIndexBuffer(1,DnIndBuffer,INDICATOR_DATA);
   
//----      
   SetIndexBuffer(2,IndBuffer,INDICATOR_DATA);

//----     ,     
   SetIndexBuffer(3,ColorIndBuffer,INDICATOR_COLOR_INDEX);

//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"InverseReaction");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);

//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| InverseReaction iteration function                               | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);

//----       
   double price,mom,xmom;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(MOMPrice,bar,Open,Low,High,Close);
      mom=Mom.MomentumSeries(0,prev_calculated,rates_total,MomPeriod,price,bar,false)/_Point;
      xmom=Coefficient*XMA.XMASeries(MomPeriod,prev_calculated,rates_total,MaType,MaPhase,MaPeriod,MathAbs(mom),bar,false);
      
      UpIndBuffer[bar]=+xmom;
      DnIndBuffer[bar]=-xmom;
      IndBuffer[bar]=mom;   
      int clr=1;
      if(mom>+xmom) clr=2;
      if(mom<-xmom) clr=0;
      ColorIndBuffer[bar]=clr;
     }
//----     
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
