//+------------------------------------------------------------------+ 
//|                                                ForexOFFTrend.mq5 | 
//|                        Copyright  2006, rewritten by CrazyChart | 
//|                                                  http://viac.ru/ | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, rewritten by CrazyChart"
#property link "http://viac.ru/"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    2
#property indicator_buffers 2 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrPaleGreen,clrViolet
//----   
#property indicator_label1  "Buy;Sell"

//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint    SSP = 7;         //   
input uint   KPer = 7;         //     
input double Kmax = 50.6;
input int   Shift=0;         //      
//+-----------------------------------+

//----      
int  min_rates_total;
//----   ,    
//      
double ExtABuffer[];
double ExtBBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----     
   min_rates_total=int(MathMax(SSP,KPer)+KPer);

//----      
   SetIndexBuffer(0,ExtABuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtABuffer,true);
//----      
   SetIndexBuffer(1,ExtBBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtBBuffer,true);

//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"ForexOFFTrend("+string(SSP)+")");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double HH,LL;
//----   
   int limit;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-int(MathMax(SSP,KPer))-1; //      
   else limit=rates_total-prev_calculated;  //       

//----         
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);

//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      HH=High[ArrayMaximum(High,bar,SSP)];
      LL=Low[ArrayMinimum(Low,bar,SSP)];
      ExtABuffer[bar]=HH-(HH-LL)*Kmax/100;
      ExtBBuffer[bar]=ExtABuffer[bar+KPer];
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
