//+------------------------------------------------------------------+
//|                                                 isNormalDist.mqh |
//|                           Copyright 2012, Nazariy Stapyak (WWer) |
//|                                          http://at-solutions.net |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, Nazariy Stapyak (WWer)"
#property link      "http://at-solutions.net"
//+------------------------------------------------------------------+
//| Function for the Shapiro-Wilk normality test     |
//| with the significance level of 0.05                           |
//+------------------------------------------------------------------+
bool isNormalDist(const double &x[])
  {
   int n=ArraySize(x);
//---
   double MX= 0.0;
   for(int i=0; i<n; i++)
     {
      MX+=x[i];
     }
   MX/=n;
//---
   double s2= 0.0;
   for(int i=0; i<n; i++)
     {
      s2+=(x[i]-MX) *(x[i]-MX);
     }
//---
   int    m  = n / 2;
   double B  = 0.0;
   double a0 = (0.899 / MathPow(n-2.4, 0.4162)) - 0.02;
   for(int j=0; j<m; j++)
     {
      double z=(n-2*(j+1)+1)/(n-0.5);
      double aj=a0 *(z+1483/MathPow(3-z,10.845)+71.6E-10/MathPow(1.1-z,8.26));
      B+=aj *(x[n-j-1]-x[j]);
     }
   B=B*B; // B^2
//---
   double W1=(1-0.6695/MathPow(n,0.6518)) *(s2/B);
//---
   return(W1<1.0) ? false : true;
  }
//+------------------------------------------------------------------+
