#define END_TIME D'31.12.3000 23:59:59'

class SYMBOL
{
private:
  bool DeleteCharts( void ) const
  {
    bool Res = true;

    long Chart = ::ChartFirst();

    while (Chart != -1)
    {
      if ((Chart != ::ChartID()) && (::ChartSymbol(Chart) == this.Name))
        Res &= ChartClose(Chart);

      Chart = ::ChartNext(Chart);
    }

    return(Res);
  }

  static datetime GetTimeTick( const MqlTick &Tick )
  {
    return(Tick.time_msc ? (datetime)(Tick.time_msc / 1000) : Tick.time);
  }

  static datetime TimeToRates( const datetime time )
  {
    return(time - (time % 60));
  }

  int TicksToRates( const MqlTick &Ticks[], MqlRates &Rates, int Pos = 0 ) const
  {
    const int Size = ArraySize(Ticks);

    if (Pos < Size)
    {
      const bool IsBid = (this.GetProperty(SYMBOL_CHART_MODE) == SYMBOL_CHART_MODE_BID);
      const datetime RatesTime = SYMBOL::TimeToRates(SYMBOL::GetTimeTick(Ticks[Pos]));
      const datetime NextTime = RatesTime + 60;

      do
      {
        double Price = IsBid ? Ticks[Pos].bid : Ticks[Pos].last;

        if (Rates.time != RatesTime)
        {
          if (!Price)
            Price = Rates.close;

          Rates.open = Price;
          Rates.high = Price;
          Rates.low = Price;
          Rates.close = Price;

          Rates.time = RatesTime;

          Rates.tick_volume = 0;
          Rates.real_volume = 0;
          Rates.spread = 0;
        }
        else if (Price && (Rates.close != Price))
        {
          if (Price > Rates.high)
            Rates.high = Price;
          else if (Price < Rates.low)
            Rates.low = Price;

          Rates.close = Price;
        }

        Rates.tick_volume++;
        Pos++;
      }
      while ((Pos < Size) && GetTimeTick(Ticks[Pos]) < NextTime);
    }

    return(Pos);
  }

#define DAY (24 * 3600)
  static int GetEndOldTicksPos( const MqlTick &Ticks[] )
  {
    const int Size = ::ArraySize(Ticks);

  #ifdef __VIRTUAL__
    const datetime EndTime = _V(0, ::TimeCurrent()) / DAY * DAY;
  #else // __VIRTUAL__
    const datetime EndTime = ::TimeCurrent() / DAY * DAY;
  #endif // __VIRTUAL__
    int Pos = (Size && (SYMBOL::GetTimeTick(Ticks[Size - 1]) < EndTime)) ? Size : 0;

    while ((Pos < Size) && SYMBOL::GetTimeTick(Ticks[Pos]) < EndTime)
      Pos++;

    return(Pos);
  }
#undef DAY

  static int CorrectTicks( MqlTick &Ticks[] )
  {
    const int Size = ::ArraySize(Ticks);
    int Count = 0;

    for (int i = 1; (i < Size) && (Ticks[i].time_msc >= Ticks[Count].time_msc); i++)
      if ((Ticks[i].bid != Ticks[Count].bid) || (Ticks[i].ask != Ticks[Count].ask)/* || (Ticks[i].last != Ticks[Count].last)*/)
        Ticks[++Count] = Ticks[i];

    return(Size ? ::ArrayResize(Ticks, Count + 1) : 0);
  }


  bool CustomTicksAddPrepare( const long StartTime, MqlTick &Ticks[] ) const
  {
    MqlTick LastTick[1];

    const bool Res = ((
                     #ifdef __VIRTUAL__
                       _V(0, ::SymbolInfoTick(this.Name, LastTick[0])) &&
                     #else // __VIRTUAL__
                       ::SymbolInfoTick(this.Name, LastTick[0]) &&
                     #endif // __VIRTUAL__

                      LastTick[0].time_msc) ||
                       (::CopyTicks(this.Name, LastTick, COPY_TICKS_ALL, 0, 1) == 1)) &&
                       (StartTime < LastTick[0].time_msc);

    if (Res)
    {
      for (int i = ::CopyTicksRange(this.Name, Ticks) - 1; i >= 0; i--)
        if (Ticks[i].time_msc < StartTime)
        {
          ::ArrayResize(Ticks, i + 1);

          SYMBOL::CorrectTicks(Ticks);

          break;
        }
        else if (!i)
         :: ArrayResize(Ticks, 0);

      ::CustomTicksDelete(this.Name, ::ArraySize(Ticks) ? Ticks[0].time_msc : StartTime, LONG_MAX);
    }

    return(Res);
  }

  int AddTicks( const MqlTick &Ticks[] ) const
  {
    int Res = 0;
    const int Size = ::ArraySize(Ticks);

    if (Size)
    {
      MqlTick NewTicks[];

      if (this.CustomTicksAddPrepare(Ticks[0].time_msc, NewTicks))
      {
        Res = ::CustomTicksAdd(this.Name, Ticks);

        if (::ArrayCopy(NewTicks, Ticks, ::ArraySize(NewTicks)))
          ::CustomTicksReplace(this.Name, NewTicks[0].time_msc, LONG_MAX, NewTicks);
      }
      else
      {
        const long StartTime  = Ticks[0].time_msc;
        const long BarTime = StartTime / 60000 * 60000;

       ::CopyTicksRange(this.Name, NewTicks, COPY_TICKS_ALL, BarTime);
       SYMBOL::CorrectTicks(NewTicks);

       ::ArrayCopy(NewTicks, Ticks, ::ArraySize(NewTicks));

        Res = CustomTicksAdd(this.Name, Ticks);
        ::CustomTicksReplace(this.Name, BarTime, LONG_MAX, NewTicks);

        /*
        const int Pos = ::ArrayCopy(NewTicks, Ticks, 0, 0, SYMBOL::GetEndOldTicksPos(Ticks));

        Res = Pos ? ::CustomTicksAdd(this.Name, NewTicks) : 0;

        if (Res > 0)
        {
          const int NewSize = ::ArraySize(NewTicks);

          MqlRates Rates[];
          ::ArrayResize(Rates, 1);
          ::ZeroMemory(Rates);

          MqlTick Tick = {0};

          if (::SymbolInfoTick(this.Name, Tick) && Tick.time) // https://www.mql5.com/ru/forum/304239/page3#comment_10729032
            ::CopyRates(this.Name, PERIOD_M1, SYMBOL::TimeToRates(SYMBOL::GetTimeTick(NewTicks[0])), 1, Rates);

          for (int j = 0, i = SYMBOL::TicksToRates(NewTicks, Rates[j]); i < NewSize; i = SYMBOL::TicksToRates(NewTicks, Rates[j], i))
          {
            j = ::ArrayResize(Rates, j + 2) - 1;

            Rates[j].time = 0;
          }

          this += Rates;
    //      CustomRatesReplace(this.Name, Rates[0].time, END_TIME, Rates);
        }

        if ((Pos < Size) && (::ArrayResize(NewTicks, ::ArrayCopy(NewTicks, Ticks, 0, Pos)) > 0))
        {
          const int AddRes = ::CustomTicksAdd(this.Name, NewTicks); // https://www.mql5.com/ru/forum/304554/page9#comment_11680710

          if (AddRes > 0)
          {
            if (Res < 0)
              Res = AddRes;
            else
              Res += AddRes;
          }
        }
        */
      }
    }

    return(Res);
  }

public:
  const string Name;

  SYMBOL( const string Symb = NULL, const string Path = NULL, const string SymbOriginal = NULL ) : Name((Symb == NULL) ? _Symbol : Symb)
  {
    this.Create(Path, SymbOriginal);
  }

  static bool SymbolIsExist( const string Symb = NULL )
  {
    ::ResetLastError();

    ::SymbolInfoInteger((Symb == NULL) ? _Symbol : Symb, SYMBOL_CUSTOM);

    return(::GetLastError() != ERR_MARKET_UNKNOWN_SYMBOL);
  }

  bool SetProperty( const ENUM_SYMBOL_INFO_DOUBLE Property, double Value ) const
  {
    return(::CustomSymbolSetDouble(this.Name, Property, Value));
  }

  bool SetProperty( const ENUM_SYMBOL_INFO_INTEGER Property, long Value ) const
  {
    return(::CustomSymbolSetInteger(this.Name, Property, Value));
  }

  bool SetProperty( const ENUM_SYMBOL_INFO_STRING Property, string Value ) const
  {
    return(::CustomSymbolSetString(this.Name, Property, Value));
  }

  long GetProperty( const ENUM_SYMBOL_INFO_INTEGER Property ) const
  {
    return(::SymbolInfoInteger(this.Name, Property));
  }

  double GetProperty( const ENUM_SYMBOL_INFO_DOUBLE Property ) const
  {
    return(::SymbolInfoDouble(this.Name, Property));
  }

  string GetProperty( const ENUM_SYMBOL_INFO_STRING Property ) const
  {
    return(::SymbolInfoString(this.Name, Property));
  }

  bool Delete( const bool Force = false ) const
  {
    return(this.IsCustom() && (!Force || this.DeleteCharts()) && this.Off() && ::CustomSymbolDelete(this.Name));
  }

#define CLONE(A) this.SetProperty(A, Source.GetProperty(A))

  bool CloneProperties( const string Symb = NULL ) const
  {
    const SYMBOL Source(Symb);

    return(SYMBOL::SymbolIsExist(Symb) && this.IsCustom() &&
    CLONE(SYMBOL_BASIS) &&
    CLONE(SYMBOL_CURRENCY_BASE) &&
    CLONE(SYMBOL_CURRENCY_MARGIN) &&
    CLONE(SYMBOL_CURRENCY_PROFIT) &&
    CLONE(SYMBOL_DESCRIPTION) &&
    CLONE(SYMBOL_FORMULA) &&
    CLONE(SYMBOL_ISIN) &&
    CLONE(SYMBOL_PAGE) &&
//    CLONE(SYMBOL_PATH) &&

    CLONE(SYMBOL_MARGIN_HEDGED) &&
    CLONE(SYMBOL_MARGIN_INITIAL) &&
    CLONE(SYMBOL_MARGIN_MAINTENANCE) &&
    CLONE(SYMBOL_OPTION_STRIKE) &&
    CLONE(SYMBOL_POINT) &&
    CLONE(SYMBOL_SESSION_PRICE_LIMIT_MAX) &&
    CLONE(SYMBOL_SESSION_PRICE_LIMIT_MIN) &&
    CLONE(SYMBOL_SESSION_PRICE_SETTLEMENT) &&
    CLONE(SYMBOL_SWAP_LONG) &&
    CLONE(SYMBOL_SWAP_SHORT) &&
    CLONE(SYMBOL_TRADE_ACCRUED_INTEREST) &&
    CLONE(SYMBOL_TRADE_CONTRACT_SIZE) &&
    CLONE(SYMBOL_TRADE_FACE_VALUE) &&
    CLONE(SYMBOL_TRADE_LIQUIDITY_RATE) &&
    CLONE(SYMBOL_TRADE_TICK_SIZE) &&
    CLONE(SYMBOL_TRADE_TICK_VALUE) &&
    CLONE(SYMBOL_VOLUME_LIMIT) &&
    CLONE(SYMBOL_VOLUME_MAX) &&
    CLONE(SYMBOL_VOLUME_MIN) &&
    CLONE(SYMBOL_VOLUME_STEP) &&

    CLONE(SYMBOL_BACKGROUND_COLOR) &&
    CLONE(SYMBOL_CHART_MODE) &&
    CLONE(SYMBOL_DIGITS) &&
    CLONE(SYMBOL_EXPIRATION_MODE) &&
    CLONE(SYMBOL_EXPIRATION_TIME) &&
    CLONE(SYMBOL_FILLING_MODE) &&
    CLONE(SYMBOL_MARGIN_HEDGED_USE_LEG) &&
    CLONE(SYMBOL_OPTION_MODE) &&
    CLONE(SYMBOL_OPTION_RIGHT) &&
    CLONE(SYMBOL_ORDER_GTC_MODE) &&
    CLONE(SYMBOL_ORDER_MODE) &&
    CLONE(SYMBOL_SPREAD) &&
    CLONE(SYMBOL_SPREAD_FLOAT) &&
    CLONE(SYMBOL_START_TIME) &&
    CLONE(SYMBOL_SWAP_MODE) &&
    CLONE(SYMBOL_SWAP_ROLLOVER3DAYS) &&
//    CLONE(SYMBOL_TICKS_BOOKDEPTH) && // https://www.mql5.com/ru/forum/170952/page85#comment_7227865
    CLONE(SYMBOL_TRADE_CALC_MODE) &&
    CLONE(SYMBOL_TRADE_EXEMODE) &&
    CLONE(SYMBOL_TRADE_FREEZE_LEVEL) &&
    CLONE(SYMBOL_TRADE_MODE) &&
    CLONE(SYMBOL_TRADE_STOPS_LEVEL));
  }

#undef CLONE

  int CloneHistory( string Symb = NULL, const ulong _from_msc = 0, const ulong _to_msc = LONG_MAX  ) const
  {
    return(::MathMax(this.CloneRates(Symb), this.CloneTicks(Symb, _from_msc, _to_msc)));
  }

  int CloneRates( const MqlRates &Rates[], const datetime _from = 0, const datetime _to = END_TIME ) const
  {
    return(this.IsCustom() ? ::CustomRatesReplace(this.Name, _from, _to, Rates) : -1);
  }

  int CloneRates( string Symb = NULL ) const
  {
    int Res = this.IsCustom() && SYMBOL::SymbolIsExist(Symb) ? 0 : -1;

    if (Res != -1)
    {
      Symb = (Symb == NULL) ? _Symbol : Symb;
      MqlRates Rates[];

      ::CopyRates(Symb, PERIOD_M1, 0, (int)::SeriesInfoInteger(Symb, PERIOD_M1, SERIES_BARS_COUNT), Rates);

      Res = this.CloneRates(Rates);
    }

    return(Res);
  }

  int CloneTicks( const MqlTick &Ticks[] ) const
  {
    return(this.IsCustom() ? ::CustomTicksReplace(this.Name, 0, LONG_MAX, Ticks) : -1);
  }

  int CloneTicks( string Symb = NULL, const ulong _from_msc = 0, const ulong _to_msc = LONG_MAX ) const
  {
    Symb = (Symb == NULL) ? _Symbol : Symb;

    int Res = this.IsCustom() && ::SymbolInfoInteger(Symb, SYMBOL_CUSTOM) ? 0 : -1;

    if (Res != -1)
    {
      MqlTick Ticks[];

      ::CopyTicksRange(Symb, Ticks, COPY_TICKS_ALL, _from_msc, _to_msc);

      Res = this.CloneTicks(Ticks);
    }

    return(Res);
  }

  // https://www.mql5.com/ru/forum/212096/page5#comment_8982885
  bool Clone( const string Symb = NULL, const ulong _from_msc = 0, const ulong _to_msc = LONG_MAX ) const
  {
    return(this.CloneProperties(Symb) && (this.CloneHistory(Symb, _from_msc, _to_msc) != -1));
  }

  virtual bool operator =( const string Symb ) const
  {
    return(this.Clone(Symb));
  }

  bool On( void ) const
  {
    return(::SymbolSelect(this.Name, true));
  }

  bool Off( void ) const
  {
    return(::SymbolSelect(this.Name, false));
  }

  bool IsCustom( void ) const
  {
    return((bool)this.GetProperty(SYMBOL_CUSTOM));
  }

  bool IsExist( void ) const
  {
    return(SYMBOL::SymbolIsExist(this.Name));
  }

  int operator +=( const MqlTick &Ticks[] ) const
  {
    return(this.IsCustom() ? this.AddTicks(Ticks) : 0);
  }

  int operator +=( const MqlRates &Rates[] ) const
  {
    return(::CustomRatesUpdate(this.Name, Rates));
  }

  int operator += ( const MqlTick &Tick ) const
  {
    MqlTick Ticks[1];

    Ticks[0] = Tick;

    return(this += Ticks);
  }

  int operator +=( const MqlRates &Rates ) const
  {
    MqlRates Rates2[1];

    Rates2[0] = Rates;

    return(this += Rates2);
  }

  int DeleteTicks( const ulong _from_msc = 0, const ulong _to_msc = LONG_MAX ) const
  {
    return(::CustomTicksDelete(this.Name, _from_msc, _to_msc));
  }

  int DeleteRates( const datetime _from = 0, const datetime _to = END_TIME ) const
  {
    return(::CustomRatesDelete(this.Name, _from, _to));
  }

  int DeleteHistory( const datetime _from = 0, const datetime _to = END_TIME ) const
  {
    return(this.DeleteTicks((ulong)_from * 1000, (ulong)_to * 1000) + this.DeleteRates(_from, _to));
  }

  bool Create( const string Path = NULL, const string SymbOriginal = NULL ) const
  {
    return(!SYMBOL::SymbolIsExist(this.Name) &&
           (::CustomSymbolCreate(this.Name, Path, SymbOriginal)/* ||
           ((SymbOriginal == NULL) && ::CustomSymbolCreate(this.Name, Path, _Symbol))*/)); // https://www.mql5.com/ru/forum/313650/page13#comment_11879949
  }
};

#undef END_TIME