//+------------------------------------------------------------------+
//|                                                     MA2Cross.mq5 |
//|                        Copyright 2020, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2020, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Include                                                          |
//+------------------------------------------------------------------+
#include <Expert\Expert.mqh>
// available signals
#include <Expert\Signal\MySignals\Signal2MACross.mqh>
// available trailing
#include <Expert\Trailing\TrailingNone.mqh>
// available money management
#include <Expert\Money\MoneyFixedLot.mqh>
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
// inputs for expert
input string             Expert_Title              = "MA2Cross"; // Document name
ulong                    Expert_MagicNumber        = 9650;       // 
input bool               Expert_EveryTick          = false;      //
// inputs for main signal
input int                Signal_ThresholdOpen      = 10;         // Signal threshold value to open [0...100]
input int                Signal_ThresholdClose     = 10;         // Signal threshold value to close [0...100]
input double             Signal_PriceLevel         = 0.0;        // Price level to execute a deal
input double             Signal_StopLevel          = 0.0;        // Stop Loss level (in points)
input double             Signal_TakeLevel          = 0.0;        // Take Profit level (in points)
input int                Signal_Expiration          = 0;         // Expiration of pending orders (in bars)
input int                Signal_2MACross_SlowPeriod = 11;        // 2MA Cross(11,7,MODE_LWMA,...) Slow MA period
input int                Signal_2MACross_FastPeriod = 7;         // 2MA Cross(11,7,MODE_LWMA,...) Fast Ma period
input ENUM_MA_METHOD     Signal_2MACross_MAMethod  = MODE_LWMA;  // 2MA Cross(11,7,MODE_LWMA,...) Method of averaging
input ENUM_APPLIED_PRICE Signal_2MACross_MAPrice   = PRICE_CLOSE;// 2MA Cross(11,7,MODE_LWMA,...) Price type
input int                Signal_2MACross_Shift     = 0;          // 2MA Cross(11,7,MODE_LWMA,...) Shift
input double             Signal_2MACross_Weight    = 1.0;        // 2MA Cross(11,7,MODE_LWMA,...) Weight [0...1.0]
// inputs for money
input double             Money_FixLot_Percent      = 10.0;       // Percent
input double             Money_FixLot_Lots         = 0.1;        // Fixed volume



//+------------------------------------------------------------------+
//| Global expert object                                             |
//+------------------------------------------------------------------+
CExpert ExtExpert;

//+------------------------------------------------------------------+
//| Initialization function of the expert                            |
//+------------------------------------------------------------------+
int OnInit()
{
  // Initializing expert
  if(!ExtExpert.Init(Symbol(), Period(), Expert_EveryTick, Expert_MagicNumber))
  {
    printf(__FUNCTION__ + ": error initializing expert");
    ExtExpert.Deinit();
    return(INIT_FAILED);
  }
  // Creating signal
  CExpertSignal *signal = new CExpertSignal;
  if(signal == NULL)
  {
    printf(__FUNCTION__ + ": error creating signal");
    ExtExpert.Deinit();
    return(INIT_FAILED);
  }
  
  ExtExpert.InitSignal(signal);
  signal.ThresholdOpen(Signal_ThresholdOpen);
  signal.ThresholdClose(Signal_ThresholdClose);
  signal.PriceLevel(Signal_PriceLevel);
  signal.StopLevel(Signal_StopLevel);
  signal.TakeLevel(Signal_TakeLevel);
  signal.Expiration(Signal_Expiration);
  
  // Creating filter Signal2MACross
  Signal2MACross *filter0 = new Signal2MACross;
  if(filter0 == NULL)
  {
    printf(__FUNCTION__ + ": error creating filter0");
    ExtExpert.Deinit();
    return(INIT_FAILED);
  }
  signal.AddFilter(filter0);
  
  // Set filter parameters
  filter0.SlowPeriod(Signal_2MACross_SlowPeriod);
  filter0.FastPeriod(Signal_2MACross_FastPeriod);
  filter0.MAMethod(Signal_2MACross_MAMethod);
  filter0.MAPrice(Signal_2MACross_MAPrice);
  filter0.Shift(Signal_2MACross_Shift);
  filter0.Weight(Signal_2MACross_Weight);
  
  // Creation of trailing object
  CTrailingNone *trailing = new CTrailingNone;
  if(trailing == NULL)
  {
    printf(__FUNCTION__ + ": error creating trailing");
    ExtExpert.Deinit();
    return(INIT_FAILED);
  }
  
  // Add trailing to expert (will be deleted automatically))
  if(!ExtExpert.InitTrailing(trailing))
  {
    printf(__FUNCTION__ + ": error initializing trailing");
    ExtExpert.Deinit();
    return(INIT_FAILED);
  }
  
  // Set trailing parameters
  // Creation of money object
  CMoneyFixedLot *money = new CMoneyFixedLot;
  if(money == NULL)
  {
    printf(__FUNCTION__ + ": error creating money");
    ExtExpert.Deinit();
    return(INIT_FAILED);
  }
  
  // Add money to expert (will be deleted automatically))
  if(!ExtExpert.InitMoney(money))
  {
    printf(__FUNCTION__ + ": error initializing money");
    ExtExpert.Deinit();
    return(INIT_FAILED);
  }
  
  // Set money parameters
  money.Percent(Money_FixLot_Percent);
  money.Lots(Money_FixLot_Lots);
  
  // Check all trading objects parameters
  if(!ExtExpert.ValidationSettings())
  {
    ExtExpert.Deinit();
    return(INIT_FAILED);
  }
  
  // Tuning of all necessary indicators
  if(!ExtExpert.InitIndicators())
  {
    printf(__FUNCTION__ + ": error initializing indicators");
    ExtExpert.Deinit();
    return(INIT_FAILED);
  }

  return(INIT_SUCCEEDED);
}

//+------------------------------------------------------------------+
//| Deinitialization function of the expert                          |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
  ExtExpert.Deinit();
}

//+------------------------------------------------------------------+
//| "Tick" event handler function                                    |
//+------------------------------------------------------------------+
void OnTick()
{
  ExtExpert.OnTick();
}

//+------------------------------------------------------------------+
//| "Trade" event handler function                                   |
//+------------------------------------------------------------------+
void OnTrade()
{
  ExtExpert.OnTrade();
}

//+------------------------------------------------------------------+
//| "Timer" event handler function                                   |
//+------------------------------------------------------------------+
void OnTimer()
{
  ExtExpert.OnTimer();
}
//+------------------------------------------------------------------+
