﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MQL_Crypto
{
    [Serializable]
    class UserLic : ICloneable
    {
        public UserLic()
        {
            logins = new long[MqlCrypto.COUNTACC];
            Array.Clear(logins, 0, logins.Length);
            uid = 0;
            expired = -1;
            ea_count = 0;
            ea_array = null;
        }
        public long uid { get; set; }
        public long expired { get; set; }
        public int log_count { get; set; }
        public long[] logins { get; set; }
        public int ea_count { get; set; }
        public EaUser[] ea_array { get; set; }

        public object Clone()
        {
            return new UserLic
            {
                uid = this.uid,
                expired = this.expired,
                log_count = this.log_count,
                ea_count = this.ea_count,
                logins = this.logins.Select(x => x).ToArray(),
                ea_array = this.ea_array.Select(x => (EaUser)x.Clone()).ToArray()
            };
        }

        public DateTime GetExpired()
        {
            return MtConverter.ToSharpDateTime(expired);
        }
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder("User:\n");
            sb.AppendFormat(string.Format("ID: {0:D} Expired: {1}\n", uid, GetExpired().ToString("yyyy-MM-dd HH:mm:ss")));
            sb.Append("Accounts:\n");
            for (int i = 0; i < log_count; i++)
                sb.AppendFormat("{0:D3} Acc.: {1:D}\n", i, logins[i]);
            sb.AppendFormat("Ea ({0}):\n", ea_count);
            for (int i = 0; i < ea_count; i++)
                sb.AppendFormat("{0:D3} {1}\n", i, ea_array[i].ToString());
            return sb.ToString();
        }

    }// UserLic
}
