﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Security.Cryptography;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;


namespace MQL_Crypto
{
    class MqlCrypto
    {
        public static int COUNTACC = 5;
        public static int PRODMAXLENGTH = 255;
        public static void Main()
        {
            string skey = "qwertyuiopasdfgh";
            byte[] key  = Encoding.ASCII.GetBytes(s: skey);
            byte[] iv   = new byte[16];
            UserLic u2  = new UserLic();
            u2 = DecryptFromFile_Aes("lic.txt", key, iv);
            Console.WriteLine("Lic: {0}", u2.ToString());

            u2.uid = 1000000;
            EncryptToFile_Aes(u2, "lic_C#.txt", key, iv);

            Array.Resize<byte>(ref key, key.Length + 1);
            key[key.Length-1] = 0;
/************************************* SHA256 ************************************/ 
            using (SHA256 sha = SHA256.Create()) {
                byte[] hs = sha.ComputeHash(buffer: key);
                for (int i = 0; i < hs.Length; i++) {
                    Console.Write($" {hs[i]:X2}");
                }
                using (FileStream fsSha = new FileStream("sha256_c#.bin", FileMode.Create))
                {
                    fsSha.Write(hs, 0, hs.Length);
                }
            }
        }// public static void Main()

        
        static bool EncryptToFile_Aes(UserLic lic, string path, byte[] Key, byte[] IV)
        {

            using (Aes aesAlg = Aes.Create())
            {
                aesAlg.Key = Key;
                aesAlg.IV = IV;
                aesAlg.Mode = CipherMode.ECB;
                aesAlg.Padding = PaddingMode.Zeros;

                ICryptoTransform encryptor = aesAlg.CreateEncryptor(aesAlg.Key, aesAlg.IV);

                using (FileStream msEncrypt = new FileStream(path, FileMode.Create))
                {
                    using (CryptoStream csEncrypt = new CryptoStream(msEncrypt, encryptor, CryptoStreamMode.Write))
                    {
                        using (BinaryWriter swEncrypt = new BinaryWriter(csEncrypt))
                        {
                            swEncrypt.Write(lic.uid);
                            swEncrypt.Write(lic.expired);
                            swEncrypt.Write(lic.log_count);
                            for (int i = 0; i < MqlCrypto.COUNTACC; i++)
                                swEncrypt.Write(lic.logins[i]);
                            swEncrypt.Write(lic.ea_count);
                            if (lic.ea_count > 0)
                            {
                                for (int i = 0; i < lic.ea_count; i++)
                                {
                                    swEncrypt.Write(lic.ea_array[i].expired);
                                    swEncrypt.Write(lic.ea_array[i].namelength);
                                    swEncrypt.Write(lic.ea_array[i].eaname);
                                }//for (int i = 0; i < ul.ea_count; i++)
                            }//if (lic.ea_count > 0)

                            return true;
                        }// using (BinaryWriter swEncrypt = new BinaryWriter(csEncrypt))
                    }// using (CryptoStream csEncrypt = new CryptoStream(msEncrypt, encryptor, CryptoStreamMode.Write))
                }// using (FileStream msEncrypt = new FileStream(path, FileMode.Create))
            }// using (Aes aesAlg = Aes.Create())
            return false;
        }// static bool EncryptToFile_Aes(UserLic lic, string path, byte[] Key, byte[] IV)

        static byte[] EncryptToArray_Aes(UserLic lic, byte[] Key, byte[] IV)
        {

            byte[] encrypted;

            using (Aes aesAlg = Aes.Create())
            {
                aesAlg.Key = Key;
                aesAlg.IV = IV;
                aesAlg.Mode = CipherMode.ECB;
                aesAlg.Padding = PaddingMode.Zeros;

                ICryptoTransform encryptor = aesAlg.CreateEncryptor(aesAlg.Key, aesAlg.IV);

                using (MemoryStream msEncrypt = new MemoryStream())
                {
                    using (CryptoStream csEncrypt = new CryptoStream(msEncrypt, encryptor, CryptoStreamMode.Write))
                    {
                        using (BinaryWriter swEncrypt = new BinaryWriter(csEncrypt))
                        {
                            swEncrypt.Write(lic.uid);
                            swEncrypt.Write(lic.expired);
                            swEncrypt.Write(lic.log_count);
                            for (int i = 0; i < MqlCrypto.COUNTACC; i++)
                                swEncrypt.Write(lic.logins[i]);
                            swEncrypt.Write(lic.ea_count);
                            encrypted = msEncrypt.ToArray();
                        }//using (BinaryWriter swEncrypt = new BinaryWriter(csEncrypt))
                    }//using (CryptoStream csEncrypt = new CryptoStream(msEncrypt, encryptor, CryptoStreamMode.Write))
                }//using (MemoryStream msEncrypt = new MemoryStream())
            }//using (Aes aesAlg = Aes.Create())
            return encrypted;
        }//static byte[] EncryptToArray_Aes(UserLic lic, byte[] Key, byte[] IV)

        static UserLic DecryptFromFile_Aes(string path, byte[] Key, byte[] IV)
        {

            UserLic ul = new UserLic();
            using (Aes aesAlg = Aes.Create())
            {
                aesAlg.Key = Key;
                aesAlg.IV = IV;
                aesAlg.Mode = CipherMode.ECB;
                aesAlg.Padding = PaddingMode.Zeros;

                ICryptoTransform decryptor = aesAlg.CreateDecryptor(aesAlg.Key, aesAlg.IV);

                using (FileStream msDecrypt = new FileStream(path, FileMode.Open))
                {
                    using (CryptoStream csDecrypt = new CryptoStream(msDecrypt, decryptor, CryptoStreamMode.Read))
                    {
                        using (BinaryReader br = new BinaryReader(csDecrypt))
                        {
                            ul.uid = br.ReadInt64();
                            ul.expired = br.ReadInt64();
                            ul.log_count = br.ReadInt32();
                            for (int i = 0; i < MqlCrypto.COUNTACC; i++)
                                ul.logins[i] = br.ReadInt64();
                            ul.ea_count = br.ReadInt32();
                            if (ul.ea_count > 0)
                            {
                                ul.ea_array = new EaUser[ul.ea_count];
                                for (int i = 0; i < ul.ea_count; i++)
                                {
                                    ul.ea_array[i] = new EaUser();
                                    ul.ea_array[i].expired =  br.ReadInt64();
                                    ul.ea_array[i].namelength = br.ReadInt32();
                                    ul.ea_array[i].eaname =  br.ReadChars(MqlCrypto.PRODMAXLENGTH);
                                }//for (int i = 0; i < ul.ea_count; i++)
                            }//if (ul.ea_count > 0)
                        }//using (BinaryReader br = new BinaryReader(csDecrypt))
                    }//using (CryptoStream csDecrypt = new CryptoStream(msDecrypt, decryptor, CryptoStreamMode.Read))
                }//using (FileStream msDecrypt = new FileStream(path, FileMode.Open))
                return ul;
            }//using (Aes aesAlg = Aes.Create())
        }// static UserLic DecryptFromFile_Aes(string path, byte[] Key, byte[] IV)
        static UserLic DecryptFromArray_Aes(byte[] cipherText, byte[] Key, byte[] IV)
        {

            UserLic ul = new UserLic();
            using (Aes aesAlg = Aes.Create())
            {
                aesAlg.Key = Key;
                aesAlg.IV = IV;
                aesAlg.Mode = CipherMode.ECB;
                aesAlg.Padding = PaddingMode.Zeros;

                ICryptoTransform decryptor = aesAlg.CreateDecryptor(aesAlg.Key, aesAlg.IV);

                using (MemoryStream msDecrypt = new MemoryStream(cipherText))
                {
                    using (CryptoStream csDecrypt = new CryptoStream(msDecrypt, decryptor, CryptoStreamMode.Read))
                    {
                        using (BinaryReader br = new BinaryReader(csDecrypt))
                        {
                            ul.uid = br.ReadInt64();
                            ul.expired = br.ReadInt64();
                            ul.log_count = br.ReadInt32();
                            for (int i = 0; i < MqlCrypto.COUNTACC; i++)
                                ul.logins[i] = br.ReadInt64();
                            ul.ea_count = br.ReadInt32();
                        }//using (BinaryReader br = new BinaryReader(csDecrypt))
                    }//using (CryptoStream csDecrypt = new CryptoStream(msDecrypt, decryptor, CryptoStreamMode.Read))
                }//using (MemoryStream msDecrypt = new MemoryStream(cipherText))
                return ul;
            }//using (Aes aesAlg = Aes.Create())
        }//static UserLic DecryptFromArray_Aes(byte[] cipherText, byte[] Key, byte[] IV)
    }//class MqlCrypto
}//namespace MQL_Crypto
