﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MQL_Crypto
{
    /// <summary>
    /// System Converter MetaTrader - C# 
    /// https://www.mql5.com/ru/articles/6549
    /// </summary>
    public static class MtConverter
    {
        /// <summary>
        /// Convert C# DateTime format to MQL (POSIX) DateTime format.
        /// </summary>
        /// <param name="date_time"></param>
        /// <returns></returns>
        public static long ToMqlDateTime(DateTime date_time)
        {
            if (date_time < tiks_1970)
                return 0;
            TimeSpan time_delta = date_time - tiks_1970;
            return (long)Math.Floor(time_delta.TotalSeconds);
        }
        /// <summary>
        /// Convert MQL (Posix) time format to sharp DateTime value.
        /// </summary>
        /// <param name="mql_time">MQL datetime as tiks</param>
        /// <returns></returns>
        public static DateTime ToSharpDateTime(long mql_time)
        {
            if (mql_time <= 0 || mql_time > int.MaxValue)
                return tiks_1970;
            TimeSpan time_delta = new TimeSpan(0, 0, (int)mql_time);
            DateTime sharp_time = tiks_1970 + time_delta;
            return sharp_time;
        }
        private static DateTime tiks_1970 = new DateTime(1970, 01, 01);
    }
}
