//+------------------------------------------------------------------+
//|                                               EAElementsDemo.mq5 |
//|                        Copyright 2018, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2018, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#import  "MtGuiController.dll"
string assembly = "c:\\Users\\Bazil\\source\\repos\\DemoForm\\DemoForm\\bin\\Debug\\DemoForm.exe";
enum ENUM_WINFORM_ELEMENT_TYPE
{
   WINFORM_BUTTON,      // Buttons And MessageBox
   WINFORM_TAB,         // TabControl
   WINFORM_CHECK_BOX,   // CheckBox
   WINFORM_RADIO_BTN,   // Radio Button
   WINFORM_COMBO_BOX,   // ComboBox
   WINFORM_NUMERIC,     // NumericUpDown
   WINFORM_HIDE,        // Hide/Show Winform
   WINFORM_TIME_PICKER, // DateTimePicker
};

input ENUM_WINFORM_ELEMENT_TYPE ElementType = WINFORM_NUMERIC; // Windows Form Element Type
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
{
   if(ElementType != WINFORM_HIDE)
      EventSetMillisecondTimer(100);
   else
      EventSetMillisecondTimer(1000);
   switch(ElementType)
   {
      case WINFORM_TAB:
         GuiController::ShowForm(assembly, "TabForm");
         break;
      case WINFORM_CHECK_BOX:
         GuiController::ShowForm(assembly, "CheckBoxForm");
         ChangeEnableStopAndProfit("EURUSDEnable", CheckBoxChange, 0, 0.0, "");
         ChangeEnableStopAndProfit("GBPUSDEnable", CheckBoxChange, 0, 0.0, "");
         break;
      case WINFORM_RADIO_BTN:
         GuiController::ShowForm(assembly, "RadioButtonsForm");
         break;
      case WINFORM_BUTTON:
         GuiController::ShowForm(assembly, "ButtonForm");
         break;
      case WINFORM_COMBO_BOX:
         GuiController::ShowForm(assembly, "DropDownForm");
         GuiController::SendEvent("comboBox2", ElementEnable, 0, 0.0, "");
         break;
      case WINFORM_NUMERIC:
      {
         GuiController::ShowForm(assembly, "NumericForm");
         GuiController::SendEvent("StopLoss", AddItem, 0, 0.0, "New Text");
         double ask = SymbolInfoDouble(Symbol(), SYMBOL_ASK);
         double bid = SymbolInfoDouble(Symbol(), SYMBOL_BID);
         double price_step = NormalizeDouble(SymbolInfoDouble(Symbol(), SYMBOL_TRADE_TICK_SIZE), Digits());
         long digits = (long)Digits();
         GuiController::SendEvent("NumericForm", TextChange, 0, 0.0, "NumericForm (" + Symbol() + ")");
         NumericSet("StopLoss", Digits(), ask, (double)LONG_MAX, 0.0, price_step);
         NumericSet("TakeProfit", Digits(), bid, (double)LONG_MAX, 0.0, price_step);
         break;
      }
      case WINFORM_HIDE:
         GuiController::ShowForm(assembly, "HideShowForm");
         break;
      case WINFORM_TIME_PICKER:
         GuiController::ShowForm(assembly, "DateTimeForm");
   }
   return(INIT_SUCCEEDED);
}

//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   EventKillTimer();   
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
{   
   
}
//+------------------------------------------------------------------+
//| Timer function                                                   |
//+------------------------------------------------------------------+
void OnTimer()
{   
   //-- get new events by timer
   for(static int i = 0; i < GuiController::EventsTotal(); i++)
   {
      int id;
      string el_name;
      long lparam;
      double dparam;
      string sparam;
      GuiController::GetEvent(i, el_name, id, lparam, dparam, sparam);
      if(id == TabIndexChange)
         printf("Selecet new tab. Index: " + (string)lparam + " Name: " + sparam);
      if(id == CheckBoxChange)
      {
         printf("Checked " + sparam + " " + lparam);
         ChangeEnableStopAndProfit(el_name, id, lparam, dparam, sparam);
         }
      else if(id == ClickOnElement)
      {
         printf("You press '" + sparam + "' button");
         string msg;
         if(el_name != "btnCancelAll")
            msg = "?|Are you sure you want to open a new " + sparam + " position?|Confirm action";
         else
            msg = "!|Are you sure you want to close all positions?|Close all?";
         //GuiController::SendEvent("ButtonForm", MessageBox, LockControl, YesNoCancel, msg);
         GuiController::SendEvent("ButtonForm", MessageBox, LockControl, OK, "!!!|The operation was cancelled|Critical Error");
      }
      else if(id == ComboBoxChange)
      {
         if(el_name == "comboBox1")
            GuiController::SendEvent("comboBox2", ElementEnable, 1, 0.0, "");
         printf("ComboBox '" + el_name + "' was changed on " + sparam);
      }
      else if(id == RadioButtonChange)
      {
         if(lparam == true)
            printf("Your have selected " + sparam);
         else
            printf("Your have deselected " + sparam);
      }
      else if(id == NumericChange)
         printf("Numeric '" + el_name + "' was changed, new value: " + DoubleToString(dparam, 4));
      else if(id == DateTimePickerChange)
         printf("User set new datetime value: " + TimeToString((datetime)lparam));
      else if(id == Exception)
         printf("Unexpected exception: " + sparam);
      
   }
   if (ElementType == WINFORM_HIDE)
   {
      long tiks = TimeCurrent();
      if(tiks%4 == 0)
         GuiController::SendEvent("HideGroup", ElementHide, true, 0.0, "");
      else if(tiks%2 == 0)
         GuiController::SendEvent("HideGroup", ElementHide, false, 0.0, "");
   }
}
//+------------------------------------------------------------------+
//| Change enable stops and profit                                   |
//+------------------------------------------------------------------+
void ChangeEnableStopAndProfit(string el_name, int id, long lparam, double dparam, string sparam)
{
   int id_enable = ElementEnable;
   if(el_name == "EURUSDEnable")
   {
      GuiController::SendEvent("EURUSDProfit", id_enable, lparam, dparam, sparam);
      GuiController::SendEvent("EURUSDStop", id_enable, lparam, dparam, sparam);
   }
   else if(el_name == "GBPUSDEnable")
   {
      GuiController::SendEvent("GBPUSDProfit", id_enable, lparam, dparam, sparam);
      GuiController::SendEvent("GBPUSDStop", id_enable, lparam, dparam, sparam);
   }
}
//+------------------------------------------------------------------+
//| Set NumericUpDownParameter                                       |
//| name - name of NumericUpDown element                             |
//| digits - digits of symbol                                        |
//| init - init double value                                         |
//| max - max value                                                  |
//| min - min value                                                  |
//| step - step of change                                            |
//+------------------------------------------------------------------+
void NumericSet(string name, long digits, double init, double max, double min, double step)
{
   int id_foramt_change = NumericFormatChange;
   int id_change = NumericChange;
   int id_max = NumericMaxChange;
   int id_min = NumericMinChange;
   long lparam = 0;
   double dparam = 0.0;
   string sparam = "";
   GuiController::SendEvent(name, id_max, lparam, max, sparam);
   GuiController::SendEvent(name, id_min, lparam, min, sparam);
   GuiController::SendEvent(name, id_change, lparam, init, sparam);
   GuiController::SendEvent(name, id_foramt_change, digits, step, sparam);
}
//+------------------------------------------------------------------+
