// SendSomeMail.cpp : Defines the exported functions for the DLL application.
//

#include "stdafx.h"
#include "SendSomeMail.h"
#include <atlbase.h>

#import "C:\\program files\\common files\\system\\ado\\msado25.tlb" no_namespace auto_rename
#import "c:\\windows\\system32\\cdosys.dll" auto_rename



SENDSOMEMAIL_API bool  SendSomeMail(LPCWSTR addr_from,
	LPCWSTR addr_to,
	LPCWSTR subject, 
	LPCWSTR text_body,

	LPCWSTR smtp_server,
	LPCWSTR smtp_user,
	LPCWSTR smtp_password)
{
	CoInitialize(NULL);
	bool b = false;
	try {
		CDO::IMessagePtr msg;
		msg.CreateInstance(__uuidof(CDO::Message));

		FieldsPtr conf_fields = msg->Configuration->Fields;

		// original from address
		conf_fields->Item[L"http://schemas.microsoft.com/cdo/configuration/sendemailaddress"]->Value = addr_from;

		// SMTP settings - using standard port 25 on host smtp
		conf_fields->Item["http://schemas.microsoft.com/cdo/configuration/sendusing"]->Value = CDO::cdoSendUsingPort;
		conf_fields->Item["http://schemas.microsoft.com/cdo/configuration/smtpserverport"]->Value = 25L;
		conf_fields->Item["http://schemas.microsoft.com/cdo/configuration/smtpserver"]->Value = smtp_server;
		conf_fields->Item["http://schemas.microsoft.com/cdo/configuration/smtpusessl"]->Value = true;

		// SMTP settings - basic authentication
		conf_fields->Item["http://schemas.microsoft.com/cdo/configuration/smtpauthenticate"]->Value = CDO::cdoBasic;
		conf_fields->Item["http://schemas.microsoft.com/cdo/configuration/sendusername"]->Value = smtp_user;
		conf_fields->Item["http://schemas.microsoft.com/cdo/configuration/sendpassword"]->Value = smtp_password;

		conf_fields->Update();

		msg->From = addr_from;
		msg->To = addr_to;
		msg->Subject = subject;
		msg->TextBody = text_body;

		HRESULT hr = msg->Send();
		if (SUCCEEDED(hr)) b = true;
	}
	catch (_com_error& e)
	{
//		std::cout << "exception...." << e.Description() << std::endl;
	}
	CoUninitialize();

	return b;

}


