//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2018, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
#property copyright "Copyright 2018, anddycabrera@gmail.com."
#property link      "https://www.mql5.com/en/users/waygrow"
#property version   "1.00"   
#property strict

#include <stdlib.mqh>
#include <DeepNeuralNetwork.mqh> 

int numInput=4;
int numHiddenA = 4;
int numHiddenB = 5;
int numOutput=3;

DeepNeuralNetwork dnn(numInput,numHiddenA,numHiddenB,numOutput);

//--- weight values
input double w0=1.0;
input double w1=1.0;
input double w2=1.0;
input double w3=1.0;
input double w4=1.0;
input double w5=1.0;
input double w6=1.0;
input double w7=1.0;
input double w8=1.0;
input double w9=1.0;
input double w10=1.0;
input double w11=1.0;
input double w12=1.0;
input double w13=1.0;
input double w14=1.0;
input double w15=1.0;
input double b0=1.0;
input double b1=1.0;
input double b2=1.0;
input double b3=1.0;
input double w40=1.0;
input double w41=1.0;
input double w42=1.0;
input double w43=1.0;
input double w44=1.0;
input double w45=1.0;
input double w46=1.0;
input double w47=1.0;
input double w48=1.0;
input double w49=1.0;
input double w50=1.0;
input double w51=1.0;
input double w52=1.0;
input double w53=1.0;
input double w54=1.0;
input double w55=1.0;
input double w56=1.0;
input double w57=1.0;
input double w58=1.0;
input double w59=1.0;
input double b4=1.0;
input double b5=1.0;
input double b6=1.0;
input double b7=1.0;
input double b8=1.0;
input double w60=1.0;
input double w61=1.0;
input double w62=1.0;
input double w63=1.0;
input double w64=1.0;
input double w65=1.0;
input double w66=1.0;
input double w67=1.0;
input double w68=1.0;
input double w69=1.0;
input double w70=1.0;
input double w71=1.0;
input double w72=1.0;
input double w73=1.0;
input double w74=1.0;
input double b9=1.0;
input double b10=1.0;
input double b11=1.0;

input double Lot=0.1;

input string expertcomment="";//Expert Comment
input int order_magic=55555;//MagicNumber

double            _xValues[4];   // array for storing inputs
double            weight[63];   // array for storing weights

string            my_symbol;    // variable for storing the symbol
ENUM_TIMEFRAMES   my_timeframe; // variable for storing the time frame
double            lot_size;     // variable for storing the minimum lot size of the transaction to be performed
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnInit()
  {
   my_symbol=Symbol();
   my_timeframe=PERIOD_CURRENT;
   lot_size=Lot;

   weight[0]=w0;
   weight[1]=w1;
   weight[2]=w2;
   weight[3]=w3;
   weight[4]=w4;
   weight[5]=w5;
   weight[6]=w6;
   weight[7]=w7;
   weight[8]=w8;
   weight[9]=w9;
   weight[10]=w10;
   weight[11]=w11;
   weight[12]=w12;
   weight[13]=w13;
   weight[14]=w14;
   weight[15]=w15;
   weight[16]=b0;
   weight[17]=b1;
   weight[18]=b2;
   weight[19]=b3;
   weight[20]=w40;
   weight[21]=w41;
   weight[22]=w42;
   weight[23]=w43;
   weight[24]=w44;
   weight[25]=w45;
   weight[26]=w46;
   weight[27]=w47;
   weight[28]=w48;
   weight[29]=w49;
   weight[30]=w50;
   weight[31]=w51;
   weight[32]=w52;
   weight[33]=w53;
   weight[34]=w54;
   weight[35]=w55;
   weight[36]=w56;
   weight[37]=w57;
   weight[38]=w58;
   weight[39]=w59;
   weight[40]=b4;
   weight[41]=b5;
   weight[42]=b6;
   weight[43]=b7;
   weight[44]=b8;
   weight[45]=w60;
   weight[46]=w61;
   weight[47]=w62;
   weight[48]=w63;
   weight[49]=w64;
   weight[50]=w65;
   weight[51]=w66;
   weight[52]=w67;
   weight[53]=w68;
   weight[54]=w69;
   weight[55]=w70;
   weight[56]=w71;
   weight[57]=w72;
   weight[58]=w73;
   weight[59]=w74;
   weight[60]=b9;
   weight[61]=b10;
   weight[62]=b11;

//--- return 0, initialization complete
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
   MqlRates rates[];
   ArraySetAsSeries(rates,true);
   int copied=CopyRates(_Symbol,0,1,5,rates);

//compute the percent of the upper shadow, lower shadow and body in base of sum 100%
   int error=CandlePatterns(rates[0].high,rates[0].low,rates[0].open,rates[0].close,rates[0].close-rates[0].open,_xValues);

   if(error<0)return;

   dnn.SetWeights(weight);

   double yValues[];
   dnn.ComputeOutputs(_xValues,yValues);

//--- if the output value of the neuron is mare than 60%
   if(yValues[0]>0.6)
     {

      if(SellMarketCount(Symbol(),order_magic)>0)//check if there is an open position         
         CloseAllSellOrders(Symbol(),order_magic,500);//Close the opposite position if exists

      if(BuyMarketCount(Symbol(),order_magic)>0) return;

      int tikect=0;
      lot_size=VerifyLotSize(lot_size);
      string errorvol="";
      if(CheckVolumeValue(lot_size,errorvol))
        {
         if(CheckMoneyForTrade(Symbol(),lot_size,OP_BUY))
           {
            tikect=OpenBuyOrder(Symbol(),lot_size,500,order_magic,expertcomment);//open a Long position
           }
        }
      else
        {
         Print(errorvol);
        }

     }
//--- if the output value of the neuron is mare than 60%
   if(yValues[1]>0.6)
     {
      if(BuyMarketCount(Symbol(),order_magic)>0)//check if there is an open position
         CloseAllBuyOrders(Symbol(),order_magic,500);//Close the opposite position if exists
      if(SellMarketCount(Symbol(),order_magic)>0) return;

      int tikect=0;
      lot_size=VerifyLotSize(lot_size);
      string errorvol="";
      if(CheckVolumeValue(lot_size,errorvol))
        {
         if(CheckMoneyForTrade(Symbol(),lot_size,OP_SELL))
           {
            tikect=OpenSellOrder(Symbol(),lot_size,500,order_magic,expertcomment);//open a Short position
           }
        }
      else
        {
         Print(errorvol);
        }
     }

   if(yValues[2]>0.6)
     {
      if(BuyMarketCount(Symbol(),order_magic)>0)//check if there is an open position
         CloseAllBuyOrders(Symbol(),order_magic,500);//Close the opposite position if exists
      if(SellMarketCount(Symbol(),order_magic)>0)//check if there is an open position         
         CloseAllSellOrders(Symbol(),order_magic,500);//Close the opposite position if exists

     }

  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OpenBuyOrder(string argSymbol,double argLotSize,int argSlippage,int argMagicNumber,string argComment="Buy Order")
  {
   while(IsTradeContextBusy()) Sleep(10);

// Place Buy Order
   int Ticket=OrderSend(argSymbol,OP_BUY,argLotSize,MarketInfo(argSymbol,MODE_ASK),argSlippage,0,0,argComment,argMagicNumber,0,Green);

// Error Handling
   if(Ticket==-1)
     {
      int ErrorCode=GetLastError();
      string ErrDesc=ErrorDescription(ErrorCode);

      string ErrAlert=StringConcatenate("Open Buy Order - Error	",ErrorCode,": ",ErrDesc);
      Print(ErrAlert);

      string ErrLog=StringConcatenate("Bid: ",MarketInfo(argSymbol,MODE_BID)," Ask: ",MarketInfo(argSymbol,MODE_ASK)," Lots: ",argLotSize);
      Print(ErrLog);
     }

   return(Ticket);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OpenSellOrder(string argSymbol,double argLotSize,int argSlippage,int argMagicNumber,string argComment="Sell Order")
  {
   while(IsTradeContextBusy()) Sleep(10);

// Place Sell Order
   int Ticket=OrderSend(argSymbol,OP_SELL,argLotSize,MarketInfo(argSymbol,MODE_BID),argSlippage,0,0,argComment,argMagicNumber,0,Red);

// Error Handling
   if(Ticket==-1)
     {
      int ErrorCode=GetLastError();
      string ErrDesc=ErrorDescription(ErrorCode);

      string ErrAlert=StringConcatenate("Open Sell Order - Error ",ErrorCode,": ",ErrDesc);
      Print(ErrAlert);

      string ErrLog=StringConcatenate("Bid: ",MarketInfo(argSymbol,MODE_BID)," Ask: ",MarketInfo(argSymbol,MODE_ASK)," Lots: ",argLotSize);
      Print(ErrLog);
     }

   return(Ticket);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CloseAllBuyOrders(string argSymbol,int argMagicNumber,int argSlippage)
  {
   for(int Counter=0; Counter<=OrdersTotal()-1; Counter++)
     {
      int res=OrderSelect(Counter,SELECT_BY_POS);

      if(OrderMagicNumber()==argMagicNumber && OrderSymbol()==argSymbol && OrderType()==OP_BUY)
        {
         // Close Order
         int CloseTicket=OrderTicket();
         double CloseLots=OrderLots();

         while(IsTradeContextBusy()) Sleep(10);

         double ClosePrice=MarketInfo(argSymbol,MODE_BID);

         bool Closed=OrderClose(CloseTicket,CloseLots,ClosePrice,argSlippage,Red);

         // Error Handling
         if(Closed==false)
           {
            int ErrorCode=GetLastError();
            string ErrDesc=ErrorDescription(ErrorCode);

            string ErrAlert=StringConcatenate("Close All Buy Orders - Error ",ErrorCode,": ",ErrDesc);
            Print(ErrAlert);

            string ErrLog=StringConcatenate("Bid: ",MarketInfo(argSymbol,MODE_BID)," Ticket: ",CloseTicket," Price: ",ClosePrice);
            Print(ErrLog);
           }
         else Counter--;
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CloseAllSellOrders(string argSymbol,int argMagicNumber,int argSlippage)
  {
   for(int Counter=0; Counter<=OrdersTotal()-1; Counter++)
     {
      int res=OrderSelect(Counter,SELECT_BY_POS);

      if(OrderMagicNumber()==argMagicNumber && OrderSymbol()==argSymbol && OrderType()==OP_SELL)
        {
         // Close Order
         int CloseTicket=OrderTicket();
         double CloseLots=OrderLots();

         while(IsTradeContextBusy()) Sleep(10);

         double ClosePrice=MarketInfo(argSymbol,MODE_ASK);

         bool Closed=OrderClose(CloseTicket,CloseLots,ClosePrice,argSlippage,Red);

         // Error Handling
         if(Closed==false)
           {
            int ErrorCode=GetLastError();
            string ErrDesc=ErrorDescription(ErrorCode);

            string ErrAlert=StringConcatenate("Close All Sell Orders - Error ",ErrorCode,": ",ErrDesc);
            Print(ErrAlert);

            string ErrLog=StringConcatenate("Ask: ",MarketInfo(argSymbol,MODE_ASK)," Ticket: ",CloseTicket," Price: ",ClosePrice);
            Print(ErrLog);
           }
         else Counter--;
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int BuyMarketCount(string argSymbol,int argMagicNumber)
  {
   int OrderCount=0;
   for(int Counter=0; Counter<=OrdersTotal()-1; Counter++)
     {
      int x=OrderSelect(Counter,SELECT_BY_POS);
      if(OrderMagicNumber()==argMagicNumber && OrderSymbol()==argSymbol && OrderType()==OP_BUY)
        {
         OrderCount++;
        }
     }
   return(OrderCount);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int SellMarketCount(string argSymbol,int argMagicNumber)
  {
   int OrderCount=0;
   for(int Counter=0; Counter<=OrdersTotal()-1; Counter++)
     {
      int x=OrderSelect(Counter,SELECT_BY_POS);
      if(OrderMagicNumber()==argMagicNumber && OrderSymbol()==argSymbol && OrderType()==OP_SELL)
        {
         OrderCount++;
        }
     }
   return(OrderCount);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int MarketCount(string argSymbol,int argMagicNumber)
  {
   int OrderCount=0;
   for(int Counter=0; Counter<=OrdersTotal()-1; Counter++)
     {
      int x=OrderSelect(Counter,SELECT_BY_POS);
      if(OrderMagicNumber()==argMagicNumber && OrderSymbol()==argSymbol && OrderType()<2)
        {
         OrderCount++;
        }
     }
   return(OrderCount);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double VerifyLotSize(double argLotSize)
  {
   if(argLotSize<MarketInfo(Symbol(),MODE_MINLOT))
     {
      argLotSize=MarketInfo(Symbol(),MODE_MINLOT);
     }
   else if(argLotSize>MarketInfo(Symbol(),MODE_MAXLOT))
     {
      argLotSize=MarketInfo(Symbol(),MODE_MAXLOT);
     }

   if(MarketInfo(Symbol(),MODE_LOTSTEP)==0.1)
     {
      argLotSize=NormalizeDouble(argLotSize,1);
     }
   else argLotSize=NormalizeDouble(argLotSize,2);

   return(argLotSize);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CheckMoneyForTrade(string symb,double lots,int type)
  {
   double free_margin=AccountFreeMarginCheck(symb,type,lots);
//-- if there is not enough money
   if(free_margin<0)
     {
      string oper=(type==OP_BUY)? "Buy":"Sell";
      Print("Not enough money for ",oper," ",lots," ",symb," Error code=",GetLastError());
      return(false);
     }
//--- checking successful
   return(true);
  }
//+------------------------------------------------------------------+
//| Check the correctness of the order volume                        |
//+------------------------------------------------------------------+
bool CheckVolumeValue(double volume,string &description)
  {
//--- minimal allowed volume for trade operations
   double min_volume=SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MIN);
   if(volume<min_volume)
     {
      description=StringFormat("Volume is less than the minimal allowed SYMBOL_VOLUME_MIN=%.2f",min_volume);
      return(false);
     }

//--- maximal allowed volume of trade operations
   double max_volume=SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MAX);
   if(volume>max_volume)
     {
      description=StringFormat("Volume is greater than the maximal allowed SYMBOL_VOLUME_MAX=%.2f",max_volume);
      return(false);
     }

//--- get minimal step of volume changing
   double volume_step=SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_STEP);

   int ratio=(int)MathRound(volume/volume_step);
   if(MathAbs(ratio*volume_step-volume)>0.0000001)
     {
      description=StringFormat("Volume is not a multiple of the minimal step SYMBOL_VOLUME_STEP=%.2f, the closest correct volume is %.2f",
                               volume_step,ratio*volume_step);
      return(false);
     }
   description="Correct volume value";
   return(true);
  }
//+------------------------------------------------------------------+
//|percentage of each part of the candle respecting total size       |
//+------------------------------------------------------------------+
int CandlePatterns(double high,double low,double open,double close,double uod,double &xInputs[])
  {
   double p100=high-low;
   double highPer=0;
   double lowPer=0;
   double bodyPer=0;
   double trend=0;

   if(uod>0)
     {
      highPer=high-close;
      lowPer=open-low;
      bodyPer=close-open;
      trend=1;

     }
   else
     {
      highPer=high-open;
      lowPer=close-low;
      bodyPer=open-close;
      trend=0;
     }
   if(p100==0)return(-1);
   xInputs[0]=highPer/p100;
   xInputs[1]=lowPer/p100;
   xInputs[2]=bodyPer/p100;
   xInputs[3]=trend;

   return(1);

  }
//+------------------------------------------------------------------+
