//+------------------------------------------------------------------+
//|                                        TrailingStopVariation.mq5 |
//|                                   Copyright 2011, Grebenev Slava |
//|                                         http://grebenev.narod.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, Grebenev Slava"
//--- input parameters
#define              OrderNumber 1
#define              NTime 10000             // maximum number of trades per pass
#define              N 5                     // number of bars for calculation of the average bar size
#define              Nvolatil 5
input int            SL=500;                 // trailing stop expressed as a percentage of the average bar size
int                  digits;                 // number of digits after the decimal point in the price
enum                 lastdeal {no,buy,sell}; // variable for storing the direction of the last trade (buy or sell)
lastdeal             ld     =buy;
datetime             BarTime=D'01.01.1971';  // time of the last bar 
int                  filehandle;
datetime             Time[NTime];
double               LastProfit[NTime];
double               LP=0;
int                  Itime=1;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   SymbolSelect(_Symbol,true);
//--- number of digits after the decimal point in the price
   digits=(int)SymbolInfoInteger(Symbol(),SYMBOL_DIGITS);
   ArrayInitialize(Time,D'01.01.2004');
   ArrayInitialize(LastProfit,0.0);
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//--- this code writes the trade results into a file. 
//--- it is better not to include it unless really necessary - it saves time and hard drive space
/*   ResetLastError();
   filehandle=FileOpen("fractals.csv",FILE_READ|FILE_WRITE|FILE_CSV|FILE_SHARE_WRITE);
   FileSeek(filehandle, 0, SEEK_END);
   if(filehandle!=INVALID_HANDLE)
     {
      //FileWrite(filehandle,TimeCurrent(),Symbol());
      for (int i=2;i<Itime;i++)  FileWrite(filehandle,Time[i],MathRound(LastProfit[i]));
      FileClose(filehandle);
      Print("FileOpen OK");
     }
   else Print("FileOpen action failed. Error ",GetLastError());
 */
   return;
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//--- monitoring the position
   if(NewBar()) if(!PositionSelect(Symbol()))
     {
      if(Itime<NTime)
        {
         Time[Itime]=TimeCurrent();
         LastProfit[Itime]=AccountInfoDouble(ACCOUNT_BALANCE)-LP;
         LP=AccountInfoDouble(ACCOUNT_BALANCE);
         Itime++;
        };
      Start();
     };
//--- moving the trailing stop
   TrailingStop();
   return;
  }
//+------------------------------------------------------------------+
//| It returns true, if the bar has just begun                     |
//+------------------------------------------------------------------+
bool NewBar()
  {
   datetime New_Time[1];
//--- copying the current bar time into the New_Time[0] element
   int copied=CopyTime(_Symbol,_Period,0,1,New_Time);
//--- ok, copying successfully completed
   if(copied>0)
     {
      //--- if the old time is not equal
      if(BarTime!=New_Time[0])
        {
         if(MQL5InfoInteger(MQL5_DEBUGGING)) Print("New bar",New_Time[0],"old bar",BarTime);
         //--- saving the bar time
         BarTime=New_Time[0];
         return(true);
        }
     }
   else
     {
      Alert("Error when copying the time value, error number =",GetLastError());
      ResetLastError();
      return(false);
     }
   return(false);
  }
//+------------------------------------------------------------------+
//| Choosing the direction to enter the market                               |
//+------------------------------------------------------------------+
bool Direction()
  {
//--- bool r=(rand()>32768/2);      // choosing a random direction of the price movement
//--- return(r);
//--- reverse entry
   if(ld==buy) {ld=sell; return(false);};
   if(ld==sell) {ld=buy; return(true);};
   return(true);
  }
//+------------------------------------------------------------------+
//| Opening a position                                                |
//+------------------------------------------------------------------+
void Start()
  {
   double beta=0;
//--- buying or selling depending on the direction chosen
   if(Direction())
     {
      //--- trading using the minimum fixed lot
      beta=0.1;
      SendBuyOrder(beta);
     }
   else
     {
      beta=0.1;
      SendSellOrder(beta);
     }
   return;
  }
//+------------------------------------------------------------------+
//| TrailingStop - moves the take profit                              |
//+------------------------------------------------------------------+
void TrailingStop()
  {
   double ArrayHigh[N];
   double ArrayLow[N];
   CopyHigh(Symbol(),Period(),0,N,ArrayHigh);
   CopyLow(Symbol(),Period(),0,N,ArrayLow);
   double LastHeight=0;
   double LastPrice=SymbolInfoDouble(Symbol(),SYMBOL_LAST);
   for(int i=0; i<N; i++) LastHeight=LastHeight+ArrayHigh[i]-ArrayLow[i];
//--- calculating the average size of the last N bars
   LastHeight=LastHeight/N;

   if(PositionSelect(Symbol()))
     {
      if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_BUY)
        {
         if(MathAbs(LastPrice-PositionGetDouble(POSITION_SL))>LastHeight*SL/100*1.01)
           {
            //--- preparing a request
            MqlTradeRequest request;
            ZeroMemory(request);
            //--- placing an immediate order
            request.action=TRADE_ACTION_SLTP;
            //--- instrument
            request.symbol=Symbol();
            //--- Stop Loss 
            request.sl=NormalizeDouble(LastPrice-LastHeight*SL/100,digits);
            //--- Take Profit is not specified
            request.tp=0;

            MqlTradeResult result;
            ZeroMemory(result);
            MqlTradeCheckResult CheckResult;
            //--- sending the order
            if(OrderCheck(request,CheckResult)) {OrderSend(request,result);}
            else
              {
               //--- printing the server response to the log  
               Print(CheckResult.retcode,"  -error ");
               Print(request.sl,"  ",LastPrice,"  buy  ",LastHeight);
               Print(__FUNCTION__,":",CheckResult.comment);
              };
           }
        };
      if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_SELL)
         if(MathAbs(PositionGetDouble(POSITION_SL)-LastPrice)>LastHeight*SL/100*1.01)
           {
            //--- preparing a request
            MqlTradeRequest request;
            ZeroMemory(request);
            //--- placing an immediate order
            request.action=TRADE_ACTION_SLTP;
            //--- instrument
            request.symbol=Symbol();
            //--- Stop Loss
            request.sl=NormalizeDouble(LastPrice+LastHeight*SL/100,digits);
            //--- Take Profit is not specified
            request.tp=0;

            MqlTradeResult result;
            ZeroMemory(result);
            MqlTradeCheckResult CheckResult;
            //--- sending the order
            if(OrderCheck(request,CheckResult)) {OrderSend(request,result);}
            else
              {
               //--- printing the server response to the log  
               Print(CheckResult.retcode,"  -error ");
               Print(request.sl,"  ",LastPrice,"  sell  ",LastHeight);
               Print(__FUNCTION__,":",CheckResult.comment);
              };
           }
     }
   return;
  }
//+------------------------------------------------------------------+
//| SendBuyOrder - placing a buy order                      |
//+------------------------------------------------------------------+
void SendBuyOrder(double bet)
  {
   MqlTick last_tick;
   if(SymbolInfoTick(Symbol(),last_tick))
     {
      //--- preparing a request
      MqlTradeRequest request;
      ZeroMemory(request);
      //--- placing an immediate order
      request.action=TRADE_ACTION_DEAL;
      //--- ORDER_MAGIC
      request.magic=OrderNumber;
      //--- instrument
      request.symbol=_Symbol;
      //--- volume 
      request.volume=bet;
      request.price=last_tick.ask;
      //--- Stop Loss is not specified
      request.sl=0;
      //--- Take Profit is not specified
      request.tp=0;
      //--- order type
      request.type=ORDER_TYPE_BUY;
      MqlTradeResult result;
      ZeroMemory(result);
      MqlTradeCheckResult CheckResult;
      //--- sending the order
      if(OrderCheck(request,CheckResult)) OrderSend(request,result);
      //--- printing the server response to the log  
      else Print(__FUNCTION__,":",result.comment);
     }
   else Print("SymbolInfoTick() failed, error = ",GetLastError());
   return;
  }
//+------------------------------------------------------------------+
//| SendSellOrder - placing a sell order                     |
//+------------------------------------------------------------------+
void SendSellOrder(double bet)
  {
   MqlTick last_tick;
   if(SymbolInfoTick(_Symbol,last_tick))
     {
      //--- preparing a request
      MqlTradeRequest request;
      ZeroMemory(request);
      //--- placing an immediate order
      request.action=TRADE_ACTION_DEAL;
      //--- ORDER_MAGIC
      request.magic=OrderNumber;
      //--- instrument
      request.symbol=_Symbol;
      //--- volume 
      request.volume=bet;
      request.price=last_tick.bid;
      //--- Stop Loss is not specified
      request.sl=0;
      //--- Take Profit is not specified
      request.tp=0;
      //--- order type
      request.type=ORDER_TYPE_SELL;
      MqlTradeResult result;
      ZeroMemory(result);
      MqlTradeCheckResult CheckResult;
      //--- sending the trade order
      if(OrderCheck(request,CheckResult)) OrderSend(request,result);
      //--- printing the server response to the log  
      else Print(__FUNCTION__,":",result.comment);
     }
   else Print("SymbolInfoTick() failed, error = ",GetLastError());
   return;
  }
//+------------------------------------------------------------------+
