//+------------------------------------------------------------------+
//|                                                        BWMFI.mqh |
//|                                              Copyright 2017, DNG |
//|                                 http://www.mql5.com/en/users/dng |
//+------------------------------------------------------------------+
#property copyright "Copyright 2017, DNG"
#property link      "http://www.mql5.com/en/users/dng"
#property version   "1.00"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#include "BWMFIValue.mqh"
#include <Arrays\\ArrayObj.mqh>
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CBWMFI
  {
private:
   CArrayObj        *IndicatorValues;     //Array of indicator's values
   
   int               i_handle;            //Handle of indicator
   
public:
                     CBWMFI(string symbol, ENUM_TIMEFRAMES timeframe, ENUM_APPLIED_VOLUME applied_volume);
                    ~CBWMFI();
   //---
   bool              SaveNewValues(long ticket);
   //---
   double            GetValue(long ticket);
   double            GetColor(long ticket);
   double            GetDinamic(long ticket);
   bool              GetValues(long ticket, double &value, double &_color, double &dinamic);
   int               GetIndyHandle(void)  {  return i_handle;     }
                    
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CBWMFI::CBWMFI(string symbol, ENUM_TIMEFRAMES timeframe, ENUM_APPLIED_VOLUME applied_volume)
  {
   i_handle=iBWMFI(symbol, timeframe, applied_volume);
   IndicatorValues=new CArrayObj();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CBWMFI::~CBWMFI()
  {
   if(i_handle!=INVALID_HANDLE)
      IndicatorRelease(i_handle);
   if(CheckPointer(IndicatorValues)!=POINTER_INVALID)
      delete IndicatorValues;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CBWMFI::SaveNewValues(long ticket)
  {
   if(CheckPointer(IndicatorValues)==POINTER_INVALID)
      return false;
   if(i_handle==INVALID_HANDLE)
      return false;
   double indy_buffer1[], indy_buffer2[];
   if(CopyBuffer(i_handle,0,1,2,indy_buffer1)<2 || CopyBuffer(i_handle,1,1,2,indy_buffer2)<2)
      return false;
   CBWMFIValue *object=new CBWMFIValue(indy_buffer1[1], indy_buffer2[1], (indy_buffer1[0]!=0 ? indy_buffer1[1]/indy_buffer1[0] : 1), ticket);
   if(CheckPointer(object)==POINTER_INVALID)
      return false;
   return IndicatorValues.Add(object);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CBWMFI::GetDinamic(long ticket)
  {
   double result=0;
   if(CheckPointer(IndicatorValues)==POINTER_INVALID)
      return result;
   int total=IndicatorValues.Total();
   for(int i=0;(i<total && result==0);i++)
     {
      CBWMFIValue *object=IndicatorValues.At(i);
      if(object.GetTicket()==ticket)
        {
         result=object.GetDinamic();
         break;
        }
     }
   return result;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CBWMFI::GetValue(long ticket)
  {
   double result=0;
   if(CheckPointer(IndicatorValues)==POINTER_INVALID)
      return result;
   int total=IndicatorValues.Total();
   for(int i=0;(i<total && result==0);i++)
     {
      CBWMFIValue *object=IndicatorValues.At(i);
      if(object.GetTicket()==ticket)
        {
         result=object.GetValue();
         break;
        }
     }
   return result;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CBWMFI::GetColor(long ticket)
  {
   double result=0;
   if(CheckPointer(IndicatorValues)==POINTER_INVALID)
      return result;
   int total=IndicatorValues.Total();
   for(int i=0;(i<total && result==0);i++)
     {
      CBWMFIValue *object=IndicatorValues.At(i);
      if(object.GetTicket()==ticket)
        {
         result=object.GetColor();
         break;
        }
     }
   return result;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CBWMFI::GetValues(long ticket,double &value,double &_color, double &dinamic)
  {
   double result=false;
   if(CheckPointer(IndicatorValues)==POINTER_INVALID)
      return result;
   int total=IndicatorValues.Total();
   for(int i=0;(i<total && result==false);i++)
     {
      CBWMFIValue *object=IndicatorValues.At(i);
      if(object.GetTicket()==ticket)
        {
         result=true;
         object.GetValues(value, _color, dinamic);
         break;
        }
     }
   return result;
  }
//+------------------------------------------------------------------+
