//+------------------------------------------------------------------+
//|                                                         Deal.mqh |
//|                                              Copyright 2017, DNG |
//|                                 http://www.mql5.com/en/users/dng |
//+------------------------------------------------------------------+
#property copyright "Copyright 2017, DNG"
#property link      "http://www.mql5.com/en/users/dng"
#property version   "1.00"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#include <Object.mqh>
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CDeal          :  public CObject
  {
private:
   datetime          OpenTime;         // Time of open position
   double            OpenedVolume;     // Volume of opened position
   ENUM_POSITION_TYPE Direct;          // Direct of opened position
   double            ClosedVolume;     // Closed volume
   double            Comission;        // Comission to position
   double            Swap;             // Swap of position
   double            Profit;           // Profit of position

public:
                     CDeal(ENUM_POSITION_TYPE type,datetime time,double volume,double comission=0.0);
                    ~CDeal();
   //--- Check status
   bool              IsClosed(void);
   bool              IsClosed(double &opened_volume);
   ENUM_POSITION_TYPE Type(void)    {  return Direct;    }
   double            GetProfit(void);
   datetime          GetTime(void)  {  return OpenTime;  }
   //---
   bool              Close(double volume,double profit,double comission=0,double swap=0);
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CDeal::CDeal(ENUM_POSITION_TYPE type,datetime time,double volume,double comission=0.0) : ClosedVolume(0),
                                                                                         Swap(0),
                                                                                         Profit(0)
  {
   OpenTime=time;
   OpenedVolume=volume;
   Direct=type;
   Comission=comission;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CDeal::~CDeal()
  {
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CDeal::IsClosed(void)
  {
   double opened_volume;
   return IsClosed(opened_volume);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CDeal::IsClosed(double &opened_volume)
  {
   opened_volume=OpenedVolume-ClosedVolume;
   return (opened_volume<=0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CDeal::GetProfit(void)
  {
   return (Comission+Swap+Profit);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CDeal::Close(double volume,double profit,double comission=0.0,double swap=0.0)
  {
   if((OpenedVolume-ClosedVolume)<volume)
      return false;
   ClosedVolume   += volume;
   Profit         += profit;
   Comission      += comission;
   Swap           += swap;
   return true;
  }
//+------------------------------------------------------------------+
