//-----------------------------------------------------------------------------------
//                                                                    BoxCoxTest3.mq5
//                                                                      2012, victorg
//                                                                http://www.mql5.com
//-----------------------------------------------------------------------------------
#property copyright "2012, victorg"
#property link      "http://www.mql5.com"

#include  "CBoxCox.mqh"
CBoxCox   Bc;
//-----------------------------------------------------------------------------------
// Script program start function
//-----------------------------------------------------------------------------------
void OnStart()
  {
  int i,n;
  double dat[],bcdat[],lambda,min;
  string fname;
  
  fname="Dataset2\\EURUSD_M1_1200.txt";               // Input file name
  if(readCSV(fname,dat)<0){Print("Error."); return;}  // Read data
  n=ArraySize(dat);                                   // Data length
  ArrayResize(bcdat,n);                               // Transformed data array
  min=dat[ArrayMinimum(dat)]-1e-5;
  for(i=0;i<n;i++)dat[i]=dat[i]-min;                  // Shift input data
  
  Bc.CalcPar(dat);                                    // Optimization of lambda
  lambda=Bc.GetPar(0);
  
  PrintFormat("Iterations= %i,   lambda= %.4f",Bc.GetIter(),lambda);

  if(lambda!=0){for(i=0;i<n;i++)bcdat[i]=(MathPow(dat[i],lambda)-1.0)/lambda;}
  else{for(i=0;i<n;i++)bcdat[i]=MathLog(dat[i]);}     // Lambda == 0.0

  // dat[]   <-- Input data
  // bcdat[] <-- Transformed data
  }
//-----------------------------------------------------------------------------------
int readCSV(string fnam,double &dat[])
  {
  int n,asize,fhand;
    
  fhand=FileOpen(fnam,FILE_READ|FILE_CSV|FILE_ANSI);
  if(fhand==INVALID_HANDLE)
    {
    Print("FileOpen Error!");
    return(-1);
    }
  asize=512;
  ArrayResize(dat,asize);
  n=0;
  while(FileIsEnding(fhand)!=true)
    {
    dat[n++]=FileReadNumber(fhand);
    if(n+128>asize)
      {
      asize+=128;
      ArrayResize(dat,asize);
      }
    }
  FileClose(fhand);
  ArrayResize(dat,n-1);
  return(0);
  }
//-----------------------------------------------------------------------------------