//-----------------------------------------------------------------------------------
//                                                                    BoxCoxTest2.mq5
//                                                                      2012, victorg
//                                                                http://www.mql5.com
//-----------------------------------------------------------------------------------
#property copyright "2012, victorg"
#property link      "http://www.mql5.com"

#include  "CBoxCox.mqh"
#include  "RNDXor128.mqh"
CBoxCox   Bc;
RNDXor128 Rnd;
//-----------------------------------------------------------------------------------
// Script program start function
//-----------------------------------------------------------------------------------
void OnStart()
  {
  int i,n;
  double dat[],bcdat[],lambda,min;
  
  n=1600;                                             // Data length
  ArrayResize(dat,n);                                 // Input data
  ArrayResize(bcdat,n);                               // Transformed data
  Rnd.Reset();
  for(i=0;i<n;i++)dat[i]=Rnd.Rand_Norm();             // Random data sequence
  
  min=dat[ArrayMinimum(dat)]-1e-5;                    // Shift input data
  for(i=0;i<n;i++)dat[i]=dat[i]-min;
  
  for(i=0;i<n;i++)dat[i]=MathPow(dat[i],0.35);
  
  Bc.CalcPar(dat);                                    // Optimization of lambda
  lambda=Bc.GetPar(0);
  
  PrintFormat("Iterations= %i,   lambda= %.4f",Bc.GetIter(),lambda);

  if(lambda!=0){for(i=0;i<n;i++)bcdat[i]=(MathPow(dat[i],lambda)-1.0)/lambda;}
  else{for(i=0;i<n;i++)bcdat[i]=MathLog(dat[i]);}     // Lambda == 0.0

  // dat[]   <-- Input data
  // bcdat[] <-- Transformed data
  }
//-----------------------------------------------------------------------------------
