//+------------------------------------------------------------------+
//|                                                      DA_Demo.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Artem Galeev"
#property link      "http://www.mql5.com"
#property version   "1.00"
//--- indicator input parameters
input int                BearsPower_PeriodBears=13;          // Bears Power period
input int                BullsPower_PeriodBulls=13;          // Bulls Power period 
input int                CCI_PeriodCCI         =13;           // CCI period
input ENUM_APPLIED_PRICE CCI_Applied           =PRICE_CLOSE; // CCI applied price
input int                DeM_PeriodDeM         =8;           // DeMarker period
input int                FraMA_PeriodMA        =12;          // FraMA period
input int                FraMA_Shift           =0;           // FraMA shift
input ENUM_APPLIED_PRICE FraMA_Applied         =PRICE_CLOSE; // FraMA applied price
input int                MACD_PeriodFast       =12;          // MACD fast MA period
input int                MACD_PeriodSlow       =24;          // MACD slow MA period
input int                MACD_PeriodSignal     =9;           // MACD signal line period
input ENUM_APPLIED_PRICE MACD_Applied          =PRICE_CLOSE; // MACD applied price
input int                RSI_PeriodRSI         =8;           // RSI period
input ENUM_APPLIED_PRICE RSI_Applied           =PRICE_CLOSE; // RSI applied price
input int                MFI_PeriodMFI         =7;           // MFI period
input int                RVI_PeriodRVI         =10;          // RVI period
input int                Stoch_PeriodK         =8;           // Stochastic K-period
input int                Stoch_PeriodD         =3;           // Stochastic D-period
input int                Stoch_PeriodSlow      =3;           // Stochastic Slowing period
input ENUM_STO_PRICE     Stoch_Applied         =STO_LOWHIGH; // Stochastic applied price
input int                WPR_PeriodWPR         =8;           // WPR period
//--- indicator input parameters for slow
input int                BearsPower_PeriodBears_s=26;          // Bears Power period
input int                BullsPower_PeriodBulls_s=26;          // Bulls Power period 
input int                CCI_PeriodCCI_s        =16;           // CCI period
input int                DeM_PeriodDeM_s         =16;           // DeMarker period
input int                FraMA_PeriodMA_s        =24;          // FraMA period
input int                MACD_PeriodFast_s       =24;          // MACD fast MA period
input int                MACD_PeriodSlow_s       =48;          // MACD slow MA period
input int                MACD_PeriodSignal_s     =18;           // MACD signal line period
input int                RSI_PeriodRSI_s         =16;           // RSI period
input int                MFI_PeriodMFI_s         =14;           // MFI period
input int                RVI_PeriodRVI_s         =20;          // RVI period
input int                Stoch_PeriodK_s         =16;           // Stochastic K-period
input int                Stoch_PeriodD_s         =6;           // Stochastic D-period
input int                Stoch_PeriodSlow_s      =6;           // Stochastic Slowing period
input int                WPR_PeriodWPR_s         =16;           // WPR period
//--- indicator handles
int h_AC,h_BearsPower,h_BullsPower,h_AO,h_CCI,h_DeMarker,h_FrAMA;
int h_MACD,h_RSI,h_MFI,h_Stoch,h_WPR;
int h_BearsPower_s,h_BullsPower_s,h_CCI_s,h_DeMarker_s,h_FrAMA_s;
int h_MACD_s,h_RSI_s,h_MFI_s,h_Stoch_s,h_WPR_s;
int h_BearsPower_f,h_BullsPower_f,h_CCI_f,h_DeMarker_f,h_FrAMA_f;
int h_MACD_f,h_RSI_f,h_RVI_f,h_Stoch_f,h_WPR_f;

//--- file handle
int FileHandle=-1;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- initialization of indicators
   h_AC=iAC(Symbol(),Period());
   h_BearsPower=iBearsPower(Symbol(),Period(),BearsPower_PeriodBears);
   h_BullsPower=iBullsPower(Symbol(),Period(),BullsPower_PeriodBulls);
   h_AO=iAO(Symbol(),Period());
   h_CCI=iCCI(Symbol(),Period(),CCI_PeriodCCI,CCI_Applied);
   h_DeMarker=iDeMarker(Symbol(),Period(),DeM_PeriodDeM);
   h_FrAMA=iFrAMA(Symbol(),Period(),FraMA_PeriodMA,FraMA_Shift,FraMA_Applied);
   h_MACD=iMACD(Symbol(),Period(),MACD_PeriodFast,MACD_PeriodSlow,MACD_PeriodSignal,MACD_Applied);
   h_RSI=iRSI(Symbol(),Period(),RSI_PeriodRSI,RSI_Applied);
   h_MFI=iMFI(Symbol(),Period(),MFI_PeriodMFI,VOLUME_TICK);
   h_Stoch=iStochastic(Symbol(),Period(),Stoch_PeriodK,Stoch_PeriodD,Stoch_PeriodSlow,MODE_SMA,Stoch_Applied);
   h_WPR=iWPR(Symbol(),Period(),WPR_PeriodWPR);
   //slow
   h_BearsPower_s=iBearsPower(Symbol(),Period(),BearsPower_PeriodBears_s);
   h_BullsPower_s=iBullsPower(Symbol(),Period(),BullsPower_PeriodBulls_s);
   h_CCI_s=iCCI(Symbol(),Period(),CCI_PeriodCCI_s,CCI_Applied);
   h_DeMarker_s=iDeMarker(Symbol(),Period(),DeM_PeriodDeM_s);
   h_FrAMA_s=iFrAMA(Symbol(),Period(),FraMA_PeriodMA_s,FraMA_Shift,FraMA_Applied);
   h_MACD_s=iMACD(Symbol(),Period(),MACD_PeriodFast_s,MACD_PeriodSlow_s,MACD_PeriodSignal_s,MACD_Applied);
   h_RSI_s=iRSI(Symbol(),Period(),RSI_PeriodRSI_s,RSI_Applied);
   h_MFI_s=iMFI(Symbol(),Period(),MFI_PeriodMFI_s,VOLUME_TICK);
   h_Stoch_s=iStochastic(Symbol(),Period(),Stoch_PeriodK_s,Stoch_PeriodD_s,Stoch_PeriodSlow_s,MODE_SMA,Stoch_Applied);
   h_WPR_s=iWPR(Symbol(),Period(),WPR_PeriodWPR_s);
     
   if(h_AC==INVALID_HANDLE || h_BearsPower==INVALID_HANDLE || 
      h_BullsPower==INVALID_HANDLE || h_AO==INVALID_HANDLE || 
      h_CCI==INVALID_HANDLE || h_DeMarker==INVALID_HANDLE || 
      h_FrAMA==INVALID_HANDLE || h_MACD==INVALID_HANDLE || 
      h_RSI==INVALID_HANDLE ||  
      h_Stoch==INVALID_HANDLE || h_WPR==INVALID_HANDLE ||
      h_BearsPower_s==INVALID_HANDLE || h_BullsPower_s==INVALID_HANDLE ||  
      h_CCI_s==INVALID_HANDLE || h_DeMarker_s==INVALID_HANDLE || 
      h_FrAMA_s==INVALID_HANDLE || h_MACD_s==INVALID_HANDLE || 
      h_RSI_s==INVALID_HANDLE ||  
      h_Stoch_s==INVALID_HANDLE || h_WPR_s==INVALID_HANDLE ||
      h_BearsPower_f==INVALID_HANDLE || h_BullsPower_f==INVALID_HANDLE ||  
      h_CCI_f==INVALID_HANDLE || h_DeMarker_f==INVALID_HANDLE || 
      h_FrAMA_f==INVALID_HANDLE || h_MACD_f==INVALID_HANDLE || 
      h_RSI_f==INVALID_HANDLE || h_RVI_f==INVALID_HANDLE || 
      h_Stoch_f==INVALID_HANDLE || h_WPR_f==INVALID_HANDLE ||
      h_MFI==INVALID_HANDLE || h_MFI_s==INVALID_HANDLE)
     {
      Print("Error creating indicators");
      return(1);
     }

   FileHandle=FileOpen("MasterDataR.csv",FILE_ANSI|FILE_WRITE|FILE_CSV|FILE_SHARE_READ,';');
   if(FileHandle!=INVALID_HANDLE)
     {
      Print("FileOpen OK");
      //--- saving names of the variables in the first line of the file for convenience of working with it
      FileWrite(FileHandle,"Time","Price","Price2","Hour","AC","dAC","Bears","dBears","Bulls","dBulls",
                "AO","dAO","CCI","dCCI","DeMarker","dDeMarker","dFrAMA","MACDm","dMACDm",
                "MACDs","dMACDs","MACDms","dMACDms","RSI","dRSI","MFI","dMFI","Stoch_m","dStoch_m","Stoch_s","dStoch_s",
                "Stoch_ms","dStoch_ms","WPR","dWPR",
                "Bears_p","dBears_p","Bulls_p","dBulls_p",
                "CCI_p","dCCI_p","DeMarker_p","dDeMarker_p","dFrAMA_p","MACDm_p","dMACDm_p",
                "MACDs_p","dMACDs_p","MACDms_p","dMACDms_p","RSI_p","dRSI_p","MFI_p","dMFI_p","Stoch_m_p","dStoch_m_p",
                "Stoch_s_p","dStoch_s_p","Stoch_ms_p","dStoch_ms_p","WPR_p","dWPR_p");
     }
   else
     {
      Print("FileOpen action failed. Error ",GetLastError());
      ExpertRemove();
     }
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   if(FileHandle!=INVALID_HANDLE) FileClose(FileHandle);
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//| Monitoring the market situation and saving values               |
//| of the indicators into the file at the beginning of every new bar                  |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
//--- declaring a static variable of datetime type
   static datetime Prev_time;
//--- declaring an array consisting of one member to store the start time of the current bar (bar 0)
   datetime Bar_time[1];
//--- it will be used to store prices, volumes and spread of each bar
   MqlRates mrate[];
   MqlTick tickdata;
//--- obtaining the recent quotes
   if(!SymbolInfoTick(_Symbol,tickdata))
     {
      Alert("Quote update error - error: ",GetLastError(),"!!");
      return;
     }
///--- copying data of the last 4 bars
   if(CopyRates(_Symbol,_Period,0,4,mrate)<0)
     {
      Alert("Historical quote copy error - error: ",GetLastError(),"!!");
      return;
     }
//--- copying the time of the current bar
   Bar_time[0]=mrate[0].time;
//--- if both time values are equal, there is no new bar
   if(Prev_time==Bar_time[0]) return;
//--- saving the time in the static variable 
   Prev_time=Bar_time[0];

//--- arrays
   double buf_AC[5],buf_BearsPower[5],buf_BullsPower[5],buf_AO[5],buf_CCI[5];
   double buf_DeMarker[5],buf_FrAMA[5],buf_MACD_m[5],buf_MACD_s[5],buf_RSI[5];
   double buf_MFI[5], buf_Stoch_m[5],buf_Stoch_s[5],buf_WPR[5];
   double buf_BearsPower_s[5],buf_BullsPower_s[5],buf_CCI_s[5];
   double buf_DeMarker_s[5],buf_FrAMA_s[5],buf_MACD_m_s[5],buf_MACD_s_s[5],buf_RSI_s[5];
   double buf_MFI_s[5],buf_Stoch_m_s[5],buf_Stoch_s_s[5],buf_WPR_s[5];
 
//--- filling the arrays with values of the indicators
   bool copy_result=true;
   copy_result=copy_result && FillArrayFromBuffer1(buf_AC,h_AC,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_BearsPower,h_BearsPower,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_BullsPower,h_BullsPower,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_AO,h_AO,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_CCI,h_CCI,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_DeMarker,h_DeMarker,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_FrAMA,h_FrAMA,5);
   copy_result=copy_result && FillArraysFromBuffers2(buf_MACD_m,buf_MACD_s,h_MACD,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_RSI,h_RSI,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_MFI,h_MFI,5);
   copy_result=copy_result && FillArraysFromBuffers2(buf_Stoch_m,buf_Stoch_s,h_Stoch,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_WPR,h_WPR,5);

   copy_result=copy_result && FillArrayFromBuffer1(buf_BearsPower_s,h_BearsPower_s,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_BullsPower_s,h_BullsPower_s,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_CCI_s,h_CCI_s,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_DeMarker_s,h_DeMarker_s,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_FrAMA_s,h_FrAMA_s,5);
   copy_result=copy_result && FillArraysFromBuffers2(buf_MACD_m_s,buf_MACD_s_s,h_MACD_s,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_RSI_s,h_RSI_s,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_MFI_s,h_MFI_s,5);
   copy_result=copy_result && FillArraysFromBuffers2(buf_Stoch_m_s,buf_Stoch_s_s,h_Stoch_s,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_WPR_s,h_WPR_s,5);
//--- checking the accuracy of copying all data
   if(!copy_result==true)
     {
      Print("Data copy error");
      return;
     }

//--- saving to the file the price movement within the last two bars 
//--- and the preceding values of the indicators 
   if(FileHandle!=INVALID_HANDLE)
     {
      MqlDateTime tm;
      TimeCurrent(tm);
      uint Result=0;
      Result=FileWrite(FileHandle,TimeToString(TimeCurrent()),
                       (mrate[2].close-mrate[1].close)/_Point,// difference between the closing prices of the last two bars 
                       (mrate[1].close-mrate[0].close)/_Point,// difference between the closing prices of the two last but one bars 
                       tm.hour,// bar time
                       buf_AC[2],buf_AC[2]-buf_AC[1],// value of the indicator on the preceding bar and its dynamics
                       buf_BearsPower[2],buf_BearsPower[2]-buf_BearsPower[1],
                       buf_BullsPower[2],buf_BullsPower[2]-buf_BullsPower[1],
                       buf_AO[2],buf_AO[2]-buf_AO[1],
                       buf_CCI[2],buf_CCI[2]-buf_CCI[1],
                       buf_DeMarker[2],buf_DeMarker[2]-buf_DeMarker[1],
                       buf_FrAMA[2]-buf_FrAMA[1],
                       buf_MACD_m[2],buf_MACD_m[2]-buf_MACD_m[1],
                       buf_MACD_s[2],buf_MACD_s[2]-buf_MACD_s[1],
                       buf_MACD_m[2]-buf_MACD_s[2],buf_MACD_m[2]-buf_MACD_s[2]-buf_MACD_m[1]+buf_MACD_s[1],
                       buf_RSI[2],buf_RSI[2]-buf_RSI[1],
                       buf_MFI[2],buf_MFI[2]-buf_MFI[1],
                       buf_Stoch_m[2],buf_Stoch_m[2]-buf_Stoch_m[1],
                       buf_Stoch_s[2],buf_Stoch_s[2]-buf_Stoch_s[1],
                       buf_Stoch_m[2]-buf_Stoch_s[2],buf_Stoch_m[2]-buf_Stoch_s[2]-buf_Stoch_m[1]+buf_Stoch_s[1],
                       buf_WPR[2],buf_WPR[2]-buf_WPR[1],
                       
                       buf_BearsPower_s[2],buf_BearsPower_s[2]-buf_BearsPower_s[1],
                       buf_BullsPower_s[2],buf_BullsPower_s[2]-buf_BullsPower_s[1],
                       buf_CCI_s[2],buf_CCI_s[2]-buf_CCI_s[1],
                       buf_DeMarker_s[2],buf_DeMarker_s[2]-buf_DeMarker_s[1],
                       buf_FrAMA_s[2]-buf_FrAMA_s[1],
                       buf_MACD_m_s[2],buf_MACD_m_s[2]-buf_MACD_m_s[1],
                       buf_MACD_s_s[2],buf_MACD_s_s[2]-buf_MACD_s_s[1],
                       buf_MACD_m_s[2]-buf_MACD_s_s[2],buf_MACD_m_s[2]-buf_MACD_s_s[2]-buf_MACD_m_s[1]+buf_MACD_s_s[1],
                       buf_RSI_s[2],buf_RSI_s[2]-buf_RSI_s[1],
                       buf_MFI_s[2],buf_MFI_s[2]-buf_MFI_s[1],
                       buf_Stoch_m_s[2],buf_Stoch_m_s[2]-buf_Stoch_m_s[1],
                       buf_Stoch_s_s[2],buf_Stoch_s_s[2]-buf_Stoch_s_s[1],
                       buf_Stoch_m_s[2]-buf_Stoch_s_s[2],buf_Stoch_m_s[2]-buf_Stoch_s_s[2]-buf_Stoch_m_s[1]+buf_Stoch_s_s[1],
                       buf_WPR_s[2],buf_WPR_s[2]-buf_WPR_s[1]);

      if(Result==0)
        {
         Print("FileWrite action error ",GetLastError());
         ExpertRemove();
        }
     }

  }
//+------------------------------------------------------------------+
//|Filling the indicator buffer from the single buffer indicator       |
//+------------------------------------------------------------------+
bool FillArrayFromBuffer1(double &buffer[],  // indicator buffer of values 
                          int ind_handle,    // indicator handle 
                          int amount)        // number of copied values
  {
//--- resetting error code
   ResetLastError();
//--- filling a part of the buffer array with the values from the indicator buffer with index 0
   if(CopyBuffer(ind_handle,0,0,amount,buffer)<0)
     {
      //--- if the copying fails, report the error code
      PrintFormat("Failed to copy data from the indicator, error code %d",GetLastError());
      //--- quitting with zero result - it means that the indicator will be considered as not calculated
      return(false);
     }
//--- success
   return(true);
  }
//+------------------------------------------------------------------+
//| filling the indicator buffers from the double buffer indicator     |
//+------------------------------------------------------------------+
bool FillArraysFromBuffers2(double &buffer1[], // indicator buffer 1
                            double &buffer2[], // indicator buffer 2 
                            int ind_handle,    // indicator handle
                            int amount)        // number of copied values
  {
//--- resetting error code
   ResetLastError();
//--- filling a part of the buffer1 array with the values from the indicator buffer with index 0
   if(CopyBuffer(ind_handle,0,0,amount,buffer1)<0)
     {
      //--- if the copying fails, report the error code
      PrintFormat("Failed to copy data from the indicator buffer 1, error code %d",GetLastError());
      //--- quitting with zero result - it means that the indicator will be considered as not calculated
      return(false);
     }

//--- filling a part of the buffer2 array with the values from the indicator buffer with index 1
   if(CopyBuffer(ind_handle,1,0,amount,buffer2)<0)
     {
      //--- if the copying fails, report the error code
      PrintFormat("Failed to copy data from the indicator buffer 2, error code %d",GetLastError());
      //--- quitting with zero result - it means that the indicator will be considered as not calculated
      return(false);
     }
//--- success
   return(true);
  }
//+------------------------------------------------------------------+
