//+------------------------------------------------------------------+
//|                                                      DA_Demo.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Artem Galeev"
#property link      "http://www.mql5.com"
#property version   "1.00"
//--- indicator input parameters
input int                STP=100;
input int                TKP=1500;
input int                BearsPower_PeriodBears=13;          // Bears Power period
input int                BullsPower_PeriodBulls=13;          // Bulls Power period 
input int                DeM_PeriodDeM         =8;           // DeMarker period


//--- indicator handles
int h_AC,h_BearsPower,h_BullsPower,h_DeMarker;
//--- file handle
int FileHandle=-1;
//+------------------------------------------------------------------+
//|  Include files with classes to be used         |
//+------------------------------------------------------------------+
//--- CTrade class
#include <Trade\Trade.mqh>
//--- CPositionInfo class
#include <Trade\PositionInfo.mqh>
//--- CAccountInfo class
#include <Trade\AccountInfo.mqh>
//--- CSymbolInfo class
#include <Trade\SymbolInfo.mqh>
#include <Trade\DealInfo.mqh>
//+------------------------------------------------------------------+
//|  Creation of class objects                                       |
//+------------------------------------------------------------------+
//--- Trade class object
CTrade mytrade;
//--- PositionInfo class object
CPositionInfo myposition;
//--- AccountInfo class object
CAccountInfo myaccount;
//--- SymbolInfo class object
CSymbolInfo mysymbol;
//--- CDealInfo class object
CDealInfo mydeal;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- initialization of indicators
   h_AC=iAC(Symbol(),Period());
   h_BearsPower=iBearsPower(Symbol(),Period(),BearsPower_PeriodBears);
   h_BullsPower=iBullsPower(Symbol(),Period(),BullsPower_PeriodBulls);
   h_DeMarker=iDeMarker(Symbol(),Period(),DeM_PeriodDeM);

   if(h_AC==INVALID_HANDLE || h_BearsPower==INVALID_HANDLE || 
      h_BullsPower==INVALID_HANDLE || h_DeMarker==INVALID_HANDLE)
     {
      Print("Error creating indicators");
      return(1);
     }
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   if(FileHandle!=INVALID_HANDLE) FileClose(FileHandle);
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//| Monitoring the market situation and saving values               |
//| of the indicators into the file at the beginning of every new bar                  |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
//--- declaring a static variable of datetime type
   static datetime Prev_time;
//--- declaring an array consisting of one member to store the start time of the current bar (bar 0)
   datetime Bar_time[10];
//--- it will be used to store prices, volumes and spread of each bar
   MqlRates mrate[];
   MqlTick tickdata;
//--- obtaining the recent quotes
   if(!SymbolInfoTick(_Symbol,tickdata))
     {
      Alert("Quote update error - error: ",GetLastError(),"!!");
      return;
     }
///--- copying data of the last 4 bars
   if(CopyRates(_Symbol,_Period,0,4,mrate)<0)
     {
      Alert("Historical quote copy error - error: ",GetLastError(),"!!");
      return;
     }
//--- copying the time of the current bar
   Bar_time[0]=mrate[0].time;
//--- if both time values are equal, there is no new bar
   if(Prev_time==Bar_time[0]) return;
//--- saving the time in the static variable 
   Prev_time=Bar_time[0];

//--- arrays
   double buf_BearsPower[10],buf_BullsPower[10],buf_AC[10];
   double buf_DeMarker[10];

//--- filling the arrays with values of the indicators
   bool copy_result=true;
   copy_result=copy_result && FillArrayFromBuffer1(buf_BullsPower,h_BullsPower,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_BearsPower,h_BearsPower,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_DeMarker,h_DeMarker,5);
   copy_result=copy_result && FillArrayFromBuffer1(buf_AC,h_AC,5);

//--- checking the accuracy of copying all data
   if(!copy_result==true)
     {
      Print("Data copy error");
      return;
     }
   bool Buy_opened=false, Sell_opened=false; 
   double price=(mrate[2].close-mrate[1].close)/_Point;
   if (price > 250 || price < -250) 
   {
    ClosePosition();
    return;
   }

   double Reg=22.7+205.2*(buf_DeMarker[3]-buf_DeMarker[2])-14619.5*buf_BearsPower[3]+22468.8*buf_BullsPower[3]-139.3*buf_DeMarker[3]-41686*(buf_AC[3]-buf_AC[2]);
       
      if(myposition.Select(_Symbol)==true) //--- there are open positions
        {
         if(myposition.PositionType()==POSITION_TYPE_BUY)
           {
            Buy_opened=true;  // long position (Buy)
           }
         if(myposition.PositionType()==POSITION_TYPE_SELL)
           {
            Sell_opened=true; //--- short position (Sell)
           }
        }   
   
   if (Reg>0 && Buy_opened==true) return; 
   if (Reg<=0 && Sell_opened==true) return;

   if (Reg<=0 && Buy_opened==true) ClosePosition(); 
   if (Reg>0 && Sell_opened==true) ClosePosition();
   
   if (Reg>20) BuyOrder(1);
   if (Reg<-20) SellOrder(1);
   

   return;
  }
//+------------------------------------------------------------------+
//|Filling the indicator buffer from the single buffer indicator       |
//+------------------------------------------------------------------+
bool FillArrayFromBuffer1(double &buffer[],  // indicator buffer of values 
                          int ind_handle,    // indicator handle 
                          int amount)        // number of copied values
  {
//--- resetting error code
   ResetLastError();
//--- filling a part of the buffer array with the values from the indicator buffer with index 0
   if(CopyBuffer(ind_handle,0,0,amount,buffer)<0)
     {
      //--- if the copying fails, report the error code
      PrintFormat("Failed to copy data from the indicator, error code %d",GetLastError());
      //--- quitting with zero result - it means that the indicator will be considered as not calculated
      return(false);
     }
//--- success
   return(true);
  }
//+------------------------------------------------------------------+
//| filling the indicator buffers from the double buffer indicator     |
//+------------------------------------------------------------------+
bool FillArraysFromBuffers2(double &buffer1[], // indicator buffer 1
                            double &buffer2[], // indicator buffer 2 
                            int ind_handle,    // indicator handle
                            int amount)        // number of copied values
  {
//--- resetting error code
   ResetLastError();
//--- filling a part of the buffer1 array with the values from the indicator buffer with index 0
   if(CopyBuffer(ind_handle,0,0,amount,buffer1)<0)
     {
      //--- if the copying fails, report the error code
      PrintFormat("Failed to copy data from the indicator buffer 1, error code %d",GetLastError());
      //--- quitting with zero result - it means that the indicator will be considered as not calculated
      return(false);
     }

//--- filling a part of the buffer2 array with the values from the indicator buffer with index 1
   if(CopyBuffer(ind_handle,1,0,amount,buffer2)<0)
     {
      //--- if the copying fails, report the error code
      PrintFormat("Failed to copy data from the indicator buffer 2, error code %d",GetLastError());
      //--- quitting with zero result - it means that the indicator will be considered as not calculated
      return(false);
     }
//--- success
   return(true);
  }
//+------------------------------------------------------------------+

//--------------- Buy
void BuyOrder(double Lots)
{
 static bool NoMoney = false;
 if (Lots < 0 || NoMoney == true) return;
 Lots=NormalizeDouble(Lots,2);
 MqlTick last_tick;
 SymbolInfoTick(_Symbol,last_tick);
 double Ask=last_tick.ask;
 double mprice=NormalizeDouble(Ask,_Digits);                //--- latest 'ask' price
 double stloss = NormalizeDouble(mprice - STP*_Point,_Digits); //--- Stop Loss
 double tprofit = NormalizeDouble(mprice + TKP*_Point,_Digits); //--- Take Profit
 
 if (mytrade.Buy(Lots,_Symbol,mprice,stloss,tprofit) == false)
 {
  if (mytrade.ResultRetcode() == TRADE_RETCODE_NO_MONEY) {NoMoney = true; return;} 
 }  
 return;
}  

//------------------- Sell
void SellOrder(double Lots)
{
 static bool NoMoney = false;
 if (Lots < 0 || NoMoney == true) return;
 Lots=NormalizeDouble(Lots,2);
 MqlTick last_tick;
 SymbolInfoTick(_Symbol,last_tick);
 double Bid=last_tick.bid;
 double sprice=NormalizeDouble(Bid,_Digits);              //--- latest 'Bid' price
 double ssloss=NormalizeDouble(sprice+STP*_Point,_Digits);   //--- Stop Loss
 double stprofit=NormalizeDouble(sprice-TKP*_Point,_Digits); //--- Take Profit

 if (mytrade.Sell(Lots,_Symbol,sprice,ssloss,stprofit) == false) 
 {
  if (mytrade.ResultRetcode() == TRADE_RETCODE_NO_MONEY) {NoMoney = true; return;} 
 }   
 return;
} 

//+------------------------------------------------------------------+
//| Checking and closing an open position, if necessary               |
//+------------------------------------------------------------------+
void ClosePosition()
  {
   mytrade.PositionClose(_Symbol,50); 
   return;
  }