//-----------------------------------------------------------------------------------
//                                                                     ForecastES.mq5
//                                                                      2011, victorg
//                                                                http://www.mql5.com
//-----------------------------------------------------------------------------------
#property copyright "2011, victorg"
#property link      "http://www.mql5.com"
#property version     "1.02"
#property description "Forecasting based on the exponential smoothing."

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_plots   4

#property indicator_label1  "History"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrDodgerBlue
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
#property indicator_label2  "Forecast"                 // Forecast
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrDarkOrange
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
#property indicator_label3  "ConfUp"                   // Confidence interval
#property indicator_type3   DRAW_LINE
#property indicator_color3  clrCrimson
#property indicator_style3  STYLE_DOT
#property indicator_width3  1
#property indicator_label4  "ConfDn"                   // Confidence interval
#property indicator_type4   DRAW_LINE
#property indicator_color4  clrCrimson
#property indicator_style4  STYLE_DOT
#property indicator_width4  1

input int nHist=80; // History bars, nHist>=24

#include  "CForeES.mqh"
#include  "RNDXor128.mqh"

#define   NFORE 12
#define   NBOOT 9999

double    Hist[],Fore[],Conf1[],Conf2[];
double    Data[],Err[],BSDat[],Damp[NFORE],BSErr[NBOOT];
int       NDat;

CForeES   Es;
RNDXor128 Rnd;
//-----------------------------------------------------------------------------------
// Custom indicator initialization function
//-----------------------------------------------------------------------------------
int OnInit()
  {
  NDat=nHist; if(NDat<24)NDat=24;
  MqlRates rates[];
  CopyRates(NULL,0,0,NDat,rates);                      // Load missing data
  ArrayResize(Data,NDat);
  ArrayResize(Err,NDat);
  ArrayResize(BSDat,NBOOT+NFORE);
  
  SetIndexBuffer(0,Hist,INDICATOR_DATA);
  PlotIndexSetString(0,PLOT_LABEL,"History");
  SetIndexBuffer(1,Fore,INDICATOR_DATA);
  PlotIndexSetString(1,PLOT_LABEL,"Forecast");
  PlotIndexSetInteger(1,PLOT_SHIFT,NFORE);
  SetIndexBuffer(2,Conf1,INDICATOR_DATA);              // Confidence interval
  PlotIndexSetString(2,PLOT_LABEL,"ConfUp");
  PlotIndexSetInteger(2,PLOT_SHIFT,NFORE);
  SetIndexBuffer(3,Conf2,INDICATOR_DATA);              // Confidence interval
  PlotIndexSetString(3,PLOT_LABEL,"ConfDN");
  PlotIndexSetInteger(3,PLOT_SHIFT,NFORE);
  IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
  return(0);
  }
//-----------------------------------------------------------------------------------
// Custom indicator iteration function
//-----------------------------------------------------------------------------------
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int  &spread[])
  {
  int i,j,k,start;
  double s,t,alp,gam,phi,sb,sg,e,f,a,a1,a2;
  
  if(rates_total<NDat){Print("Error: Not enough bars for calculation!"); return(0);}
  if(prev_calculated==rates_total)return(rates_total); // New tick but not new bar
  start=rates_total-NDat;
//-----------------------
  PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,rates_total-NDat);
  PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,rates_total-NFORE);
  PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,rates_total-NFORE);
  PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,rates_total-NFORE);
  
  for(i=0;i<NDat;i++)Data[i]=open[rates_total-NDat+i]; // Input data
  Es.CalcPar(Data);                                    // Optimization of parameters
  s=Es.GetPar(0); t=Es.GetPar(1); gam=Es.GetPar(2);
  phi=Es.GetPar(3); sb=Es.GetPar(4); sg=Es.GetPar(5);
//----
  a=phi; Damp[0]=phi;
  for(j=1;j<NFORE;j++){a=a*phi; Damp[j]=Damp[j-1]+a;}  // Phi table
//----
  f=s+phi*t;
  for(i=0;i<NDat;i++)                                  // History
    {
    e=Data[i]-f; Err[i]=e;
    alp=0.05+0.9/(1+MathExp(sb+sg*e*e));               // 0.05 < Alpha < 0.95
    a1=alp*e; a2=phi*t; s=s+a2+a1; t=a2+gam*a1;
    f=(s+phi*t); Hist[start+i]=f;                      // History
    }
  for(j=0;j<NFORE;j++)Fore[rates_total-NFORE+j]=s+Damp[j]*t;  // Forecast
//----
  a=0;
  for(i=0;i<NDat;i++)a+=Err[i];                      
  a/=NDat;
  for(i=0;i<NDat;i++)Err[i]-=a;                   // alignment of the array of errors
//----
  f=Es.GetPar(0)+phi*Es.GetPar(1);
  for(i=0;i<NBOOT+NFORE;i++)                           // Resampling
    {
    j=(int)(NDat*Rnd.Rand_01());
    if(j>NDat-1)j=NDat-1;
    e=Err[j];
    BSDat[i]=f+e;
    alp=0.05+0.9/(1+MathExp(sb+sg*e*e));               // 0.05 < Alpha < 0.95
    a1=alp*e; a2=phi*t; s=s+a2+a1; t=a2+gam*a1;
    f=s+phi*t;
    }
//----
  for(j=0;j<NFORE;j++)                                 // Prediction intervals
    {
    s=Es.GetPar(0); t=Es.GetPar(1);
    f=s+phi*t;
    for(i=0,k=0;i<NBOOT;i++,k++)
      {
      BSErr[i]=BSDat[i+j]-(s+Damp[j]*t);
      e=BSDat[i]-f;
      a1=alp*e; a2=phi*t; s=s+a2+a1; t=a2+gam*a1;
      f=(s+phi*t);
      }
    ArraySort(BSErr);
    Conf1[rates_total-NFORE+j]=Fore[rates_total-NFORE+j]+BSErr[249];
    Conf2[rates_total-NFORE+j]=Fore[rates_total-NFORE+j]+BSErr[9749];
    }
  return(rates_total);
  }
//-----------------------------------------------------------------------------------