//-----------------------------------------------------------------------------------
//                                                                    Errors_Mod1.mq5
//                                                                      2011, victorg
//                                                                http://www.mql5.com
//-----------------------------------------------------------------------------------
#property copyright "2011, victorg"
#property link      "http://www.mql5.com"

#include  "CMod1.mqh"
CMod1     Es;
#define   ABS(a) ((a)>=0.0?(a):-(a))
//-----------------------------------------------------------------------------------
// Script program start function
//-----------------------------------------------------------------------------------
void OnStart()
  {
  int i,j,k,m,nfiles,bl,nbl;
  double data[],block[],s,t,alp,gam,phi,e,e1,e2,e3,phi2,phi3,ae,pt,a;
  double mae1,mae2,mae3;
  string fname[]={
  "Dataset2\\DXY_D1_1200.txt",
  "Dataset2\\DXY_H1_1200.txt",
  "Dataset2\\DXY_M1_1200.txt",
  "Dataset2\\EURUSD_D1_1200.txt",
  "Dataset2\\EURUSD_H1_1200.txt",
  "Dataset2\\EURUSD_M1_1200.txt",
  "Dataset2\\USDCHF_D1_1200.txt",
  "Dataset2\\USDCHF_H1_1200.txt",
  "Dataset2\\USDCHF_M1_1200.txt",
  "Dataset2\\USDJPY_D1_1200.txt",
  "Dataset2\\USDJPY_H1_1200.txt",
  "Dataset2\\USDJPY_M1_1200.txt"};
  
  nfiles=ArraySize(fname);
  bl=80; nbl=50;                                  // mode: 80, 50
  ArrayResize(block,bl);
  mae1=0; mae2=0; mae3=0;
  e1=0; e2=0; e3=0;
  for(i=0;i<nfiles;i++)
    {
    if(readCSV(fname[i],data)<0){Print("Error."); return;}
    for(j=0;j<nbl;j++)
      {
      for(m=0;m<bl;m++)block[m]=data[m+j*bl/4];
      Es.CalcPar(block);                          // Optimization of parameters
      s=Es.GetPar(0); t=Es.GetPar(1); alp=Es.GetPar(2);
      gam=Es.GetPar(3); phi=Es.GetPar(4);
      phi2=phi+phi*phi; phi3=phi2+phi*phi*phi;
      for(k=0;k<bl-2;k++)
        {
        e=block[k]-(s+phi*t); e1+=ABS(e)/block[k];
        a=block[k+1]-(s+phi2*t); e2+=ABS(a)/block[k+1];
        a=block[k+2]-(s+phi3*t); e3+=ABS(a)/block[k+2];
        ae=alp*e; pt=phi*t; s=s+pt+ae; t=pt+gam*ae;
        }
      e=block[bl-2]-(s+phi*t); e1+=ABS(e)/block[bl-2];
      a=block[bl-1]-(s+phi2*t); e2+=ABS(a)/block[bl-1];
      ae=alp*e; pt=phi*t; s=s+pt+ae; t=pt+gam*ae;
      a=block[bl-1]-(s+phi*t); e1+=ABS(a)/block[bl-1];
      }
    }
  a=nfiles*nbl/100;
  mae1=e1/a/bl; mae2=e2/a/(bl-1); mae3=e3/a/(bl-2);
  PrintFormat("mape1= %.4f,  mape2= %.4f,  mape3= %.4f,  mape1-3= %.4f",
                                                 mae1,mae2,mae3,(mae1+mae2+mae3)/3);
  }
//-----------------------------------------------------------------------------------
int readCSV(string fnam,double &dat[])
  {
  int n,asize,fhand;
    
  fhand=FileOpen(fnam,FILE_READ|FILE_CSV|FILE_ANSI);
  if(fhand==INVALID_HANDLE)
    {
    Print("FileOpen Error!");
    return(-1);
    }
  asize=512;
  ArrayResize(dat,asize);
  n=0;
  while(FileIsEnding(fhand)!=true)
    {
    dat[n++]=FileReadNumber(fhand);
    if(n+128>asize)
      {
      asize+=128;
      ArrayResize(dat,asize);
      }
    }
  FileClose(fhand);
  ArrayResize(dat,n-1);
  return(0);
  }
//-----------------------------------------------------------------------------------