﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.Runtime.InteropServices;
using RGiesecke.DllExport;

namespace SocketServer
{
    internal static class iSocket
    {
        static Socket server = null;
        static Thread thread = null;
        static bool isServerClosedOrClosing = true;
        static bool isServerClosed = true;
        static ManualResetEvent allDone = null;

        struct mqlClient
        {
            public string ip;
            public Socket socket;
            public bool alive;
        }

        static mqlClient[] clients = new mqlClient[0];
        [DllExport("About", CallingConvention = CallingConvention.StdCall)]
        internal static string About()
        {
            return "Lib: SocketServer, Author: Tsaktuo, Version: 1.0, Year: 2011";
        }

        [DllExport("SendToAll", CallingConvention = CallingConvention.StdCall)]
        internal static int SendToAll([MarshalAs(UnmanagedType.LPWStr)]string msg)
        {
            int len = -1; ;
            try
            {
                if (isServerClosedOrClosing || server == null)
                {
                    Debug("Server is not running.");
                    return -1;
                }
                System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
                byte[] str = enc.GetBytes(msg);
                bool any_failed = false;

                lock (clients)
                {
                    for (int i = 0; i < clients.Length; i++)
                    {
                        try
                        {
                            if (clients[i].alive)
                            {
                                if (clients[i].socket.Send(str) < 0)
                                {
                                    any_failed = true;
                                    clients[i].alive = false;
                                    Debug("Sending failed: " + clients[i].ip);
                                }
                            }
                        }
                        catch
                        {
                            any_failed = true;
                            clients[i].alive = false;
                            Debug("Client left: " + clients[i].ip);
                        }
                    }
                }
                if (any_failed)
                    len = RemoveDeadClients();
                else
                    len = clients.Length;
            }
            catch (Exception ex)
            {
                Debug("SendToAll() Error: "+ex.Message);
            }
            return len;
        }

        internal static List<string> LOG = new List<string>();

        [DllExport("ReadLogLine", CallingConvention = CallingConvention.StdCall)]
        internal static string ReadLogLine()
        {
            string logs = "\0";
            try
            {
                if (LOG.Count > 0 && LOG[0].Length>0)
                {
                    logs = LOG[0];
                    LOG.RemoveAt(0);
                }
            }
            catch (Exception ex)
            {
                Debug("ReadLogLine() Error: " + ex.Message);
            }
            return logs;
        }

        internal static void Debug(string line)
        {
            LOG.Add(line+"\0");
            if (LOG.Count > 100)//Max 100 log lines
                LOG.RemoveAt(0);
        }

        internal static int RemoveDeadClients()
        {
            try
            {
                mqlClient[] temp = new mqlClient[0];
                lock (clients)
                {
                    for (int i = 0; i < clients.Length; i++)
                    {
                        if (clients[i].alive)
                        {
                            Array.Resize(ref temp, temp.Length + 1);
                            temp[temp.Length - 1] = clients[i];
                        }
                    }
                    clients = temp;
                }
                return temp.Length;
            }
            catch (Exception ex)
            {
                Debug("RemoveDeadClients() Error: " + ex.Message);
                return -1;
            }
        }

        [DllExport("Stop", CallingConvention = System.Runtime.InteropServices.CallingConvention.StdCall)]
        internal static bool Stop()
        {
            try
            {
                if (isServerClosed)
                {
                    Debug("Server is already closed.");
                    return true;
                }
                Debug("Closing server...");
                isServerClosedOrClosing = true;
                allDone.Set();
                int i = 0;

                while (!isServerClosed)
                {
                    Thread.Sleep(100);
                }

                if (thread != null)
                {
                    if (thread.IsAlive)
                    {
                        Debug("Aborting thread...");
                        thread.Abort();
                        while (thread.IsAlive)
                        {
                            i++;
                            if (i > 10)//10 * 100 = 1 second
                                throw new Exception("Can't abort server thread!");
                            Thread.Sleep(100);
                        }
                    }
                    thread = null;
                }

                if (clients.Length > 0)
                {
                    Debug("Removing clients...");

                    for (i = 0; i < clients.Length; i++)
                    {
                        try
                        {
                            if (clients[i].alive)
                            {
                                //clients[i].socket.Disconnect(true);
                                clients[i].socket.Close();
                                Debug(clients[i].ip + " closed.");
                            }
                        }
                        catch (Exception ex)
                        {
                            Debug("Client Warning: " + ex.Message);
                        }
                    }
                    clients = new mqlClient[0];
                }

                Debug("Server sucessfully stopped!");
                return true;
            }
            catch (Exception ex)
            {
                Debug("Stop() Error: " + ex.Message);
                return false;
            }

        }

        internal static int iPort = 0;

        [DllExport("StartListen", CallingConvention = System.Runtime.InteropServices.CallingConvention.StdCall)]
        internal static bool StartListen(int port)
        {
            try
            {
                if (!isServerClosedOrClosing)
                {
                    Debug("StartListen(): Stop server first.");
                    return false;
                }
                iPort = port;
                allDone = new ManualResetEvent(false);
                thread = new Thread(new ThreadStart(WaitForClients));
                thread.Start();
            }
            catch (Exception ex)
            {
                Debug("StartListen() Error: " + ex.Message);
            }
            return true;
        }

        internal static void WaitForClients()
        {
            if (server != null)
            {
                Debug("Cant start lisening! Server not disposed.");
                return;
            }
            try
            {

                IPEndPoint localEndPoint = new IPEndPoint(IPAddress.Any, iPort);
                server = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);


                server.Bind(localEndPoint);
                server.Listen(500);
                isServerClosed = false;
                isServerClosedOrClosing = false;

                while (!isServerClosedOrClosing)
                {
                    allDone.Reset();
                    server.BeginAccept(new AsyncCallback(AcceptCallback), server);
                    allDone.WaitOne();
                }
                
            }
            catch (ThreadAbortException)
            {
            }
            catch (Exception e)
            {
                Debug("WaitForClients() Error: " + e.Message);
            }
            finally
            {
                if (server != null)
                {
                    server.Close();
                    server = null;
                }
                isServerClosed = true;
                isServerClosedOrClosing = true;
            }
        }

        internal static void AcceptCallback(IAsyncResult ar)
        {
            try
            {
                allDone.Set();
                if (isServerClosedOrClosing)
                    return;
                Socket listener = (Socket)ar.AsyncState;
                Socket client = listener.EndAccept(ar);

                if (clients != null)
                {
                    lock (clients)
                    {
                        Array.Resize(ref clients, clients.Length + 1);
                        clients[clients.Length - 1].socket = client;
                        clients[clients.Length - 1].ip = client.RemoteEndPoint.ToString();
                        clients[clients.Length - 1].alive = true;
                    }
                    Debug("Client connected: " + clients[clients.Length - 1].ip);
                }
            }
            catch (Exception ex)
            {
                Debug("AcceptCallback() Error: " + ex.Message);
            }
        }


    }
}
