//+------------------------------------------------------------------+
//|                                            TsaktuoDealServer.mq5 |
//|                                                          tsaktuo |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "tsaktuo"
#property link      "http://www.mql5.com"
#property version   "1.00"

//--- definitions
#define DEAL_ENTRY_OUTALL 5

#import "SocketServer.dll" // Library created on C# (created by using information available on http://www.mql5.com/en/articles/249)
string About();            // Information abou library.
int SendToAll(string msg); // Sends one text message to all clients.
bool Stop();               // Stops the server.
bool StartListen(int port);// Starts the server. Server will listen from incomming connections (max 500 clients). All clients are built on Assync threads.
string ReadLogLine();      // Retrievs one log line from server (can contain erros and other information). Readng is optional. Server stores only last 100 lines.
#import
//+------------------------------------------------------------------+
//| Startup Type                                                     |
//+------------------------------------------------------------------+
enum ENUM_STARTUP_TYPE
  {
   STARTUP_TYPE_CLEAR,// CLEAR - Send every new DEAL wich appears on account.
   STARTUP_TYPE_CONTINUE  // CONTINUE - Do not send DEAL before existing POSITION has been closed.
  };
//--- input parameters
input int               InpPort=2011;  // Incomming port
input ENUM_STARTUP_TYPE InpStartupType=STARTUP_TYPE_CONTINUE; // Startup type
//--- global parameters
datetime g_dtLastDealTime=0;
string g_sSymbolsToIgnore[];
//+------------------------------------------------------------------+
//| Convert C# string to MQL5 string                                 |
//+------------------------------------------------------------------+
string UTF8_to_ASCII(string utf8)
  {
   string retval="";
   for(int i=0;i<StringLen(utf8);i++)
     {

      ushort val=StringGetCharacter(utf8,i);
      if(val==0xFF00)break;

      retval+=CharToString((char)(val&0x00FF));
      retval+=CharToString((char)((val&0xFF00)>>8));

     }
   return retval;
  }
//+------------------------------------------------------------------+
//| Convert ENUM_DEAL_TYPE to string                                 |
//+------------------------------------------------------------------+
string Type2String(ENUM_DEAL_TYPE type)
  {
   switch(type)
     {
      case DEAL_TYPE_BUY:return "BUY";
      case DEAL_TYPE_SELL:return "SELL";
     }
   return "";
  }
//+------------------------------------------------------------------+
//| Convert ENUM_DEAL_ENTRY + my DEAL_ENTRY_OUTALL to string         |
//+------------------------------------------------------------------+
string Entry2String(int entry)
  {
   switch(entry)
     {
      case DEAL_ENTRY_IN:return "IN";
      case DEAL_ENTRY_OUT:return "OUT";
      case DEAL_ENTRY_INOUT:return "INOUT";
      case DEAL_ENTRY_OUTALL:return "OUTALL";
      case DEAL_ENTRY_STATE:return "STATE";
     }
   return "";
  }
//+------------------------------------------------------------------+
//| Check if we need to ignore this symbol                           |
//+------------------------------------------------------------------+
bool bIsThisSymbolEnabled(string symbol)
  {
   for(int i=0;i<ArraySize(g_sSymbolsToIgnore);i++) // Go through all symbols which was find during OnInit()
     {
      if(g_sSymbolsToIgnore[i]==symbol) // If symbol is found in an array then return 'false' - symbol disabled
         return false;
     }
   return true;
  }
//+------------------------------------------------------------------+
//| Go through all symbols and elable those which have been closed.  |
//+------------------------------------------------------------------+
void vUpdateEnabledSymbols()
  {
//--- Go through all disabled symbols and if there is no open position found for it, then enable it
   for(int i=0;i<ArraySize(g_sSymbolsToIgnore);i++)
     {
      if(!PositionSelect(g_sSymbolsToIgnore[i])) // If there is no open position for it...
        {
         g_sSymbolsToIgnore[i]="";   // Clear it - it will enable symbol for trading.
        }
     }
  }
//+------------------------------------------------------------------+
//| Enable requested symbol. This function is used in case when INOUT|
//| DEAL is executed - we dont want to know about OUT but we need to |
//| know about IN.                                                   |
//+------------------------------------------------------------------+
void vEnableSymbol(string symbol)
  {
//--- Go through all disabled symbols and if requested symbol is found then enable it.
   for(int i=0;i<ArraySize(g_sSymbolsToIgnore);i++)
     {
      if(g_sSymbolsToIgnore[i]==symbol) // If symbol is found...
        {
         g_sSymbolsToIgnore[i]="";        // Clear it - it will enable symbol for trading.
         Print("Symbol ",symbol," enabled for traiding.");
        }
     }
  }
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   string str="";
   Print(UTF8_to_ASCII(About()));
//--- Start the server
   Print("Starting server on port ",InpPort,"...");
   if(!StartListen(InpPort))
     {
      PrintLogs();
      Print("OnInit() - FAILED");
      return -1;
     }
//--- Print out logs from server startup
   PrintLogs();
//--- Update 'g_dtLastDealTime' parameter to latest one, because we dont want to be informed about it.
   datetime dtStart=TimeCurrent()-60*60*24;
   datetime dtEnd=TimeCurrent()+60*60*24;        // 24 hours front (in case if you live in GMT-<hours>)
   HistorySelect(dtStart,dtEnd);
   for(int i=0;i<HistoryDealsTotal();i++)
     {
      ulong ticket=HistoryDealGetTicket(i);
      if(HistoryDealGetInteger(ticket,DEAL_ENTRY)!=DEAL_ENTRY_STATE)
        {
         if(HistoryDealGetInteger(ticket,DEAL_TIME)>g_dtLastDealTime)
           {
            g_dtLastDealTime=(datetime)HistoryDealGetInteger(ticket,DEAL_TIME);
           }
        }
     }
   if(InpStartupType==STARTUP_TYPE_CONTINUE)
     {
      //--- Find all positions which are currently open. We don't want to receive deals from aleary opened symbols.
      //    Deals from those symbols can be sent to us only when they are closed first.
      for(int i=0;i<PositionsTotal();i++)
        {
         ArrayResize(g_sSymbolsToIgnore,ArraySize(g_sSymbolsToIgnore)+1);           // Increase array size by 1
         g_sSymbolsToIgnore[ArraySize(g_sSymbolsToIgnore)-1]=PositionGetSymbol(i);  // Set new value
         Print("Symbol ",g_sSymbolsToIgnore[ArraySize(g_sSymbolsToIgnore)-1]," disable till position is reopened.");
        }
     }
//--- Set timer to get OnTimer() event every second.
   EventSetTimer(1);
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//--- Kill the timer
   EventKillTimer();
//--- Stop the server
   Stop();
//--- Print out logs from server
   PrintLogs();
   Print("Deinit done.");
  }
//+------------------------------------------------------------------+
//| OnTrade() - every time when there is an activity related to      |
//|             traiding.                                            |
//+------------------------------------------------------------------+
void OnTrade()
  {
//--- Find all new deals and report them to all connected clients
   datetime dtStart=TimeCurrent()-60*60*24;        // 24 hours back.
   datetime dtEnd=TimeCurrent()+60*60*24;        // 24 hours front (in case if you live in GMT-<hours>)
   if(HistorySelect(dtStart,dtEnd)) // Select history from last 24 hours.
     {
      for(int i=0;i<HistoryDealsTotal();i++) // Go through all deals (from oldest to newest).
        {
         ulong ticket=HistoryDealGetTicket(i);     // Get deal ticket.
         if(HistoryDealGetInteger(ticket,DEAL_ENTRY)!=DEAL_ENTRY_STATE) // If this deal is interesting for us.
           {
            //Print("Entry type ok.");
            if(HistoryDealGetInteger(ticket,DEAL_TIME)>g_dtLastDealTime) // Check if this deal is newer than previously reported one.
              {
               if(HistoryDealGetInteger(ticket,DEAL_ENTRY)==DEAL_ENTRY_OUT) // If some part of position has been closed then check if we need to enable it
                 {
                  vUpdateEnabledSymbols();
                 }
               else if(HistoryDealGetInteger(ticket,DEAL_ENTRY)==DEAL_ENTRY_INOUT) // If oposit position is opened, then we need to enable disabled symbol.
                 {
                  vEnableSymbol(HistoryDealGetString(ticket,DEAL_SYMBOL));        // Enable this specific symbol.
                 }
               if(bIsThisSymbolEnabled(HistoryDealGetString(ticket,DEAL_SYMBOL))) // Check if symbol is enabled.
                 {
                  int cnt=SendToAll(sBuildDealString(ticket));                    // Build deal-string and send to all connected clients.
                  if(cnt<0) // Technical error with server.
                    {
                     Print("Failed to send new deals!");
                    }
                  else // If sent to no one (cnt==0) or if sent to someone (cnt>0)
                    {
                     g_dtLastDealTime=(datetime)HistoryDealGetInteger(ticket,DEAL_TIME);    // Update datetime for last sucessfully transfered deal.
                    }
                 }
               else // Do not notify becayse symbol is disabled.
                 {
                  g_dtLastDealTime=(datetime)HistoryDealGetInteger(ticket,DEAL_TIME);       // Update datetime for last deal, we will not notify about.
                 }
              }
           }
        }
     }
  }
//+------------------------------------------------------------------+
//| This function builds deal string                                 |
//| Examples:                                                        |
//| EURUSD;BUY;IN;0.01;1.37294                                       |
//| EURUSD;SELL;OUT;0.01;1.37310                                     |
//| EURUSD;SELL;IN;0.01;1.37320                                      |
//| EURUSD;BUY;INOUT;0.02;1.37294                                    |
//+------------------------------------------------------------------+
string sBuildDealString(ulong ticket)
  {
   string deal="";
   double volume=0;
   bool bFirstInOut=true;
//--- Find deal volume.
   if(HistoryDealGetInteger(ticket,DEAL_ENTRY)==DEAL_ENTRY_INOUT) // If this is INOUT then volume must contain ONLY volume of 'IN'.
     {
      if(PositionSelect(HistoryDealGetString(ticket,DEAL_SYMBOL)))
        {
         volume=PositionGetDouble(POSITION_VOLUME);
        }
      else
        {
         Print("Failed to get volume!");
        }
     }
   else  // If it's 'IN' or 'OUT' deal then use it's volume as is.
     {
      volume=HistoryDealGetDouble(ticket,DEAL_VOLUME);
     }
//--- Build deal string(format sample: "<EURUSD;BUY;IN;0.01;1.37294>").
   int iDealEntry=(int)HistoryDealGetInteger(ticket,DEAL_ENTRY);
   if(iDealEntry==DEAL_ENTRY_OUT && !PositionSelect(HistoryDealGetString(ticket,DEAL_SYMBOL))) // If this is OUT deal, and there are no open positions left.
     {
      // For safety resons, we check if there is any position left with current symbol. If NO, then let's use 
      // new deal type - OUTALL. This will guarante that there are no open orders left on or account when all
      // position has been closed on 'remote' MetaTrader 5 side. This can happen due to fact, that volume is 
      // is mapped to new values on client side, therefor there can be some very small difference which leaves
      // order open with very small lot size. 
      iDealEntry=DEAL_ENTRY_OUTALL;  // My own predefined value (this value should not colide with EMUN_DEAL_ENTRY values).
     }
   StringConcatenate(deal,"<",AccountInfoInteger(ACCOUNT_LOGIN),";",HistoryDealGetString(ticket,DEAL_SYMBOL),";",Type2String((ENUM_DEAL_TYPE)HistoryDealGetInteger(ticket,DEAL_TYPE)),";",Entry2String(iDealEntry),";",DoubleToString(volume,2),";",DoubleToString(HistoryDealGetDouble(ticket,DEAL_PRICE),(int)SymbolInfoInteger(HistoryDealGetString(ticket,DEAL_SYMBOL),SYMBOL_DIGITS)),">");
   Print("DEAL:",deal);
   return deal;
  }
//+------------------------------------------------------------------+
//| Print logs from Server every second (if there are any)           |
//+------------------------------------------------------------------+
void OnTimer()
  {
   PrintLogs();
  }
//+------------------------------------------------------------------+
//| Get all available log lines and print them out line by line      |
//+------------------------------------------------------------------+
void PrintLogs()
  {
   string line="";
   do
     {
      line=UTF8_to_ASCII(ReadLogLine());  // Getting log line and prints it out.
      if(StringLen(line)>0)
        {
         Print(line);
        }
     }
   while(StringLen(line)>0);
  }
//+------------------------------------------------------------------+
