//+------------------------------------------------------------------+
//|                                                   YieldClose.mq5 |
//|                                      Copyright 2010, Grebenev V. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2010, Grebenev V."
#property link "http://www.mql5.com"
#property description "Yield Indicator"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_plots   2
#property indicator_type1   DRAW_LINE
#property indicator_type2   DRAW_SECTION
#property indicator_color1  LightSeaGreen
#property indicator_color2  DarkGreen
#property indicator_label1  "YieldClose"
//--- input parameters
input int      N=10;    // number of bars for calculation
//---
double ExtTRbuffer[];   // array for indicator
double ExtTRbufferP[];  // array for zero values
double average[150000]; // array for average values of price
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator short name
   IndicatorSetString(INDICATOR_SHORTNAME,"Maximal yield");
//---- index buffer
   SetIndexBuffer(0,ExtTRbuffer);
   SetIndexBuffer(1,ExtTRbufferP);
//--- set index draw begin
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,1);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,1);
//---- Array Initialization
   ArrayInitialize(ExtTRbuffer,0);
   ArrayInitialize(ExtTRbufferP,0);
   ArrayInitialize(average,0);
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   double pp=0;

//--- fill array of average values of price with the close values
   for(int i=prev_calculated;i<rates_total;i++) average[i]=close[i];

   for(int i=prev_calculated;i<rates_total;i++)
     {
      pp=0;

      for(int j=0;j<N;j++)
        {
         if(i-j-1>=0) // check if array index doesn't exceed 0 0
           {
           //--- calculate indicator
            pp=pp+MathAbs(average[i-j]-average[i-j-1])/average[i-j];    
           }

         // fill indicator arrays
         ExtTRbuffer[i]=pp/N;
         ExtTRbufferP[i]=sqrt(N)*0;
        }
     }
   return(rates_total);
  }
//+------------------------------------------------------------------+