//+------------------------------------------------------------------+
//|                                              RandomWalkMulti.mq5 |
//|                                   Copyright 2011, Grebenev Slava |
//|                                         http://grebenev.narod.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, Grebenev Slava"
//---
#define OrderNumberEURUSD 1
//--- input parameters
input int random=12345;      // lucky number for random sequence
input int time=350000;       // time of one trade
input int purpose=100000;    // amount of jackpot
//---
enum lastdeal {no,buy,sell}; // this variable will store the type of last deal - buy or sell
lastdeal ld=no;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   SymbolSelect("EURUSD",true);
//--- select a winning ticket number, i.e. sequence of buy and sell
   MathSrand(random);
//--- open position, start the timer
   Start();
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   return;
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//| Position support                                                 |
//+------------------------------------------------------------------+
void OnTick()
  {
   double balance=AccountInfoDouble(ACCOUNT_BALANCE);
   double equity=AccountInfoDouble(ACCOUNT_EQUITY);
//--- notify about Stop Out
   if(AccountInfoDouble(ACCOUNT_MARGIN_LEVEL)<55.0)
     {
      Stop();
      Start();
     };
//--- track the Take Profit, 33000 was determined after optimization
   if(equity-balance>33000)
     {
      Stop();
      Start();
     }
//--- track the Take Profit, 2 was determined after optimization
   if(equity>2*balance)
     {
      Stop();
      Start();
     };
//--- if won, close position, terminate the program
   if(equity>purpose)
     {
      Stop();
      TerminalClose(0);
     };
//--- if lost, close position, terminate the program 
//--- about $150 is needed to purchase a minimum volume of 0.1 lot      
   if(balance<150)
     {
      Stop();
      TerminalClose(0);
     };
   return;
  }
//+------------------------------------------------------------------+
//| Timer function                                                   |
//| Timer actuation indicates the end of trade.                      |
//+------------------------------------------------------------------+
void OnTimer()
  {
//--- close position
   Stop();
//--- open position
   Start();
   return;
  }
//+------------------------------------------------------------------+
//| Direction                                                        |
//| Select direction to enter the market.                              |
//| Here you can write your ideas about the direction of price movement.      |
//+------------------------------------------------------------------+
bool Direction()
  {
//--- choose a random direction of price movement
   bool r=(rand()>32768/2);
   return(r);
  }
//+------------------------------------------------------------------+
//| Start                                                            |
//| Function opens a position                                        |
//+------------------------------------------------------------------+
void Start()
  {
   double balance=0;
   double free_margin=0;
   double bet=0;
//--- buy or sell depending on chosen direction
   if(Direction())
     {
      free_margin=AccountInfoDouble(ACCOUNT_FREEMARGIN);
      balance=AccountInfoDouble(ACCOUNT_BALANCE);
      //--- calculate volume of position, 1.7 apox. EURUSD exchange rate, leverage 1:100
      bet=free_margin/1000/1.7;
      //--- normalize volume up to 0.01
      bet=round(bet*100)/100;
      //--- check for the minimum volume
      if(bet<0.1) bet=0.1;
      //--- check for the maximum volume
      if(bet>5) bet=5;
      SendBuyOrderEURUSD(bet);
      ld=buy;
      //--- start timer
      EventSetTimer(time);
     }
   else
     {
      free_margin=AccountInfoDouble(ACCOUNT_FREEMARGIN);
      balance=AccountInfoDouble(ACCOUNT_BALANCE);
      //--- calculate volume of position, 1.7 apox. EURUSD exchange rate, leverage 1:100
      bet=free_margin/1000/1.7;
      //--- normalize volume up to 0.01
      bet=round(bet*100)/100;
      //--- check for the minimum volume
      if(bet<0.1) bet=0.1;
      //--- check for the maximum volume
      if(bet>5) bet=5;
      SendSellOrderEURUSD(bet);
      ld=sell;
      //--- start timer
      EventSetTimer(time);
     }
   return;
  }
//+------------------------------------------------------------------+
//| Stop                                                             |
//| Function closes a position                                       |
//+------------------------------------------------------------------+
void Stop()
  {
   double pv=0;
//--- close position, stop the timer
   if(ld==buy)
     {
      if(PositionSelect("EURUSD"))
        {
         pv=PositionGetDouble(POSITION_VOLUME);
         if(pv>0) SendSellOrderEURUSD(pv);
         pv=0;
        };
      EventKillTimer(); ld=no;
     };

   if(ld==sell)
     {
      if(PositionSelect("EURUSD"))
        {
         pv=PositionGetDouble(POSITION_VOLUME);
         if(pv>0) SendBuyOrderEURUSD(pv);
         pv=0;
        };
      EventKillTimer();
      ld=no;
     };
// Terminate the program if the balance is more than $100,000 or less than $100.
// int ret_code=0;
// if (AccountInfoDouble(ACCOUNT_BALANCE)<100) TerminalClose(ret_code);
// if (AccountInfoDouble(ACCOUNT_BALANCE)>100000) TerminalClose(ret_code);
   return;
  }
//+------------------------------------------------------------------+
//| SendBuyOrderEURUSD                                               |
//| Function to buy EURUSD                                           | 
//+------------------------------------------------------------------+
void SendBuyOrderEURUSD(double Bet)
  {
   MqlTick last_tick;
   if(SymbolInfoTick("EURUSD",last_tick))
     {
      MqlTradeRequest request;
      //--- prepare a request
      //--- place order for instant deal (market order)
      request.action=TRADE_ACTION_DEAL;
      //--- ORDER_MAGIC
      request.magic=OrderNumberEURUSD;
      //--- symbol
      request.symbol="EURUSD";
      //--- volume
      request.volume=Bet;
      //--- price
      request.price=last_tick.ask;
      //--- Stop Loss is not specified
      request.sl=0;
      //--- Take Profit is not specified
      request.tp=0;
      //--- type of order
      request.type=ORDER_TYPE_BUY;
      MqlTradeResult result;
      MqlTradeCheckResult CheckResult;
      //--- send order
      if(OrderCheck(request,CheckResult)) OrderSend(request,result);
      else Print(CheckResult.retcode,"  ",SymbolInfoDouble("EURUSD",SYMBOL_VOLUME_MAX));
      //--- write to log the response from server  
      Print(__FUNCTION__,":",result.comment);
     }
   else Print("SymbolInfoTick() failed, error = ",GetLastError());
   return;
  }
//+------------------------------------------------------------------+
//| SendSellOrderEURUSD                                              |
//| Function to sell EURUSD                                          | 
//+------------------------------------------------------------------+
void SendSellOrderEURUSD(double Bet)
  {
   MqlTick last_tick;
   if(SymbolInfoTick("EURUSD",last_tick))
     {
      //--- prepare a request
      MqlTradeRequest request;
      //--- place order for instant deal (market order)
      request.action=TRADE_ACTION_DEAL;
      //--- ORDER_MAGIC
      request.magic=OrderNumberEURUSD;
      //--- symbol
      request.symbol="EURUSD";
      //--- volume 
      request.volume=Bet;
      request.price=last_tick.bid;
      //--- Stop Loss is not specified
      request.sl=0;
      //--- Take Profit is not specified
      request.tp=0;
      //--- type of order
      request.type=ORDER_TYPE_SELL;
      MqlTradeResult result;
      MqlTradeCheckResult CheckResult;
      //--- send trade signal
      if(OrderCheck(request,CheckResult)) OrderSend(request,result);
      else Print(CheckResult.retcode,"  ",SymbolInfoDouble("EURUSD",SYMBOL_VOLUME_MAX));
      //--- write to log the response from server  
      Print(__FUNCTION__,":",result.comment);
      if(result.retcode==10016) Print(result.bid,result.ask,result.price);
     }
   else Print("SymbolInfoTick() failed, error = ",GetLastError());
   return;
  }

//+------------------------------------------------------------------+
