//+------------------------------------------------------------------+
//|                                         eIncGUI_v3_Test_Form.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v3.mqh>

enum eColorScheme{
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
};

input eColorScheme ColorScheme=DefaultScheme;

class CForm: public CFormBase{
   public:
      // 1. Declaring the controls  
      CHMenu m_hm;
      CVMenu m_vm1;
      CVMenu m_vm2;
      CVMenu m_vm3; 
      CFrame m_fr1;
      CFrame m_fr2;
      CInputBox m_ib;     
      CSpinInputBox m_sib; 
      CDialerInputBox m_dib;  
      CComBox m_cb; 
      CCheckBox m_chb;
      CRadioGroup m_rg1;
      CRadioGroup m_rg2;
      CListMS m_lms1;
      CListMS m_lms2;
      CButton m_but;
   protected: 
      // 2. Declaring the variables to restore the control values   
      int m_EventsCounter;
         void MainProperties(){
            // Setting the form parameters
            m_Name         =  "Form";        // Form name. The names of all the controls should start with it.
            m_Width        =  260;           // Form width
            m_Height       =  200;           // Form height
            m_Type         =  0;             // Form type: 0 - without buttons, 1 - with "Apply" and "Cancel" buttons, 2 - with the "Close" button
            m_Caption      =  "FormCaption"; // Form caption
            m_Movable      =  true;          // Movable form (the button with a hand image is displayed in the top left corner)
            m_Resizable    =  true;          // Form minimizing/maximizing allowed (the button with a rectangle image is displayed in the top right corner)
            m_CloseButton  =  false;         // Form closing allowed (the button with a cross image is displayed in the top right corner)
         }
         void OnInitEvent(){
            // 3. Calling the Init() methods of all the controls
            // 4. Loading the parameters from the data storage, where necessary
            // 5. Preparation of the controls, for example adding the list items.
            // Menu components
            // Horizontal menu
            m_hm.Init(m_Name+"_HM",m_Width,2);
            // Adding horizontal menu items
            m_hm.AddItem("Form types");
            m_hm.AddItem("Item-2");
            m_hm.AddItem("Item-3");
            // Vertical menu 1
            m_vm1.Init(m_Name+"_VM1",70,10); 
            // Adding items to vertical menu 1
            m_vm1.AddItem("Type-1");
            m_vm1.AddItem("Type-2");
            // Vertical menu 2
            m_vm2.Init(m_Name+"_VM2",70,3);
            // Adding items to vertical menu 2
            m_vm2.AddItem("Item-2-1");
            m_vm2.AddItem("Item-2-2");
            m_vm2.AddItem("Item-2-3");    
            m_vm2.AddItem("Item-2-4");
            m_vm2.AddItem("Item-2-5"); 
            // Vertical menu 3
            m_vm3.Init(m_Name+"_VM3",70,3);
            // Adding items to vertical menu 3
            m_vm3.AddItem("Item-3-1");
            m_vm3.AddItem("Item-3-2");
            m_vm3.AddItem("Item-3-3");    
            m_vm3.AddItem("Item-3-4");
            m_vm3.AddItem("Item-3-5");    
            // Frames                      
            m_fr1.Init(m_Name+"_Frame1",120,155,"Frame-1",38);
            m_fr2.Init(m_Name+"_Frame2",120,155,"Frame-2",38);
            // Components
            m_ib.Init(m_Name+"_IB",40,2);  
            m_sib.Init(m_Name+"_SIB",40,1);  
            m_dib.Init(m_Name+"_DIB",40,2);     
            m_cb.Init(m_Name,40);
            m_cb.AddItem("1");
            m_cb.AddItem("2");            
            m_cb.AddItem("3");            
            m_cb.AddItem("4");            
            m_cb.AddItem("5");                               
            m_cb.SetSelectedIndex(0);
            m_chb.Init(m_Name+"CB");
            m_rg1.Init(m_Name+"_RG1");
            m_rg1.AddButton("11",0,0);
            m_rg1.AddButton("12",0,20);
            m_rg1.AddButton("13",25,0);            
            m_rg1.AddButton("14",25,20);
            m_rg1.SetValue(0);
            m_rg2.Init(m_Name+"_RG2");
            m_rg2.AddButton("21",0,0);
            m_rg2.AddButton("22",0,20);
            m_rg2.AddButton("23",25,0);            
            m_rg2.AddButton("24",25,20);
            m_rg2.SetValue(0);
            m_lms1.Init(m_Name+"_ListMS1",105,4);
               for(int i=0;i<SymbolsTotal(true);i++){
                  m_lms1.AddItem(SymbolName(i,true));
               }
            m_but.Init(m_Name+"_But",50,15);  
            m_lms2.Init(m_Name+"_ListMS2",105,4);
         }   
         void OnShowEvent(int aLeft,int aTop){
            // 6. Calling the Show(x,y) method for all the controls of the form
            // Menu
            m_hm.Show(aLeft,aTop);            
            // Frame 1
            m_fr1.Show(aLeft+8,aTop+23);
            m_ib.Show(m_fr1.Left()+5,m_fr1.Top()+10);
            m_sib.Show(m_fr1.Left()+5,m_fr1.Top()+30);
            m_dib.Show(m_fr1.Left()+5,m_fr1.Top()+50);
            m_cb.Show(m_fr1.Left()+5,m_fr1.Top()+70); 
            m_chb.Show(m_fr1.Left()+5,m_fr1.Top()+90);
            m_rg1.Show(m_fr1.Left()+5,m_fr1.Top()+110);
            m_rg2.Show(m_fr1.Left()+5+55,m_fr1.Top()+110);
            m_fr2.Show(aLeft+8+120+5,aTop+23);
            m_lms1.Show(m_fr2.Left()+5,m_fr2.Top()+10);
            m_but.Show(m_fr2.Left()+5,m_lms1.Top()+m_lms1.Height()+5);
            m_lms2.Show(m_fr2.Left()+5,m_but.Top()+m_but.Height()+5);
         }
         void OnHideEvent(){
            // 7. Calling the Hide() method for all the controls of the form
            m_hm.Hide(); 
            m_vm1.Hide(); 
            m_vm2.Hide(); 
            m_vm3.Hide();             
            m_fr1.Hide();
            m_fr2.Hide();               
            m_ib.Hide();
            m_sib.Hide();
            m_dib.Hide();
            m_cb.Hide();  
            m_chb.Hide();  
            m_rg1.Hide();  
            m_rg2.Hide();  
            m_lms1.Hide();
            m_lms2.Hide();
            m_but.Hide();
         }
         void OnWindowChangeEvent(int aSubWindow){
            // 8. Calling the SetSubWindow() method for all the controls of the form. The subwindow number is conveyed by the aSubWindow parameter.
            m_hm.SetSubWindow(aSubWindow);
            m_vm1.SetSubWindow(aSubWindow);
            m_vm2.SetSubWindow(aSubWindow);
            m_vm3.SetSubWindow(aSubWindow); 
            m_fr1.SetSubWindow(aSubWindow);
            m_fr2.SetSubWindow(aSubWindow);            
            m_ib.SetSubWindow(aSubWindow);
            m_sib.SetSubWindow(aSubWindow);
            m_dib.SetSubWindow(aSubWindow);
            m_cb.SetSubWindow(aSubWindow);
            m_chb.SetSubWindow(aSubWindow);
            m_rg1.SetSubWindow(aSubWindow);
            m_rg2.SetSubWindow(aSubWindow);
            m_lms1.SetSubWindow(aSubWindow);
            m_lms2.SetSubWindow(aSubWindow);
            m_but.SetSubWindow(aSubWindow);
            
         }
         void EventsHandler(const int id,const long& lparam,const double& dparam,const string& sparam){
            // 9. Calling the Event() method of all the controls. 
            // 10. Handling the control events, where necessary
            // Menu events
            int m_event0=m_hm.Event(id,lparam,dparam,sparam);
            int m_event1=m_vm1.Event(id,lparam,dparam,sparam);
            int m_event2=m_vm2.Event(id,lparam,dparam,sparam);
            int m_event3=m_vm3.Event(id,lparam,dparam,sparam);  
            // Display of the main menu tabs
               if(m_event0==0){ // Clicking item 0
                  if(m_vm1.Visible()){
                     m_vm1.Hide(); // If the vertical menu is open, close it
                  }
                  else{ // If the vertical menu is closed
                     m_vm1.ToggleNamesClear(); // Clear the list of "toggle" names
                     // Add to the list the name of the graphical objects forming 
                     // the item of the horizontal menu which led to the last 
                     // event of the horizontal menu                     
                     m_vm1.ToggleNameAdd(m_hm.LastClickedName1());
                     m_vm1.ToggleNameAdd(m_hm.LastClickedName2());
                     // Display the vertical menu
                     m_vm1.Show(m_hm.SolvePosLeft(m_vm1.Width()),m_hm.SolvePosTop(m_vm1.Height()));                  
                  }
               }
               if(m_event0==1){ // Clicking item 1
                  if(m_vm2.Visible()){
                     m_vm2.Hide();
                  }
                  else{
                     m_vm2.ToggleNamesClear();
                     m_vm2.ToggleNameAdd(m_hm.LastClickedName1());
                     m_vm2.ToggleNameAdd(m_hm.LastClickedName2());
                     m_vm2.Show(m_hm.SolvePosLeft(m_vm2.Width()),m_hm.SolvePosTop(m_vm2.Height()));                     
                  }
               }
               if(m_event0==2){ // Clicking item 2
                  if(m_vm3.Visible()){
                     m_vm3.Hide();
                  }
                  else{
                     m_vm3.ToggleNamesClear();
                     m_vm3.ToggleNameAdd(m_hm.LastClickedName1());
                     m_vm3.ToggleNameAdd(m_hm.LastClickedName2());
                     m_vm3.Show(m_hm.SolvePosLeft(m_vm3.Width()),m_hm.SolvePosTop(m_vm3.Height()));                    
                  }
               }
            // Events of the menu items
               if(m_event1>=0){ // Event of the vertical menu 1
                  m_vm1.Hide(); // Hiding the menu
                     if(m_event1==0){ // Clicking item 0
                        frm2.Hide();
                        frm1.Show(frm.Left()+100,frm.Top()+100);
                     }
                     if(m_event1==1){ // Clicking item 1
                        frm1.Hide();
                        frm2.Show(frm.Left()+100,frm.Top()+100);
                     }                  
               }
               if(m_event2>=0){
                  m_vm2.Hide();
                  Alert("Menu item selected "+m_vm2.Text(m_event2));
               }
               if(m_event3>=0){
                  m_vm3.Hide();
                  Alert("Menu item selected "+m_vm3.Text(m_event3));
               }
            // Events of other controls               
               if(m_ib.Event(id,lparam,dparam,sparam)>0){
                  Alert("Input event");
               }
               if(m_sib.Event(id,lparam,dparam,sparam)>0){
                  Alert("SpinInput event");               
               }
               if(m_dib.Event(id,lparam,dparam,sparam)>0){
                  Alert("DialerInput event");      
               }
               if(m_cb.Event(id,lparam,dparam,sparam)>0){
                  Alert("ComBox event");
               } 
               if(m_rg1.Event(id,lparam,dparam,sparam)>0){
                  Alert("RadioGroup-1 event");
               }  
               if(m_rg2.Event(id,lparam,dparam,sparam)>0){
                  Alert("RadioGroup-2 event");
               }                 
               if(m_chb.Event(id,lparam,dparam,sparam)>0){
                  Alert("CheckBox event");
               }   
            m_lms1.Event(id,lparam,dparam,sparam);
            m_lms2.Event(id,lparam,dparam,sparam);
               if(m_but.Event(id,lparam,dparam,sparam)==1){
                  if(m_lms1.FirstSelected()==-1 && m_lms2.Count()==0){
                     Alert("No selected items in symbol list");
                  }
                  else{
                     m_lms2.Clear();
                        for(int i=0;i<m_lms1.Count();i++){
                           if(m_lms1.Selected(i)){
                              m_lms2.AddItem(m_lms1.Text(i));
                           }
                        }
                     m_lms2.Refresh();                     
                  }
               }
         }
         bool OnApplyEvent(){
            // 11. Checking the control values upon closing by the "Apply" button. In order to reject the closing of the form, false should be returned from this method.
            // 12. Saving the parameters.
            return(true);
         }
         bool OnCancelEvent(){
            // 13. Checks upon closing by the "Cancel" or "Close" buttons. In order to reject the closing of the form, false should be returned from this method.
            return(false);
         }
};

class CForm1: public CFormBase{
   public:
      // 1. Declaring the controls  
      CInputBox m_ib;
   protected: 
      // 2. Declaring the variables to restore the control values
      string m_InputBoxValue;
         void MainProperties(){
            // Setting the form parameters
            m_Name         =  "Form1";        // Form name. The names of all the controls should start with it.
            m_Width        =  200;           // Form width
            m_Height       =  150;           // Form height
            m_Type         =  1;             // Form type: 0 - without buttons, 1 - with "Apply" and "Cancel" buttons, 2 - with the "Close" button
            m_Caption      =  "Form1Caption"; // Form caption
            m_Movable      =  true;          // Movable form (the button with a hand image is displayed in the top left corner)
            m_Resizable    =  true;          // Form minimizing/maximizing allowed (the button with a rectangle image is displayed in the top right corner)
            m_CloseButton  =  true;          // Form closing allowed (the button with a cross image is displayed in the top right corner)
         }
         void OnInitEvent(){
            // 3. Calling the Init() methods of all the controls
            // 4. Loading the parameters from the data storage, where necessary
            // 5. Preparation of the controls, for example adding the list items.
            m_ib.Init(m_Name,80,-1,"Enter something");
            m_InputBoxValue=""; // Kind of loading the value, e.g. from a file, global variable or invisible chart caption
            m_ib.SetValue(m_InputBoxValue);
         }   
         void OnShowEvent(int aLeft,int aTop){
            // 6. Calling the Show(x,y) method for all the controls of the form
            m_ib.Show(aLeft+10,aTop+10);
         }
         void OnHideEvent(){
            // 7. Calling the Hide() method for all the controls of the form
            m_ib.Hide();
         }
         void OnWindowChangeEvent(int aSubWindow){
            // 8. Calling the SetSubWindow() method for all the controls of the form. The subwindow number is conveyed by the aSubWindow parameter.
            m_ib.SetSubWindow(aSubWindow);
         }
         void EventsHandler(const int id,const long& lparam,const double& dparam,const string& sparam){
            // 9. Calling the Event() method of all the controls. 
            // 10. Handling the control events, where necessary
            m_ib.Event(id,lparam,dparam,sparam);
         }
         bool OnApplyEvent(){
            // 11. Checking the control values upon closing by the "Apply" button. In order to reject the closing of the form, false should be returned from this method.
            // 12. Saving the parameters.
            string val=m_ib.ValueString();
            StringTrimLeft(val);
            StringTrimRight(val);
               if(val==""){
                  MessageBox("Nothing has been entered!",m_Caption);
                  return(false);
               }
               else{
                  MessageBox("Using value: "+val,m_Caption);
                  m_InputBoxValue=m_ib.ValueString(); // Save the value in a variable of the form in order to restore the value in the future in case the cancel button has been pressed
                  return(true);
               }
         }
         bool OnCancelEvent(){
            // 13. Checks upon closing by the "Cancel" or "Close" buttons. In order to reject the closing of the form, false should be returned from this method.
               if(MessageBox("Close?",Caption(),MB_YESNO)!=IDYES){
                  return(false);
               }
            m_ib.SetValue(m_InputBoxValue); // Pressed cancel, restoring the value
            return(true);
         }
};

class CForm2: public CFormBase{
   public:
      // 1. Declaring the controls  
      CLabel m_lbl;
      CButton m_but1;
      CButton m_but2;
      CButton m_but3;
      CButton m_but4;      
   protected: 
      // 2. Declaring the variables to restore the control values   
         void MainProperties(){
            // Setting the form parameters
            m_Name         =  "Form2";        // Form name. The names of all the controls should start with it.
            m_Width        =  200;            // Form width
            m_Height       =  150;            // Form height
            m_Type         =  2;              // Form type: 0 - without buttons, 1 - with "Apply" and "Cancel" buttons, 2 - with the "Close" button
            m_Caption      =  "Form2Caption"; // Form caption
            m_Movable      =  true;           // Movable form (the button with a hand image is displayed in the top left corner)
            m_Resizable    =  true;           // Form minimizing/maximizing allowed (the button with a rectangle image is displayed in the top right corner)
            m_CloseButton  =  true;           // Form closing allowed (the button with a cross image is displayed in the top right corner)
         }
         void OnInitEvent(){
            // 3. Calling the Init() methods of all the controls
            // 4. Loading the parameters from the data storage, where necessary
            // 5. Preparation of the controls, for example adding the list items.
            m_lbl.Init(m_Name,"Caption consisting of \nseveral \nlines.");
            m_but1.Init(m_Name+"_But1",100,18,"Caption-1");
            m_but2.Init(m_Name+"_But2",100,18,"Caption-2");
            m_but3.Init(m_Name+"_But3",100,18,"Change color");
            m_but4.Init(m_Name+"_But4",100,18,"Default color");            
         }   
         void OnShowEvent(int aLeft,int aTop){
            // 6. Calling the Show(x,y) method for all the controls of the form
            m_lbl.Show(aLeft+10,aTop+10);
            
            m_but1.Show(aLeft+90,aTop+10);
            m_but2.Show(aLeft+90,aTop+35);
            m_but3.Show(aLeft+90,aTop+60);
            m_but4.Show(aLeft+90,aTop+85);            
         }
         void OnHideEvent(){
            // 7. Calling the Hide() method for all the controls of the form
            m_lbl.Hide();
            m_but1.Hide();
            m_but2.Hide();
            m_but3.Hide();
            m_but4.Hide();            
         }
         void OnWindowChangeEvent(int aSubWindow){
            // 8. Calling the SetSubWindow() method for all the controls of the form. The subwindow number is conveyed by the aSubWindow parameter.
            m_lbl.SetSubWindow(aSubWindow);
            m_but1.SetSubWindow(aSubWindow);            
            m_but2.SetSubWindow(aSubWindow);     
            m_but3.SetSubWindow(aSubWindow);            
            m_but4.SetSubWindow(aSubWindow);                     
         }
         void EventsHandler(const int id,const long& lparam,const double& dparam,const string& sparam){
            // 9. Calling the Event() method of all the controls. 
            // 10. Handling the control events, where necessary
            if(m_but1.Event(id,lparam,dparam,sparam)==1){
               m_lbl.SetText("Caption in \ntwo lines");
            }
            if(m_but2.Event(id,lparam,dparam,sparam)==1){
               m_lbl.SetText("Caption in \nthree \nlines");
            }    
            if(m_but3.Event(id,lparam,dparam,sparam)==1){
               m_lbl.SetColor(clrRed);
            }
            if(m_but4.Event(id,lparam,dparam,sparam)==1){
               m_lbl.SetColor();
            }                      
         }
         bool OnApplyEvent(){
            // 11. Checking the control values upon closing by the "Apply" button. In order to reject the closing of the form, false should be returned from this method.
            // 12. Saving the parameters.
            return(true);
         }
         bool OnCancelEvent(){
            // 13. Checks upon closing by the "Cancel" or "Close" buttons. In order to reject the closing of the form, false should be returned from this method.
               if(MessageBox("Close?",Caption(),MB_YESNO)==IDYES){
                  return(true);
               }
               else{
                  return(false);
               }                  
         }
};

CForm frm;
CForm1 frm1;
CForm2 frm2;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

   ClrScheme.SetScheme(ColorScheme); 

   // Main form
   frm.Init();
   frm.SetSubWindow("TestSubWindow");
   frm.Show(30,30);
   
   // Form-1, opens from the menu
   frm1.Init();
   frm1.SetSubWindow("TestSubWindow");
   // Form doesn't open, it will open at the menu command
   
   // Form-2, opens from the menu
   frm2.Init();
   frm2.SetSubWindow("TestSubWindow");
   // Form doesn't open, it will open at the menu command
   
   return(0);
}
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){
   frm.Hide();
   frm1.Hide();  
   frm2.Hide();     
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){

   
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam
                  ){
   int ev=frm.Event(id,lparam,dparam,sparam);
      switch(ev){
         case 1:
            Alert("Form "+frm.Name()+"("+frm.Caption()+"). Cancel event");
         break;
         case 2:
            Alert("Form "+frm.Name()+"("+frm.Caption()+"). Apply event");  
         break;
         case 3:
            Alert("Form "+frm.Name()+"("+frm.Caption()+"). Resize event");  
         break;         
      }
   frm1.Event(id,lparam,dparam,sparam);  
   frm2.Event(id,lparam,dparam,sparam);     
      if(CHARTEVENT_CHART_CHANGE){
         frm.SetSubWindow("TestSubWindow");
         frm1.SetSubWindow("TestSubWindow");
         frm2.SetSubWindow("TestSubWindow");
      }     
}

