//+------------------------------------------------------------------+
//|                                       eIncGUI_v2_Test_CVMenu.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme
  {
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
  };

input eColorScheme ColorScheme=DefaultScheme;

CVMenu vm;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   ClrScheme.SetScheme(ColorScheme);

//--- CVMenu
   vm.Init("CVMenu",95,10);
   for(int i=0;i<50;i++)
     {
      vm.AddItem("VMenuItem-"+IntegerToString(i),false);
     }
   vm.SetPos((int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS)/2-vm.Width()/2,(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS)/2-vm.Height()/2);
   vm.SetSubWindow("TestSubWindow");
   vm.Show();

   w.Canvas("c1",0,270,20,50,50);

   w.Button("b1",0,10,20,250,20,"Check the selected items");
   w.Redraw();
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   w.Delete("c1");
   w.Delete("b1");
   vm.Hide();
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=vm.Event(id,lparam,dparam,sparam);
   if(ev>=0)
     {
      int he,wi;
      Alert("CHMenu. Item clicked "+IntegerToString(ev)+"(X: "+IntegerToString(vm.LastClickedX())+", Y: "+IntegerToString(vm.LastClickedY())+", quarter: "+IntegerToString(vm.LastClickedQuarter())+")");
      if(vm.Checked(ev))
        {
         vm.SetChecked(ev,false);
        }
      else
        {
         vm.SetChecked(ev,true);
        }
      switch(vm.LastClickedQuarter())
        {
         case 1:
            g.SetXYDistance("c1",vm.LastClickedX()+vm.Width()-1,vm.LastClickedY());
            ChartRedraw();
            break;
         case 2:
            wi=g.XSize("c1");
            g.SetXYDistance("c1",vm.LastClickedX()-wi+1,vm.LastClickedY());
            ChartRedraw();
            break;
         case 3:
            he=g.YSize("c1");
            g.SetXYDistance("c1",vm.LastClickedX()+vm.Width()-1,vm.LastClickedY()-he+15);
            ChartRedraw();
            break;
         case 4:
            he=g.YSize("c1");
            wi=g.XSize("c1");
            g.SetXYDistance("c1",vm.LastClickedX()-wi+1,vm.LastClickedY()-he+15);
            ChartRedraw();
            break;
        }
     }
   if(CHARTEVENT_CHART_CHANGE)
     {
      vm.SetSubWindow("TestSubWindow");
     }
   if(CHARTEVENT_OBJECT_CLICK)
     {
      if(sparam=="b1")
        {
         Alert("CheckedExist()="+IntegerToString(vm.CheckedExist()));
         g.SetState(sparam,false);
         g.Redraw();
        }
     }
  }
//+------------------------------------------------------------------+
