//+------------------------------------------------------------------+
//|                                       eIncGUI_v2_Test_CTable.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme
  {
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
  };

input eColorScheme ColorScheme=DefaultScheme;

CTable tbl;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   ClrScheme.SetScheme(ColorScheme);

//--- CTable
   tbl.Init("CTable",400,100);
   tbl.SetCollsCount(10);
   for(int i=0;i<20;i++)
     {
      tbl.AddRow();
     }
   for(int i=0;i<tbl.RowsCount();i++)
     {
      for(int j=0;j<tbl.CollsCount();j++)
        {
         tbl.SetCellText(i,j,IntegerToString(i)+"-"+IntegerToString(j));
        }
     }
   tbl.SetPos(10,180);
   tbl.SetSubWindow("TestSubWindow");
   tbl.Show();

   w.Button("b1",0,10,20,250,20,"Change AllowSelection");
   w.Button("b2",0,10,45,250,20,"Table 1");
   w.Button("b3",0,10,70,250,20,"Table 2");
   w.Button("b4",0,10,95,250,20,"Table 3");
   w.Button("b5",0,10,120,250,20,"Table 4");
   w.Button("b6",0,10,145,250,20,"Save HTML");
   w.Redraw();
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   w.Delete("b1");
   w.Delete("b2");
   w.Delete("b3");
   w.Delete("b4");
   w.Delete("b5");
   w.Delete("b6");
   tbl.Hide();
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=tbl.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CTable. Cell clicked. Row: "+IntegerToString(tbl.LastClickedRaw())+", column: "+IntegerToString(tbl.LastClickedColl()));
     }
   if(CHARTEVENT_CHART_CHANGE)
     {
      tbl.SetSubWindow("TestSubWindow");
     }
   if(CHARTEVENT_OBJECT_CLICK)
     {
      if(sparam=="b1")
        {
         tbl.SetAllowSelection(!tbl.AllowSelection());
         Sleep(100);
         g.SetState(sparam,false);
         g.Redraw();
        }
      if(sparam=="b2")
        {
         tbl.Clear();
         tbl.SetAllowSelection(false);
         tbl.SetRowsCount(0);
         tbl.SetCollsCount(5);
         tbl.SetRowsCount(10);
         tbl.SetCellsMerge(0,0,1,tbl.CollsCount());
         tbl.SetCellBGColor(0,0,clrYellow);
         tbl.SetCellTxtColor(0,0,clrRed);
         tbl.SetCellFontSize(0,0,10);
         tbl.SetRowHeight(0,25);
         tbl.SetCellText(0,0,"Table-1");
         tbl.SetCollWidth(0,25);
         for(int i=1;i<tbl.CollsCount();i++)
           {
            tbl.SetCollWidth(i,50);
           }
         for(int i=1;i<tbl.RowsCount();i++)
           {
            tbl.SetCellText(i,0,IntegerToString(i));
            tbl.SetCellBGColor(i,0,clrAqua);
            tbl.SetCellTxtColor(i,0,clrBlue);
            tbl.SetCollWidth(0,25);
            for(int j=1;j<tbl.CollsCount();j++)
              {
               tbl.SetCellText(i,j,IntegerToString(i)+"-"+IntegerToString(j));
               if(i%2==1)
                 {
                  tbl.SetCellBGColor(i,j,clrWhiteSmoke);
                 }
               else
                 {
                  tbl.SetCellBGColor(i,j,clrLightGray);
                 }
              }
           }
         tbl.Refresh();
         Sleep(100);
         g.SetState(sparam,false);
         g.Redraw();
        }
      if(sparam=="b3")
        {
         tbl.Clear();
         tbl.SetAllowSelection(false);
         tbl.SetRowsCount(0);
         tbl.SetCollsCount(16);
         tbl.SetRowsCount(16);
         for(int i=0;i<tbl.RowsCount();i++)
           {
            for(int j=0;j<tbl.CollsCount();j++)
              {
               tbl.SetCellText(i,j,IntegerToString(i)+"-"+IntegerToString(j));
               tbl.SetCellBGColor(i,j,clrRed);
              }
           }
         for(int i=0;i<tbl.RowsCount()-1;i++)
           {
            for(int j=i%2;j<tbl.CollsCount()-1;j+=2)
              {
               tbl.SetCellsMerge(i,j,1,2);

              }
           }
         tbl.Refresh();
         Sleep(100);
         g.SetState(sparam,false);
         g.Redraw();
        }
      if(sparam=="b4")
        {
         tbl.Clear();
         tbl.SetAllowSelection(false);
         tbl.SetRowsCount(0);
         tbl.SetCollsCount(16);
         tbl.SetRowsCount(16);
         for(int i=0;i<tbl.RowsCount();i++)
           {
            for(int j=0;j<tbl.CollsCount();j++)
              {
               tbl.SetCellText(i,j,IntegerToString(i)+"-"+IntegerToString(j));
               tbl.SetCellBGColor(i,j,clrYellow);
              }
           }
         for(int i=0;i<tbl.RowsCount();i++)
           {
            for(int j=i%2;j<tbl.CollsCount();j+=2)
              {
               tbl.SetCellsMerge(i,j,2,1);

              }
           }
         tbl.Refresh();
         Sleep(100);
         g.SetState(sparam,false);
         g.Redraw();
        }
      if(sparam=="b5")
        {
         tbl.Clear();
         tbl.SetAllowSelection(false);
         tbl.SetRowsCount(0);
         tbl.SetCollsCount(16);
         tbl.SetRowsCount(16);
         for(int i=0;i<tbl.RowsCount();i++)
           {
            for(int j=0;j<tbl.CollsCount();j++)
              {
               tbl.SetCellText(i,j,IntegerToString(i)+"-"+IntegerToString(j));
               tbl.SetCellBGColor(i,j,clrSalmon);
              }
           }
         int k=0;
         for(int i=0;i<tbl.RowsCount();i+=2)
           {
            for(int j=(k%2)*2;j<tbl.CollsCount();j+=4)
              {
               tbl.SetCellsMerge(i,j,2,2);
               tbl.SetCellBGColor(i,j,clrYellow);
              }
            k+=1;
           }
         tbl.Refresh();
         Sleep(100);
         g.SetState(sparam,false);
         g.Redraw();
        }
      if(sparam=="b6")
        {
         int h=FileOpen("CTableTest.htm",FILE_ANSI|FILE_WRITE);
         if(h!=-1)
           {
            FileWrite(h,tbl.HTML());
            FileClose(h);
            Alert("See CTableTest.htm file");
           }
         else
           {
            Alert("File error");
           }
         Sleep(100);
         g.SetState(sparam,false);
         g.Redraw();
        }
     }
  }
//+------------------------------------------------------------------+
