//+------------------------------------------------------------------+
//|                                  eIncGUI_v2_Test_CRadioGroup.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme
  {
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
  };

input eColorScheme ColorScheme=DefaultScheme;

CRadioGroup rg;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   ClrScheme.SetScheme(ColorScheme);

//--- CRadioGroup
   rg.Init("CRadioGroup");
   rg.AddButton("Radio-1",0,0);
   rg.AddButton("Radio-2",50,0);
   rg.AddButton("Radio-3",100,0);
   rg.SetPos(10,100);
   rg.SetValue(0);
   rg.SetSubWindow("TestSubWindow");
   rg.Show();

   w.Button("b1",0,10,20,250,20,"Change value to 0");
   w.Button("b2",0,10,45,250,20,"Change value to 1");
   w.Button("b3",0,10,70,250,20,"Change value to 2");
   w.Redraw();
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   w.Delete("b1");
   w.Delete("b2");
   w.Delete("b3");
   rg.Hide();
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=rg.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("RadioGroup. Selected "+DoubleToString(rg.Value(),0));
     }
   if(CHARTEVENT_CHART_CHANGE)
     {
      rg.SetSubWindow("TestSubWindow");
     }
   if(CHARTEVENT_OBJECT_CLICK)
     {
      if(sparam=="b1")
        {
         rg.SetValue(0);
         g.SetState(sparam,false);
         g.Redraw();
        }
      if(sparam=="b2")
        {
         rg.SetValue(1);
         g.SetState(sparam,false);
         g.Redraw();
        }
      if(sparam=="b3")
        {
         rg.SetValue(2);
         g.SetState(sparam,false);
         g.Redraw();
        }
     }
  }
//+------------------------------------------------------------------+
