//+------------------------------------------------------------------+
//|                                      eIncGUI_v2_Test_CComBox.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme
  {
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
  };

input eColorScheme ColorScheme=DefaultScheme;

CComBox cmb;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {

   ClrScheme.SetScheme(ColorScheme);

//--- CComBox
   cmb.Init("CComBox",80);
   cmb.SetPos(10,150);
   for(int i=0;i<15;i++)
     {
      cmb.AddItem("Com-"+IntegerToString(i));
     }
   cmb.SetReadOnly(false);
   cmb.Show();
   cmb.SetSubWindow("TestSubWindow");
   cmb.SetSelectedIndex(0);

   w.Button("b1",0,10,20,250,20,"List 1");
   w.Button("b2",0,10,45,250,20,"List 2");
   w.Button("b3",0,10,70,250,20,"Set value \"12345\"");
   w.Button("b4",0,10,95,250,20,"Set value \"Item(2)-15\"");
   w.Button("b5",0,10,120,250,20,"Check value");
   w.Redraw();
   return(0);

  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   w.Delete("b1");
   w.Delete("b2");
   w.Delete("b3");
   w.Delete("b4");
   w.Delete("b5");
   cmb.Hide();
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=cmb.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CComBox. Value "+cmb.Value()+", index: "+IntegerToString(cmb.SelectedIndex()));
     }
   if(CHARTEVENT_CHART_CHANGE)
     {
      cmb.SetSubWindow("TestSubWindow");
     }
   if(CHARTEVENT_OBJECT_CLICK)
     {
      if(sparam=="b1")
        {
         cmb.Clear();
         for(int i=0;i<15;i++)
           {
            cmb.AddItem("Item(1)-"+IntegerToString(i));
           }
         cmb.Refresh();
         g.SetState(sparam,false);
         g.Redraw();
        }
      if(sparam=="b2")
        {
         cmb.Clear();
         for(int i=0;i<25;i++)
           {
            cmb.AddItem("Item(2)-"+IntegerToString(i));
           }
         cmb.Refresh();
         g.SetState(sparam,false);
         g.Redraw();
        }

      if(sparam=="b3")
        {
         cmb.SetValue("12345");
         g.SetState(sparam,false);
         g.Redraw();
        }

      if(sparam=="b4")
        {
         cmb.SetValue("Item(2)-15");
         g.SetState(sparam,false);
         g.Redraw();
         g.SetState(sparam,false);
         g.Redraw();
        }
      if(sparam=="b5")
        {
         Alert("Value: "+cmb.Value());
         g.SetState(sparam,false);
         g.Redraw();
        }
     }
  }
//+------------------------------------------------------------------+
