//+------------------------------------------------------------------+
//|                                    eIncGUI_v2_Test_CCheckBox.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme
  {
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
  };

input eColorScheme ColorScheme=DefaultScheme;

CCheckBox cb;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {

   ClrScheme.SetScheme(ColorScheme);

//--- CCheckBox
   cb.Init("CCheckBox","CCheckBox");
   cb.SetPos(10,50);
   cb.SetSubWindow("TestSubWindow");
   cb.Show();

   w.Button("b1",0,10,20,250,20,"Change Value");
   w.Redraw();
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   w.Delete("b1");
   cb.Hide();
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=cb.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CheckBox. New value "+DoubleToString(cb.Value(),0));
     }
   if(CHARTEVENT_CHART_CHANGE)
     {
      cb.SetSubWindow("TestSubWindow");
     }
   if(CHARTEVENT_OBJECT_CLICK)
     {
      if(sparam=="b1")
        {
         cb.SetValue(!cb.Value());
         Sleep(100);
         g.SetState(sparam,false);
         g.Redraw();
        }
     }
  }
//+------------------------------------------------------------------+
