//+------------------------------------------------------------------+
//|                                          eIncGUI_v2_Test_All.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <IncGUI_v2.mqh>

enum eColorScheme
  {
   DefaultScheme=0,
   YellowBrownScheme=1,
   BlueScheme=2,
   GreenScheme=3,
   YellowBlackScheme=4,
   LimeBlackScheme=5,
   AquaBlackScheme=6
  };

input eColorScheme ColorScheme=DefaultScheme;

CInputBox ib;
CSpinInputBox sib;
CCheckBox cb;
CRadioGroup rg;
CVScrollBar vsb;
CHScrollBar hsb;
CList lst;
CListMS lstm;
CComBox cmb;
CHMenu hm;
CVMenu vm;
CHProgress hp;
CDialer d;
CDialerInputBox dib;
CTable tbl;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   ClrScheme.SetScheme(ColorScheme);
//--- CInputBox
   ib.Init("CInputBox",70,2,"CInputBox");
   ib.SetPos(10,20);
   ib.SetSubWindow("TestSubWindow");
   ib.Show();
//--- CSpinInputBox
   sib.Init("CSpinInputBox",70,0.1,"CSpinInputBox");
   sib.SetPos(ib.Left(),ib.Top()+ib.Height()+5);
   sib.SetMaxValue(1);
   sib.SetMinValue(0.1);
   sib.SetReadOnly(false);
   sib.SetSubWindow("TestSubWindow");
   sib.Show();
//--- CDialerInputBox
   dib.Init("CDialerInputBox",70,4,"CDialerInputBox");
   dib.SetPos(sib.Left(),sib.Top()+sib.Height()+5);
   dib.SetSubWindow("TestSubWindow");
   dib.Show();
//--- CComBox
   cmb.Init("CComBox",70);
   cmb.SetPos(dib.Left(),dib.Top()+dib.Height()+5);
   for(int i=0;i<15;i++)
     {
      cmb.AddItem("Com-"+IntegerToString(i));
     }
   cmb.SetReadOnly(false);
   cmb.Show();
   cmb.SetSubWindow("TestSubWindow");
   cmb.SetSelectedIndex(0);
//--- CCheckBox
   cb.Init("CCheckBox","CCheckBox");
   cb.SetPos(cmb.Left(),cmb.Top()+cmb.Height()+5);
   cb.SetSubWindow("TestSubWindow");
   cb.Show();
//--- CRadioGroup
   rg.Init("CRadioGroup");
   rg.AddButton("Radio-1",0,0);
   rg.AddButton("Radio-2",50,0);
   rg.AddButton("Radio-3",100,0);
   rg.SetPos(cb.Left(),cb.Top()+cb.Height()+5);
   rg.SetValue(0);
   rg.SetSubWindow("TestSubWindow");
   rg.Show();
//--- CHSrollBar
   hsb.Init("CHSrollBar",100,1);
   hsb.SetPos(rg.Left(),rg.Top()+rg.Height()+5);
   hsb.SetSubWindow("TestSubWindow");
   hsb.Show();
//--- CHMenu
   hm.Init("cHMenu",300,3);
   for(int i=0;i<9;i++)
     {
      hm.AddItem("HMenuItem-"+IntegerToString(i),false);
     }
   hm.SetPos(hsb.Left(),hsb.Top()+hsb.Height()+5);
   hm.SetSubWindow("TestSubWindow");
   hm.Show();
//--- CHProgress
   hp.Init("CHProgress",300);
   hp.SetPos(hm.Left(),hm.Top()+hm.Height()+5);
   hp.SetSubWindow("TestSubWindow");
   hp.Show();
   hp.Begin(0,100);
   hp.SetValue(50);
//--- CVSrollBar
   vsb.Init("CVSrollBar",100,1);
   vsb.SetPos(170,20);
   vsb.SetSubWindow("TestSubWindow");
   vsb.Show();
//--- CList
   lst.Init("CList",100,8);
   lst.SetPos(190,20);
   for(int i=0;i<55;i++)
     {
      lst.AddItem("Item-"+IntegerToString(i));
     }
   lst.SetSubWindow("TestSubWindow");
   lst.Show();
//--- CListMS
   lstm.Init("CListMS",100,8);
   lstm.SetPos(lst.Left()+lst.Width()+5,20);
   for(int i=0;i<55;i++)
     {
      lstm.AddItem("Item-"+IntegerToString(i));
     }
   lstm.SetSubWindow("TestSubWindow");
   lstm.Show();
   lstm.SetSelected(0,true);
   lstm.SetSelected(2,true);
//--- CVMenu
   vm.Init("CVMenu",95,8);
   for(int i=0;i<50;i++)
     {
      vm.AddItem("VMenuItem-"+IntegerToString(i),false);
     }
   vm.SetPos(lstm.Left()+lstm.Width()+5,lstm.Top());
   vm.SetSubWindow("TestSubWindow");
   vm.Show();
//--- CDialer
   d.Init("CDiler");
   d.SetPos(hm.Left()+hp.Width()+50,hm.Top()+20);
   d.SetSubWindow("TestSubWindow");
   d.Show();

//--- CTable
   tbl.Init("CTable",400,100);
   tbl.SetCollsCount(10);
   for(int i=0;i<20;i++)
     {
      tbl.AddRow();
     }
   for(int i=0;i<tbl.RowsCount();i++)
     {
      for(int j=0;j<tbl.CollsCount();j++)
        {
         tbl.SetCellText(i,j,IntegerToString(i)+"-"+IntegerToString(j));
        }
     }
   tbl.SetPos(hp.Left(),hp.Top()+hp.Height()+5);
   tbl.SetSubWindow("TestSubWindow");
   tbl.Show();

//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   ib.Hide();
   sib.Hide();
   cb.Hide();
   rg.Hide();
   vsb.Hide();
   hsb.Hide();
   lst.Hide();
   lstm.Hide();
   cmb.Hide();
   hm.Hide();
   vm.Hide();
   hp.Hide();
   d.Hide();
   dib.Hide();
   tbl.Hide();
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
   int ev;
   ev=ib.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CInputBox. New value "+ib.ValueString());
     }
   ev=sib.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("InputBox. New value "+DoubleToString(sib.Value(),sib.Digits())+" (entered)");
     }
   if(ev==2)
     {
      Alert("InputBox. New value "+DoubleToString(sib.Value(),sib.Digits())+" (modified by a button)");
     }
   ev=cb.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CheckBox. New value "+DoubleToString(cb.Value(),0));
     }
   ev=rg.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("RadioGroup. Selected "+DoubleToString(rg.Value(),0));
     }
   ev=vsb.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CVSrollBar. New value "+DoubleToString(vsb.Value(),0));
     }
   ev=hsb.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CHSrollBar. New value "+DoubleToString(hsb.Value(),0));
     }
   ev=lst.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CList. Deselected");
     }
   if(ev==2)
     {
      Alert("CList. Item selected "+DoubleToString(lst.SelectedIndex(),0)+" ("+lst.SelectedText()+")");
     }
   ev=lstm.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CListMS. One item deselected "+lstm.Text(lstm.LastChanged()));
     }
   if(ev==2)
     {
      Alert("CListMS. Selection of one item added "+lstm.Text(lstm.LastChanged()));
     }
   ev=cmb.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CComBox. Value "+cmb.Value()+", index: "+IntegerToString(cmb.SelectedIndex()));
     }
   ev=hm.Event(id,lparam,dparam,sparam);
   if(ev>=0)
     {
      Alert("CHMenu. Item clicked "+IntegerToString(ev)+"(X: "+IntegerToString(hm.LastClickedX())+", Y: "+IntegerToString(hm.LastClickedY())+", quarter: "+IntegerToString(hm.LastClickedQuarter())+")");
      if(hm.Checked(ev))
        {
         hm.SetChecked(ev,false);
        }
      else
        {
         hm.SetChecked(ev,true);
        }
     }
   ev=vm.Event(id,lparam,dparam,sparam);
   if(ev>=0)
     {
      Alert("CMenu. Item clicked "+IntegerToString(ev)+"(X: "+IntegerToString(vm.LastClickedX())+", Y: "+IntegerToString(vm.LastClickedY())+", quarter: "+IntegerToString(vm.LastClickedQuarter())+")");
      if(vm.Checked(ev))
        {
         vm.SetChecked(ev,false);
        }
      else
        {
         vm.SetChecked(ev,true);
        }
     }
   ev=d.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CDiler. Dialed: "+DoubleToString(d.Value()));
     }
   ev=dib.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CDialerInputBox. New value: "+DoubleToString(dib.Value()));
     }
   ev=tbl.Event(id,lparam,dparam,sparam);
   if(ev==1)
     {
      Alert("CTable. Cell clicked. Row: "+IntegerToString(tbl.LastClickedRaw())+", column: "+IntegerToString(tbl.LastClickedColl()));
     }
   if(CHARTEVENT_CHART_CHANGE)
     {
      ib.SetSubWindow("TestSubWindow");
      sib.SetSubWindow("TestSubWindow");
      cb.SetSubWindow("TestSubWindow");
      rg.SetSubWindow("TestSubWindow");
      vsb.SetSubWindow("TestSubWindow");
      hsb.SetSubWindow("TestSubWindow");
      lst.SetSubWindow("TestSubWindow");
      lstm.SetSubWindow("TestSubWindow");
      cmb.SetSubWindow("TestSubWindow");
      hm.SetSubWindow("TestSubWindow");
      vm.SetSubWindow("TestSubWindow");
      hp.SetSubWindow("TestSubWindow");
      d.SetSubWindow("TestSubWindow");
      dib.SetSubWindow("TestSubWindow");
      tbl.SetSubWindow("TestSubWindow");
     }
  }
//+------------------------------------------------------------------+
