//----------------------------------------------------------------------------
//                                                                  s4plot.mq5
//                                   Copyright 2011, MetaQuotes Software Corp.
//                                                         http://www.mql5.com
//----------------------------------------------------------------------------
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#import "shell32.dll"
bool ShellExecuteW(int hwnd,string lpOperation,string lpFile,
                  string lpParameters,string lpDirectory,int nShowCmd);
#import

struct statParam
  {
  double mean;
  double median;
  double var;
  double stdev;
  double skew;
  double kurt;
  };
//----------------------------------------------------------------------------
// Script program start function
//----------------------------------------------------------------------------
void OnStart()
  {
  int i;
  double dat[128],histo[],rankit[],xrankit[];
  statParam sp;
 
  MathSrand(1);
  for(i=0;i<ArraySize(dat);i++) dat[i]=MathRand();
  
  if(dStat(dat,sp)==-1)return;
  if(dHist(dat,histo,sp)==-1)return;
  if(dRankit(dat,rankit,xrankit,sp)==-1)return;
  
  vis4plot(dat,histo,rankit,xrankit,sp,6);

  }
//----------------------------------------------------------------------------
void vis4plot(const double &x[],const double &histo[],const double &rankit[],
                          const double &xrankit[],statParam &sp,int format=-5)
  {
  int i;
  double d,yma,ymi,ar1,ar2;
  string str;

  yma=x[0];ymi=x[0];
  for(i=0;i<ArraySize(x);i++)
    {
    if(yma<x[i])yma=x[i];
    if(ymi>x[i])ymi=x[i];
    }
  d=(yma-ymi)/20.0;
  yma+=d;ymi-=d;
  str="unset key\n";
  str+="unset tics\n";
  str+="set multiplot\n";
  str+="set title offset -0.5,-0.5\n";
  str+="set style line 21 lc rgb 'medium-blue' pt 1 ps 0.4\n";
  str+="set tmargin 2\n";
  str+="set bmargin 0.4\n";
    
  str+="set size 0.5,0.4; set origin 0.0,0.6\n";
  str+="set title 'Sequence Plot (n="+(string)ArraySize(x)+
                           ")' font 'Times New Roman,10'\n";
  str+="set yrange ["+DoubleToString(ymi,-10)+
       ":"+DoubleToString(yma,-10)+"]\n";
  str+="set xrange [0:"+(string)ArraySize(x)+"]\n";
  str+="plot "+DoubleToString(sp.mean,-10)+
       " ls 0, '-' with line lt rgb 'medium-blue'\n";
  for(i=0;i<ArraySize(x);i++)str+=DoubleToString(x[i],-10)+"\n";
  str+="e\n";

  str+="set size 0.5,0.4; set origin 0.5,0.6\n";
  str+="set xrange ["+DoubleToString(ymi,-10)+
       ":"+DoubleToString(yma,-10)+"]\n";
  str+="set title 'Lag Plot' font 'Times New Roman,10'\n";
  str+="plot '-' with points ls 21\n";
  for(i=0;i<ArraySize(x)-1;i++)str+=DoubleToString(x[i],-10)+
                          " "+DoubleToString(x[i+1],-10)+"\n";
  str+="e\n";

  yma=histo[0];
  for(i=0;i<ArraySize(histo);i++)if(yma<histo[i])yma=histo[i];
  yma=yma*1.1;
  str+="set size 0.5,0.4; set origin 0.0,0.2\n";
  str+="set yrange [*:"+DoubleToString(yma,-10)+"]\n";
  str+="set xrange [*:*]\n";
  str+="set title 'Histogram' font 'Times New Roman,10'\n";
  str+="set style fill solid 1 border rgb 'medium-blue'\n";
  str+="plot '-' with boxes lt rgb '#f7f7f7'\n";
  for(i=0;i<ArraySize(histo);i++)str+=DoubleToString(histo[i],-10)+"\n";
  str+="e\n";
    
  yma=rankit[ArraySize(rankit)-1];ymi=rankit[0];
  if(xrankit[ArraySize(rankit)-1]>yma)yma=xrankit[ArraySize(rankit)-1];
  if(xrankit[0]<ymi)ymi=xrankit[0];
  d=(yma-ymi)/20.0;
  ar1=ymi;ar2=yma;
  yma+=d;ymi-=d;
  str+="set size 0.5,0.4; set origin 0.5,0.2\n";
  str+="set title 'Normal Probability Plot' font 'Times New Roman,10'\n";
  str+="set yrange ["+DoubleToString(ymi,-10)+
             ":"+DoubleToString(yma,-10)+"]\n";
  str+="set xrange ["+DoubleToString(ymi,-10)+
             ":"+DoubleToString(yma,-10)+"]\n";
  str+="set arrow from "+DoubleToString(ar1,-10)+
       ","+DoubleToString(ar1,-10)+" to "+DoubleToString(ar2,-10)+
                      ","+DoubleToString(ar2,-10)+" nohead ls 0\n";
  str+="plot '-' with points ls 21\n";
  for(i=0;i<ArraySize(rankit);i++)str+=DoubleToString(xrankit[i],-10)+
                                " "+DoubleToString(rankit[i],-10)+"\n";
  str+="e\n";
  
  str+="set tmargin 4\n";
  str+="set size 0.5,0.2; set origin 0.0,0.0\n";
  str+="unset border\n";
  str+="unset arrow\n";
  str+="set title \"  Mean= "+DoubleToString(sp.mean,format)+
              "\\nMedian= "+DoubleToString(sp.median,format)+
                 "\\n   Var= "+DoubleToString(sp.var,format)+
                             "\" font 'Courier New,10'\n";
  str+="plot [][0:1] 2\n";

  str+="set size 0.5,0.2; set origin 0.5,0.0\n";
  str+="set title \" StDev= "+DoubleToString(sp.stdev,format)+
                 "\\n  Skew= "+DoubleToString(sp.skew,format)+
                 "\\nExKurt= "+DoubleToString(sp.kurt-3,format)+
                             "\" font 'Courier New,10'\n";
  str+="plot [][0:1] 2\n";
  str+="unset multiplot\n";

  if(!saveScript(str)){Print("Create script file error");return;}
  if(!grPlot())Print("ShellExecuteW() error");
  }
//----------------------------------------------------------------------------
bool grPlot()
  {
  string pnam,param;
  
  pnam="GNUPlot\\binary\\wgnuplot.exe";
  param="-p MQL5\\Files\\gplot.txt";
  return(ShellExecuteW(NULL,"open",pnam,param,NULL,1));
  }
//----------------------------------------------------------------------------
bool saveScript(string scr1="",string scr2="")
  {
  int fhandle;
  
  fhandle=FileOpen("gplot.txt",FILE_WRITE|FILE_TXT|FILE_ANSI);
  if(fhandle==INVALID_HANDLE)return(false);
  FileWriteString(fhandle,"set terminal windows size 500,600 font 8\n");
  FileWriteString(fhandle,scr1);
  if(scr2!="")FileWriteString(fhandle,scr2);
  FileClose(fhandle);
  return(true);
  }
//----------------------------------------------------------------------------
int dStat(const double &x[],statParam &sP)
  {
  int i,m,n;
  double a,b,sum2,sum3,sum4,y[];
  
  ZeroMemory(sP);                                      // Reset sP
  n=ArraySize(x);
  if(n<4)                                              // Error
    {
    Print("Function dStat() error!");
    return(-1);
    }
  sP.kurt=1.0;
  ArrayResize(y,n);
  ArrayCopy(y,x);
  ArraySort(y);
  m=(n-1)/2;
  sP.median=y[m];                                      // Median
  if((n&0x01)==0)sP.median=(sP.median+y[m+1])/2.0;
  sP.mean=0;
  for(i=0;i<n;i++)sP.mean+=x[i];
  sP.mean/=n;                                          // Mean
  sum2=0;sum3=0;sum4=0;  
  for(i=0;i<n;i++)
    {
    a=x[i]-sP.mean;
    b=a*a;sum2+=b;
    b=b*a;sum3+=b;
    b=b*a;sum4+=b;
    }
  if(sum2<1.e-150)return(1);
  sP.var=sum2/(n-1);                                   // Variance
  sP.stdev=MathSqrt(sP.var);                           // Standard deviation
  sP.skew=n*sum3/(n-2)/sum2/sP.stdev;                  // Skewness
  sP.kurt=((n*n-2*n+3)*sum4/sum2/sum2-(6.0*n-9.0)/n)*
                              (n-1.0)/(n-2.0)/(n-3.0); // Kurtosis
  
  return(1);  
  }
//----------------------------------------------------------------------------
int dHist(const double &x[],double &histo[],const statParam &sp)
  {
  int i,k,n,nbar;
  double a[],max,s,xmin;
  
  if(!ArrayIsDynamic(histo))                           // Error
    {
    Print("Function dHist() error!");
    return(-1);
    }
  n=ArraySize(x);
  if(n<4)                                              // Error
    {
    Print("Function dHist() error!");
    return(-1);
    }
  nbar=(sp.kurt+1.5)*MathPow(n,0.4)/6.0;
  if((nbar&0x01)==0)nbar--; if(nbar<5)nbar=5;          // Number of bars
  ArrayResize(a,n);
  ArrayCopy(a,x);
  max=0.0;
  for(i=0;i<n;i++)
    {
    a[i]=(a[i]-sp.mean)/sp.stdev;                      // Normalization
    if(MathAbs(a[i])>max)max=MathAbs(a[i]);
    }
  xmin=-max;
  s=2.0*max*n/nbar;
  ArrayResize(histo,nbar+2);
  ArrayInitialize(histo,0.0);
  histo[0]=0.0;histo[nbar+1]=0.0;
  for(i=0;i<n;i++)
    {
    k=(a[i]-xmin)/max/2.0*nbar;
    if(k>(nbar-1))k=nbar-1;
    histo[k+1]++;
    }
  for(i=0;i<nbar;i++)histo[i+1]/=s;
  
  return(1);
  }
//----------------------------------------------------------------------------
int dRankit(const double &x[],double &resp[],double &xscale[],const statParam &sp)
  {
  int i,n;
  double np;
  
  if(!ArrayIsDynamic(resp)||!ArrayIsDynamic(xscale))   // Error
    {
    Print("Function dHist() error!");
    return(-1);
    }
  n=ArraySize(x);
  if(n<4)                                               // Error
    {
    Print("Function dHist() error!");
    return(-1);
    }
  ArrayResize(resp,n);
  ArrayCopy(resp,x);
  ArraySort(resp);
  for(i=0;i<n;i++)resp[i]=(resp[i]-sp.mean)/sp.stdev;
  ArrayResize(xscale,n);
  xscale[n-1]=MathPow(0.5,1.0/n);
  xscale[0]=1-xscale[n-1];
  np=n+0.365;
  for(i=1;i<(n-1);i++)xscale[i]=(i+1-0.3175)/np;
  for(i=0;i<n;i++)xscale[i]=ltqnorm(xscale[i]);
  
  return(1);
  }


//----------------------------------------------------------------------------
double A1 = -3.969683028665376e+01, A2 =  2.209460984245205e+02,
       A3 = -2.759285104469687e+02, A4 =  1.383577518672690e+02,
       A5 = -3.066479806614716e+01, A6 =  2.506628277459239e+00;
double B1 = -5.447609879822406e+01, B2 =  1.615858368580409e+02,
       B3 = -1.556989798598866e+02, B4 =  6.680131188771972e+01,
       B5 = -1.328068155288572e+01;
double C1 = -7.784894002430293e-03, C2 = -3.223964580411365e-01,
       C3 = -2.400758277161838e+00, C4 = -2.549732539343734e+00,
       C5 =  4.374664141464968e+00, C6 =  2.938163982698783e+00;
double D1 =  7.784695709041462e-03, D2 =  3.224671290700398e-01,
       D3 =  2.445134137142996e+00, D4 =  3.754408661907416e+00;
//----------------------------------------------------------------------------
double ltqnorm(double p)
  {
  int s=1;
  double r,x,q=0;

  if(p<=0||p>=1){Print("Function ltqnorm() error!");return(0);}
  if((p>=0.02425)&&(p<=0.97575)) // Rational approximation for central region
    {
    q=p-0.5; r=q*q;
    x=(((((A1*r+A2)*r+A3)*r+A4)*r+A5)*r+A6)*q/(((((B1*r+B2)*r+B3)*r+B4)*r+B5)*r+1);
    return(x);
    }
  if(p<0.02425)                    // Rational approximation for lower region
    {
    q=sqrt(-2*log(p)); 
    s=1;
    }
  else      //if(p>0.97575)        // Rational approximation for upper region
    {
    q = sqrt(-2*log(1-p));
    s=-1;
    }
  x=s*(((((C1*q+C2)*q+C3)*q+C4)*q+C5)*q+C6)/((((D1*q+D2)*q+D3)*q+D4)*q+1);
  return(x);
  }
  
