//+------------------------------------------------------------------+
//|                                                   			 Node |
//|                             Copyright 2006-2011, www.FXmaster.de |
//|                                                  www.FXmaster.de |
//+------------------------------------------------------------------+
#property copyright "Copyright 2006-2011, www.FXmaster.de"
#property link      "www.FXmaster.de"
#property version   "1.00"

#define NIL(p)	(CheckPointer(p)==POINTER_INVALID)

//------------------------------------------------------------------	struct tagWatch
struct tagWatch
{
	string m_name; // name of value
	string m_val;	// value
};

class CNode; // forward declaration
//------------------------------------------------------------------	class CNodeBase
class CNodeBase
{
public:
	CNode *m_next[]; // list of node to which it points
	CNode *m_prev; // parent node
	int m_id; // unique number
	string m_text; // text
	
public:
	CNodeBase() { m_id=0; m_text=""; } // constructor
	~CNodeBase(); // destructor
};
//------------------------------------------------------------------	~CNodeInfo
void CNodeBase::~CNodeBase()
{
	for (int i=0; i<ArraySize(m_next); i++) // deleting the array
		if (CheckPointer(m_next[i])==POINTER_DYNAMIC) delete m_next[i]; 
	m_prev=NULL; ArrayResize(m_next, 0);
}

//------------------------------------------------------------------	class CNode
class CNode : public CNodeBase
{
public:
	bool m_expand; // expanded
	bool m_check; // market with a dot
	bool m_select; // highlighted
	bool m_edit; // editable
	
	//--- run-time information
	int m_uses; // number of calls of the node
	long m_tick; // time spent in the node
	long m_tick0; // time of entering the node
	datetime m_last; // time of entering the node
	tagWatch m_watch[]; // list of name/value parameters
	bool m_break; // debug-break
	int m_brkuse; // stop at a function when m_uses reaches the m_brkuse value

	//--- parameters of call
	string m_path; // file name
	string m_file; // file name
	int m_line; // number of row in the file
	string m_class; // class name
	string m_func; // function name
	string m_desc; // additional description of a node

public:
	CNode(); // constructor
	~CNode(); // destructor

	void AddWatch(string watch, string val);
};
//------------------------------------------------------------------	CNode
void CNode::CNode()
{
	m_id=0; m_text="";
	m_expand=true; m_check=false; m_select=false; m_edit=false;
	m_desc=""; m_uses=0; m_tick=0; m_tick0=0; m_last=0; m_brkuse=-2;
	m_path=""; m_file=""; m_line=0; m_class=""; m_func="";
}
//------------------------------------------------------------------	~CNode
void CNode::~CNode()
{
	for (int i=0; i<ArraySize(m_next); i++) // deleting the array
		if (CheckPointer(m_next[i])==POINTER_DYNAMIC) delete m_next[i]; 
	m_prev=NULL; ArrayResize(m_next, 0);
}
//------------------------------------------------------------------	Watch
void CNode::AddWatch(string name, string val)
{
	int n=ArraySize(m_watch); bool b=false;
	for (int i=0; i<n; i++) if (m_watch[i].m_name==name) { m_watch[i].m_val=val; b=true; break; }
	if (b) return;
	ArrayResize(m_watch, n+1); m_watch[n].m_name=name; m_watch[n].m_val=val;
}
