//+------------------------------------------------------------------+
//|                                     DemoTradeEventProcessing.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

input    int days=7;            // depth of trade history in days
int          orders;            // number of active orders
int          positions;         // number of open positions
int          deals;             // number of deals in the trade history cache
int          history_orders;    // number of orders in the trade history cache
bool         started=false;     // flag of initialization of the counters
//--- let's set the limits of the trade history on the global scope
datetime     start;             // start date for trade history in cache
datetime     end;               // end date for trade history in cache 
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   end=TimeCurrent();
   start=end-days*PeriodSeconds(PERIOD_D1);
   PrintFormat("Limits of the history to be loaded: start - %s, end - %s",
               TimeToString(start),TimeToString(end));
   InitCounters();
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//--- 
   if(started) SimpleTradeProcessor();
   else InitCounters();
  }
//+------------------------------------------------------------------+
//| Called when a Trade event comes                                  |
//+------------------------------------------------------------------+
void OnTrade()
  {
   if(started) SimpleTradeProcessor();
   else InitCounters();
  }
//+------------------------------------------------------------------+
//|  initialization of the counters of positions, orders and deals   |
//+------------------------------------------------------------------+
void InitCounters()
  {
   ResetLastError();
//--- load history 
   bool selected=HistorySelect(start,end);
   if(!selected)
     {
      PrintFormat("%s. Failed to load the history from %s to %s to the cache. Error code: %d",
                  __FUNCTION__,TimeToString(start),TimeToString(end),GetLastError());
      return;
     }
//--- get current value
   orders=OrdersTotal();
   positions=PositionsTotal();
   deals=HistoryDealsTotal();
   history_orders=HistoryOrdersTotal();
   started=true;
   Print("The counters of orders, positions and deals are successfully initialized");
  }
//+------------------------------------------------------------------+
//| a simple example of processing changes in trade and history      |
//+------------------------------------------------------------------+
void SimpleTradeProcessor()
  {
   end=TimeCurrent();
   ResetLastError();
//--- load history 
   bool selected=HistorySelect(start,end);
   if(!selected)
     {
      PrintFormat("%s. Failed to load the history from %s to %s to the cache. Error code: %d",
                  __FUNCTION__,TimeToString(start),TimeToString(end),GetLastError());
      return;
     }

//--- get current value
   int curr_orders=OrdersTotal();
   int curr_positions=PositionsTotal();
   int curr_deals=HistoryDealsTotal();
   int curr_history_orders=HistoryOrdersTotal();

//--- check if the number of active orders has been changed
   if(curr_orders!=orders)
     {
      //--- number of active orders has been changed
      PrintFormat("Number of orders has been changed. Previous value is %d, current value is %d",
                  orders,curr_orders);
     /*
       other actions connected with change of orders
     */
      //--- update value
      orders=curr_orders;
     }

//--- changes in the number of open positions
   if(curr_positions!=positions)
     {
      //--- number of open positions has been changed
      PrintFormat("Number of positions has been changed. Previous value is %d, current value is %d",
                  positions,curr_positions);
      /*
       other actions connected with change of positions
      */
      //--- update value
      positions=curr_positions;
     }

//--- changes in the number of deals in the trade history cache
   if(curr_deals!=deals)
     {
      //--- number of deals in the trade history cache has been changed
      PrintFormat("Number of deals has been changed. Previous value is %d, current value is %d",
                  deals,curr_deals);
      /*
       other actions connected with change of deals
      */
      //--- update value
      deals=curr_deals;
     }

//--- changes in the number of history orders in the trade history cache
   if(curr_history_orders!=history_orders)
     {
      //--- number of history orders in the trade history cache has been changed
      PrintFormat("Number of orders in the history has been changed. Previous value is %d, current value is %d",
                  history_orders,curr_history_orders);
     /*
       other actions connected with change of the number of orders in the trade history cache
     */
     //--- update value
     history_orders=curr_history_orders;
     }
//--- checking if it is necessary to change the limits of th trade history to be requested in cache
   CheckStartDateInTradeHistory();
  }
//+------------------------------------------------------------------+
//|  changing the start date for requesting of the trade history     |
//+------------------------------------------------------------------+
void CheckStartDateInTradeHistory()
  {
//--- initial interval, as if we started working right now
   datetime curr_start=TimeCurrent()-days*PeriodSeconds(PERIOD_D1);
//--- make sure that the start limit of the trade history has not gone 
//--- more than 1 day over intended date
   if(curr_start-start>PeriodSeconds(PERIOD_D1))
     {
      //--- we should correct the start date of history to be loaded in the cache 
      start=curr_start;
      PrintFormat("New start limit of the trade history to be loaded: start => %s",
                  TimeToString(start));

      //--- now load the trade history for the corrected period again
      HistorySelect(start,end);

      //--- correct the number of deals and orders in the history for further comparison
      history_orders=HistoryOrdersTotal();
      deals=HistoryDealsTotal();
     }
  }
//+------------------------------------------------------------------+
