//+------------------------------------------------------------------+
//|                                     Project 30 Balance Curve.mq5 |
//|                                             Abioye Israel Pelumi |
//|                             https://linktr.ee/abioyeisraelpelumi |
//+------------------------------------------------------------------+
#property copyright "Abioye Israel Pelumi"
#property link      "https://linktr.ee/abioyeisraelpelumi"
#property version   "1.00"
#property indicator_separate_window
input bool show_pro  = false;


string File_name = "Trading_Journal.csv";
int Total_deals;
double balance_progression[];

int last_total_deals = 0;

string y = "Y Axis";
string x = "X Axis";
double max_cumulative;
double min_cumulative;

double profit_loss[];
string chart_lines;
string p_l;
string d_sign;



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {

   BalanceCurve(File_name,Total_deals,balance_progression,profit_loss);
// Print("\nBalance Progression: ");
// ArrayPrint(balance_progression);


//--- create timer
   EventSetTimer(60);

//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {

//--- destroy timer
   EventKillTimer();
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {
//---

   if(rates_total >= Total_deals && Total_deals != last_total_deals)
     {
     
    IndicatorSetString(INDICATOR_SHORTNAME, "Balance Curve");
    int indicator_window = ChartWindowFind(ChartID(),"Balance Curve");
    
   // Comment(indicator_window);
    
      ObjectsDeleteAll(ChartID(),indicator_window,OBJ_TREND);

      //MAX AND MIN Indicator Window
      max_cumulative  = balance_progression[ArrayMaximum(balance_progression,0,WHOLE_ARRAY)];
      min_cumulative  = balance_progression[ArrayMinimum(balance_progression,0,WHOLE_ARRAY)];

      // Creating y and x axis
      ObjectCreate(0,y,OBJ_TREND,indicator_window,time[rates_total - Total_deals],0,time[rates_total - Total_deals],max_cumulative);
      ObjectCreate(0,x,OBJ_TREND,indicator_window,time[rates_total - Total_deals],0,time[rates_total - 1],0);

      IndicatorSetDouble(INDICATOR_MAXIMUM, max_cumulative);  // maximum value
      IndicatorSetDouble(INDICATOR_MINIMUM,min_cumulative);  // minimum value

      int c = 0;


      for(int i = rates_total - Total_deals; i <= rates_total - 2; i++)
        {

         chart_lines = StringFormat("Lines %d", c);


         if(ObjectFind(0, chart_lines) == -1)
           {

            ObjectCreate(0,chart_lines,OBJ_TREND,indicator_window,time[i],balance_progression[c],time[i+1],balance_progression[c+1]);

           }
         else
           {
            ObjectMove(0, chart_lines, 0, time[i], balance_progression[c]);
            ObjectMove(0, chart_lines, 1, time[i+1], balance_progression[c+1]);
           }



         p_l = StringFormat("Profit-Loss %d", c);
         if(show_pro == true)
           {
            if(ObjectFind(0, p_l) == -1)
              {
               ObjectCreate(0,p_l,OBJ_TEXT,1,time[i],balance_progression[c]);
              }
            else
              {
               ObjectMove(0, p_l, 0, time[i], balance_progression[c]);

              }

           }
         else
           {
            ObjectDelete(0,p_l);
           }

         if(profit_loss[c] > 0)
           {

            d_sign = "$";

           }

         if(profit_loss[c] <= 0)
           {

            d_sign = "-$";

           }


         ObjectSetString(0,p_l,OBJPROP_TEXT, d_sign + DoubleToString(MathAbs(profit_loss[c]),2));



         c++;

        }



      last_total_deals = Total_deals;
     }


   return(rates_total);
  }
//+------------------------------------------------------------------+
//| Timer function                                                   |
//+------------------------------------------------------------------+
void OnTimer()
  {


   BalanceCurve(File_name,Total_deals,balance_progression,profit_loss);


  }
//+-----------------------------------------------------------------+
//| Balance curve function                                           |
//+------------------------------------------------------------------+
void BalanceCurve(string Filename, int &total_deals, double &cumulative[], double &pro_loss[])
  {


   int file_handle = FileOpen(Filename, FILE_READ | FILE_CSV | FILE_ANSI, ',');

   if(file_handle == INVALID_HANDLE)
     {
      Print("Failed to open file. Error: ", GetLastError());
     }

   else
      if(file_handle != INVALID_HANDLE)
        {


         //counting total elements
         int   total_elements_count = 0;
         while(!FileIsEnding(file_handle))
           {
            FileReadString(file_handle);
            total_elements_count++;
           }


         FileSeek(file_handle, 0, SEEK_SET);


         //storing in array
         string TotalElements[];
         ArrayResize(TotalElements,total_elements_count);

         for(int i = 0; i < total_elements_count; i++)
           {

            TotalElements[i] = FileReadString(file_handle);

           }


         //Serching Profit($) header
         int profit_header_index;

         for(int i = 0; i < total_elements_count; i++)
           {

            if(TotalElements[i] == "Profit($)")
              {

               profit_header_index = i;

               break;
              }

           }


         //Comment(profit_header_index);

         //Getting total deals
         int total_deal_index;

         for(int i = 0; i < total_elements_count; i++)
           {

            if(TotalElements[i] == "Total Trades:")
              {

               total_deal_index = i + 1;

               break;
              }

           }

         total_deals = (int)StringToInteger(TotalElements[total_deal_index]);

         // saving all profit/loss in one dynamic array

         ArrayResize(pro_loss,total_deals);
         int profit_count = 0;


         for(int i = profit_header_index + 12; i < total_elements_count; i += 12)
           {

            pro_loss[profit_count] = StringToDouble(TotalElements[i]);
            profit_count++;
           }

         // Print("Profit/Loss:");
         //  ArrayPrint(pro_loss);

         //saving all progit progression in one dynamic array
         ArrayResize(cumulative,total_deals);
         double running_total = 0.0;

         for(int i = 0; i < total_deals; i++)
           {

            running_total += pro_loss[i];
            cumulative[i] = running_total;

           }




         FileClose(file_handle);

        }


  }






//+------------------------------------------------------------------+
