//+------------------------------------------------------------------+
//|                                           Project 29 Files 2.mq5 |
//|                                             Abioye Israel Pelumi |
//|                             https://linktr.ee/abioyeisraelpelumi |
//+------------------------------------------------------------------+
#property copyright "Abioye Israel Pelumi"
#property link      "https://linktr.ee/abioyeisraelpelumi"
#property version   "1.00"



//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---

   string Filename = "Trading_Journal.csv";

   int  file_handle = FileOpen(Filename, FILE_READ | FILE_CSV | FILE_ANSI, ',');



   if(file_handle == INVALID_HANDLE)
     {
      Print("Failed to open file. Error: ", GetLastError());
     }

   else
      if(file_handle != INVALID_HANDLE)
        {

         int total_elements_count = 0;
         while(!FileIsEnding(file_handle))
           {
            FileReadString(file_handle);
            total_elements_count++;
           }

         // Print(total_elements_count);

         FileSeek(file_handle, 0, SEEK_SET);
         string TotalElements[];
         ArrayResize(TotalElements,total_elements_count);

         for(int i = 0; i < total_elements_count; i++)
           {

            TotalElements[i] = FileReadString(file_handle);

           }



         int total_deals = (int)StringToInteger(TotalElements[10]);

         // TradeID
         ulong TradeID[];
         ArrayResize(TradeID,total_deals);

         int id_count = 0;

         for(int i = 24; i < total_elements_count; i += 12)
           {

            TradeID[id_count] = (ulong)StringToInteger(TotalElements[i]);
            id_count++;
           }

         //symbol
         string symbol[];
         ArrayResize(symbol,total_deals);

         int sym_count = 0;

         for(int i = 25; i < total_elements_count; i += 12)
           {

            symbol[sym_count] = TotalElements[i];
            sym_count++;
           }


         //OrderType

         string OrderType[];
         ArrayResize(OrderType,total_deals);

         int order_type_count = 0;

         for(int i = 26; i < total_elements_count; i += 12)
           {

            OrderType[order_type_count] = TotalElements[i];
            order_type_count++;
           }

         //LotSize
         double LotSize[];
         ArrayResize(LotSize,total_deals);

         int lot_count = 0;

         for(int i = 27; i < total_elements_count; i += 12)
           {

            LotSize[lot_count] = StringToDouble(TotalElements[i]);
            lot_count++;
           }

         //OpenTime
         datetime OpenTime[];
         ArrayResize(OpenTime,total_deals);

         int open_time_count = 0;

         for(int i = 28; i < total_elements_count; i += 12)
           {

            OpenTime[open_time_count] = StringToTime(TotalElements[i]);
            open_time_count++;
           }



         //OpenPrice
         double OpenPrice[];
         ArrayResize(OpenPrice,total_deals);

         int open_price_count = 0;

         for(int i = 29; i < total_elements_count; i += 12)
           {

            OpenPrice[open_price_count] = StringToDouble(TotalElements[i]);
            open_price_count++;
           }

         //StopLoss
         double StopLoss[];
         ArrayResize(StopLoss,total_deals);

         int StopLoss_count = 0;

         for(int i = 30; i < total_elements_count; i += 12)
           {

            StopLoss[StopLoss_count] = StringToDouble(TotalElements[i]);
            StopLoss_count++;
           }

         // TakeProfit
         double TakeProfit[];
         ArrayResize(TakeProfit,total_deals);

         int TakeProfit_count = 0;

         for(int i = 31; i < total_elements_count; i += 12)
           {

            TakeProfit[TakeProfit_count] = StringToDouble(TotalElements[i]);
            TakeProfit_count++;
           }

         //CloseTime
         datetime CloseTime[];
         ArrayResize(CloseTime,total_deals);

         int close_time_count = 0;

         for(int i = 32; i < total_elements_count; i += 12)
           {

            CloseTime[close_time_count] = StringToTime(TotalElements[i]);
            close_time_count++;
           }
           
           
         //ClosePrice
         double ClosePrice[];
         ArrayResize(ClosePrice,total_deals);

         int close_price_count = 0;

         for(int i = 33; i < total_elements_count; i += 12)
           {
           
            ClosePrice[close_price_count] = StringToDouble(TotalElements[i]);
            close_price_count++;
            
           }
           
              //Profit
         double Profit[];
         ArrayResize(Profit,total_deals);

         int Profit_count = 0;

         for(int i = 34; i < total_elements_count; i += 12)
           {
           
            Profit[Profit_count] = StringToDouble(TotalElements[i]);
            Profit_count++;
            
           }
           
          
//Result
 string Result[];
         ArrayResize(Result,total_deals);

         int Result_count = 0;

         for(int i = 35; i < total_elements_count; i += 12)
           {
           
            Result[Result_count] = TotalElements[i];
            Result_count++;
            
           }

 ArrayPrint(Result);

         FileClose(file_handle);
        }

  }
//+------------------------------------------------------------------+
