//+------------------------------------------------------------------+
//|                                             Project 29 Files.mq5 |
//|                                             Abioye Israel Pelumi |
//|                             https://linktr.ee/abioyeisraelpelumi |
//+------------------------------------------------------------------+
#property copyright "Abioye Israel Pelumi"
#property link      "https://linktr.ee/abioyeisraelpelumi"
#property version   "1.00"

input datetime start_time = D'2026.01.01 00:00:00'; // Show history from this date
input datetime end_time = D'2026.01.31 00:00:00'; // To this date
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   string arrays_filename[];
   string default_filename = "Trading_Journal.csv";

   int result = FileSelectDialog("Select a File", NULL,"CSV files|*.csv", FSD_WRITE_FILE,arrays_filename,default_filename);

   string filename;
   if(result == 0)
     {

      Print("No file selected");

     }

   else
      if(result > 0)
        {

         Print("The trading journal will be saved in ",arrays_filename[0]);

         filename = arrays_filename[0];

        }

      else
        {

         Print(GetLastError());

        }

   int handle = FileOpen(filename, FILE_WRITE|FILE_CSV|FILE_SHARE_READ|FILE_ANSI, ',');


   if(handle == INVALID_HANDLE)
     {

      Print("Error opening file for writing. Error code: ", + GetLastError());

     }

   else
      if(handle != INVALID_HANDLE)
        {

         Print("File Sucessfully Opened");

         string account_name = AccountInfoString(ACCOUNT_NAME);
         double account_balance = AccountInfoDouble(ACCOUNT_BALANCE);
         long account_login = (long)AccountInfoInteger(ACCOUNT_LOGIN);



         FileWrite(handle, "Account Name: " + account_name);
         FileWrite(handle, "Account Balnce: " + DoubleToString(account_balance));
         FileWrite(handle, "Account Login: " + IntegerToString(account_login));
         FileWrite(handle, "Start Time: ", start_time);
         FileWrite(handle, "End Time: ", end_time);
         FileWrite(handle, "Last Update: ", TimeCurrent());

         FileWrite(handle, "\nTradeID","Symbol","OrderType", "LotSize", "OpenTime","OpenPrice","StopLoss", "TakeProfit", "CloseTime", "ClosePrice"
                   ,"Profit($)","Result");

         bool success = HistorySelect(start_time, end_time);

         //Total Deals
         int totalDeal = 0;
         if(success)
           {
            for(int i = 0; i < HistoryDealsTotal(); i++)
              {
               ulong ticket = HistoryDealGetTicket(i);
               if(HistoryDealGetInteger(ticket, DEAL_ENTRY) == DEAL_ENTRY_IN)
                 {
                  totalDeal++;

                 }

              }
           }

         //Trade ID

         ulong trade_id[];
         ArrayResize(trade_id,totalDeal);

         string symbol[];
         string order_type[];
         ArrayResize(symbol,totalDeal);
         ArrayResize(order_type,totalDeal);

         double lot_size[];
         datetime open_time[];
         double open_price[];
         double stop_l[];
         double take_p[];

         ArrayResize(lot_size,totalDeal);
         ArrayResize(open_time,totalDeal);
         ArrayResize(open_price,totalDeal);
         ArrayResize(stop_l,totalDeal);
         ArrayResize(take_p,totalDeal);
         
         
         
       datetime close_time[];
      double close_price[];
      double profit[];
      string result[];
      
        ArrayResize(close_time,totalDeal);
      ArrayResize(close_price,totalDeal);
      ArrayResize(profit,totalDeal);
      ArrayResize(result,totalDeal);


         int j = 0;
         int h = 0;


         if(success)
           {
            for(int i = 0; i < HistoryDealsTotal(); i++)
              {
               ulong ticket = HistoryDealGetTicket(i);


               if(HistoryDealGetInteger(ticket, DEAL_ENTRY) == DEAL_ENTRY_IN)
                 {
                  trade_id[j] = ticket;

                  symbol[j] =  HistoryDealGetString(ticket, DEAL_SYMBOL);

                  if(HistoryDealGetInteger(ticket,DEAL_TYPE) == DEAL_TYPE_BUY)
                    {
                     order_type[j] = "BUY";
                    }

                  if(HistoryDealGetInteger(ticket,DEAL_TYPE) == DEAL_TYPE_SELL)
                    {
                     order_type[j] = "SELL";
                    }

                  lot_size[j] = HistoryDealGetDouble(ticket,DEAL_VOLUME);
                  open_time[j] = (datetime)HistoryDealGetInteger(ticket,DEAL_TIME);
                  open_price[j]  = HistoryDealGetDouble(ticket,DEAL_PRICE);
                  stop_l[j] = HistoryDealGetDouble(ticket,DEAL_SL);
                  take_p[j] = HistoryDealGetDouble(ticket,DEAL_TP);



                  j++; // Increment the array index for the next valid ticket

                 }
                 
                     if(HistoryDealGetInteger(ticket, DEAL_ENTRY) == DEAL_ENTRY_OUT)
              {
               trade_id[h] = ticket;
               close_time[h] = (datetime)HistoryDealGetInteger(ticket,DEAL_TIME);
               close_price[h]  = HistoryDealGetDouble(ticket,DEAL_PRICE);
               profit[h] = HistoryDealGetDouble(ticket,DEAL_PROFIT);

               if(profit[h] > 0)
                 {

                  result[h] = "WIN";

                 }
               else
                  if(profit[h] < 0)
                    {

                     result[h] = "LOSS";

                    }
                  else
                    {

                     result[h] = "Break Even";

                    }


               h++;
              }

              }
           }

         for(int i = 0; i < totalDeal; i++)
           {
            FileWrite(handle, trade_id[i],symbol[i],order_type[i],lot_size[i],open_time[i],open_price[i],stop_l[i],take_p[i],close_time[i],close_price[i],profit[i]
                   ,result[i]);
           }


         FileClose(handle);

        }


  }
//+------------------------------------------------------------------+
