//+------------------------------------------------------------------+
//|                                             Project 29 Files.mq5 |
//|                                             Abioye Israel Pelumi |
//|                             https://linktr.ee/abioyeisraelpelumi |
//+------------------------------------------------------------------+
#property copyright "Abioye Israel Pelumi"
#property link      "https://linktr.ee/abioyeisraelpelumi"
#property version   "1.00"

input datetime start_time = D'2026.01.01 00:00:00'; // Show history from this date
input datetime end_time = D'2026.01.31 00:00:00'; // To this date
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   string arrays_filename[];
   string default_filename = "Trading_Journal.csv";

   int result = FileSelectDialog("Select a File", NULL,"CSV files|*.csv", FSD_WRITE_FILE,arrays_filename,default_filename);

   string filename;
   if(result == 0)
     {

      Print("No file selected");

     }

   else
      if(result > 0)
        {

         Print("The trading journal will be saved in ",arrays_filename[0]);

         filename = arrays_filename[0];

        }

      else
        {

         Print(GetLastError());

        }

   int handle = FileOpen(filename, FILE_WRITE|FILE_CSV|FILE_SHARE_READ|FILE_ANSI, ',');


   if(handle == INVALID_HANDLE)
     {

      Print("Error opening file for writing. Error code: ", + GetLastError());

     }

  else if(handle != INVALID_HANDLE)
     {

      Print("File Sucessfully Opened");
      
      string account_name = AccountInfoString(ACCOUNT_NAME);
      double account_balance = AccountInfoDouble(ACCOUNT_BALANCE);
      long account_login = (long)AccountInfoInteger(ACCOUNT_LOGIN);
      
      
      
      FileWrite(handle, "Account Name: " + account_name);
      FileWrite(handle, "Account Balnce: " + DoubleToString(account_balance));
      FileWrite(handle, "Account Login: " + IntegerToString(account_login));
      FileWrite(handle, "Start Time: ", start_time);
      FileWrite(handle, "End Time: ", end_time);
      FileWrite(handle, "Last Update: ", TimeCurrent());
      
      
      FileClose(handle);

     }


  }
//+------------------------------------------------------------------+
