//+------------------------------------------------------------------+
//|                                      Project 25 API AI PANEL.mq5 |
//|                                             Abioye Israel Pelumi |
//|                             https://linktr.ee/abioyeisraelpelumi |
//+------------------------------------------------------------------+
#property copyright "Abioye Israel Pelumi"
#property link      "https://linktr.ee/abioyeisraelpelumi"
#property version   "1.00"

#include  <Controls\Dialog.mqh>
#include <Controls\Edit.mqh>
#include <Controls\Button.mqh>
#include <Controls\Label.mqh>

CAppDialog panel;
CEdit input_box;
CButton send_button;
string send_button_name = "SEND BUTTON";

CLabel  response_display;
string response_text_name = "AI REPONSE";


int panel_x = 32;
int panel_y = 82;
int panel_w = 600;
int panel_h = 200;
ulong chart_ID = ChartID();
string panel_name = "Google Generative AI";
string input_box_name = "INPUT BOX";

string ai_response = " ";


int    display_length; // Number of characters visible at once
int    scroll_pos = 0;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {

   panel.Create(chart_ID,panel_name,0,panel_x,panel_y,panel_w,panel_h);

   input_box.Create(chart_ID,input_box_name,0,5,55,0,0);
   input_box.Width(500);
   input_box.Height(30);
   panel.Add(input_box);

   send_button.Create(chart_ID,send_button_name,0,510,55,556,85);
   send_button.Text("Send");
   panel.Add(send_button);

   response_display.Create(0, "PanelText", 0, 0, 0, 0, 0);
   response_display.Text(ai_response);
   panel.Add(response_display);

   EventSetMillisecondTimer(150);
   panel.Run();

//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {

   EventKillTimer();
   panel.Destroy(reason);


  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---

  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int32_t id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
//---
   if(id == CHARTEVENT_OBJECT_CLICK)
     {
      if(sparam == send_button_name)
        {

         //Comment("BUTTON WORKING PERFECTLY");

         string API_KEY = "AIzaSyCKJXiFPdvvM6f4ivPZ-zA2Qnoq6g62X7M";

         string url =  "https://generativelanguage.googleapis.com/v1beta/models/"
                       "gemini-2.5-flash-lite:generateContent?key=" + API_KEY;

         string headers = "Content-Type: application/json\r\n";

         string body = "{"
                       "\"contents\": ["
                       "{"
                       "\"parts\": ["
                       "{"
                       "\"text\": \"" + input_box.Text() + "\""
                       "}"
                       "]"
                       "}"
                       "]"
                       "}";


         char data[];
         int copied = StringToCharArray(body, data, 0, WHOLE_ARRAY, CP_UTF8);

         if(copied > 0)
            ArrayResize(data, copied - 1);

         char result[];
         string result_headers;
         int timeout = 15000;

         int response = WebRequest("POST",url,headers,timeout,data,result,result_headers);

         if(response == -1)
           {
            Print("WebRequest failed. Error: ", GetLastError());
            return;
           }

         string response_text = CharArrayToString(result);
         //  Print(response_text);

         string pattern = "\"text\": ";
         int pattern_lenght = StringFind(response_text,pattern);
         pattern_lenght += StringLen(pattern);

         int end = StringFind(response_text,"}",pattern_lenght + 1);

         ai_response = StringSubstr(response_text,pattern_lenght,end - pattern_lenght);

         //   response_display.Text(ai_response);
         Print(ai_response);

         int res_lenght = StringLen(ai_response);


         if(res_lenght < 100)
           {

            display_length = res_lenght;

           }
         if(res_lenght >= 100)
           {

            display_length = 100;

           }



        }
     }

  }
//+------------------------------------------------------------------+
//| Timer function for animation                                     |
//+------------------------------------------------------------------+
void OnTimer()
  {
   int message_len = StringLen(ai_response);

// SAFETY CHECK (very important)
   if(message_len == 0)
      return;

   string visible_text = "";

   for(int i = 0; i < display_length; i++)
     {
      int char_index = (scroll_pos + i) % message_len;
      visible_text += StringSubstr(ai_response, char_index, 1);
     }

   response_display.Text(visible_text);

   scroll_pos++;
   if(scroll_pos >= message_len)
      scroll_pos = 0;
  }



//+------------------------------------------------------------------+
//
///

 