package com.clemencebenjamin.mql5profileviewer.ui.login

import android.content.Intent
import android.os.Bundle
import android.widget.Button
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.browser.customtabs.CustomTabsIntent
import com.clemencebenjamin.mql5profileviewer.R
import com.clemencebenjamin.mql5profileviewer.util.OAuthConfig
import androidx.core.net.toUri

class LoginActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_login)

        val loginButton = findViewById<Button>(R.id.btnLogin)
        loginButton.setOnClickListener {
            startOAuth()
        }
    }

    override fun onNewIntent(intent: Intent?) {
        super.onNewIntent(intent)

        val code = intent?.data?.getQueryParameter("code")
        if (code != null) {
            Toast.makeText(this, "Login successful", Toast.LENGTH_SHORT).show()
            // NEXT STEP: exchange code for access token
        }
    }

    private fun startOAuth() {
        val uri = OAuthConfig.AUTH_URL.toUri().buildUpon()
            .appendQueryParameter("client_id", OAuthConfig.CLIENT_ID)
            .appendQueryParameter("redirect_uri", OAuthConfig.REDIRECT_URI)
            .appendQueryParameter("response_type", "code")
            .build()

        val customTabsIntent = CustomTabsIntent.Builder().build()
        customTabsIntent.launchUrl(this, uri)
    }
}
