//+------------------------------------------------------------------+
//|                                                         wald.mqh |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include<Math\Stat\ChiSquare.mqh>
//+------------------------------------------------------------------+
//|Test statistic holder for Wald-type tests                                                                  |
//+------------------------------------------------------------------+
struct WaldTestStatistic
 {
  ulong df;
  double stat;
  string null;
  string alternative;
  
  WaldTestStatistic(void)
   {
    stat = EMPTY_VALUE;
    df = 0; 
    null = alternative = NULL;
   }
  WaldTestStatistic(double _stat, ulong _df, string _null, string _alt)
   {
    stat = _stat;
    df = _df;
    null = _null;
    alternative = _alt;
   }
  WaldTestStatistic(WaldTestStatistic &other)
   {
    stat = other.stat;
    df = other.df;
    null = other.null;
    alternative = other.alternative;
   }
  void operator=(WaldTestStatistic &other)
   {
    stat = other.stat;
    df = other.df;
    null = other.null;
    alternative = other.alternative;
   }
  double pvalue(void)
   {
    int ecode = 0;
    double val = 1.- MathCumulativeDistributionChiSquare(stat,double(df),ecode);
    
    if(ecode)
     Print(__FUNCTION__," Chisquare cdf error ", ecode);
    return val;
   }
  vector critical_values(void)
   {
    vector out = {0.9,0.95,0.99};
    int ecode = 0;
    for(ulong i = 0; i<out.Size(); ++i)
         out[i] = MathQuantileChiSquare(out[i],double(df),ecode);
    if(ecode)
     Print(__FUNCTION__," Chisquare cdf error ", ecode);
    return out;
   }
 };