//+------------------------------------------------------------------+
//|                                                         trig.mqh |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
namespace special
{
namespace cephes
{

/* Compute sin(pi * x). */
template <typename T>
T sinpi(T x)
  {
   T s = 1.0;

   if(x < 0.0)
     {
      x = -x;
      s = -1.0;
     }

   T r = fmod(x, 2.0);
   if(r < 0.5)
     {
      return s * sin(M_PI * r);
     }
   else
      if(r > 1.5)
        {
         return s * sin(M_PI * (r - 2.0));
        }
      else
        {
         return -s * sin(M_PI * (r - 1.0));
        }
  }

/* Compute cos(pi * x) */
template <typename T>
T cospi(T x)
  {
   if(x < 0.0)
     {
      x = -x;
     }

   T r = fmod(x, 2.0);
   if(r == 0.5)
     {
      // We don't want to return -0.0
      return 0.0;
     }
   if(r < 1.0)
     {
      return -sin(M_PI * (r - 0.5));
     }
   else
     {
      return sin(M_PI * (r - 1.5));
     }
  }
} // namespace cephes
} // namespace special
