//+------------------------------------------------------------------+
//|                                                        error.mqh |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include "config.mqh"
//+------------------------------------------------------------------+
//|  error codes  enumeration                                        |
//+------------------------------------------------------------------+
enum sf_error_t
  {
   SF_ERROR_OK = 0,    /* no error */
   SF_ERROR_SINGULAR,  /* singularity encountered */
   SF_ERROR_UNDERFLOW, /* floating point underflow */
   SF_ERROR_OVERFLOW,  /* floating point overflow */
   SF_ERROR_SLOW,      /* too many iterations required */
   SF_ERROR_LOSS,      /* loss of precision */
   SF_ERROR_NO_RESULT, /* no result obtained */
   SF_ERROR_DOMAIN,    /* out of domain */
   SF_ERROR_ARG,       /* invalid input parameter */
   SF_ERROR_OTHER,     /* unclassified error */
   SF_ERROR__LAST
  };

//+------------------------------------------------------------------+
//| print error messages to console                                  |
//+------------------------------------------------------------------+
void set_error(const string func_name, sf_error_t code, string fmt = NULL)
  {
   Print(func_name," ",EnumToString(code)," ",fmt);
   return;
  }
//+------------------------------------------------------------------+
//|  not a number                                                    |
//+------------------------------------------------------------------+
double quiet_NaN(void)
  {
   return double("nan");
  }
//+------------------------------------------------------------------+
//| infinity                                                         |
//+------------------------------------------------------------------+
double infinity(void)
 {
  return double("inf");
 }
//+------------------------------------------------------------------+
