//+------------------------------------------------------------------+
//|                                            Fetch Data Mid Points |
//|                                      Copyright 2020, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property script_show_inputs

//--- File name
string file_name = Symbol() + " Mid Points.csv";

//--- Amount of data requested
input int size = 3000;

//+------------------------------------------------------------------+
//| Our script execution                                             |
//+------------------------------------------------------------------+
void OnStart()
  {
   
//---Write to file
   int file_handle=FileOpen(file_name,FILE_WRITE|FILE_ANSI|FILE_CSV,",");

   for(int i=size;i>=1;i--)
     {
      if(i == size)
        {
         FileWrite(file_handle,
                  //--- Time
                  "Time",
                   //--- OHLC
                   "Open",
                   "High",
                   "Low",
                   "Close",
                   //--- OHLC Mid Points
                   "O-H M",
                   "O-L M",
                   "O-C M",
                   "H-L M",
                   "H-C M",
                   "L-C M"
                  );
        }

      else
        {
         FileWrite(file_handle,
                   iTime(_Symbol,PERIOD_CURRENT,i),
                   //--- OHLC
                   iOpen(_Symbol,PERIOD_CURRENT,i),
                   iHigh(_Symbol,PERIOD_CURRENT,i),
                   iLow(_Symbol,PERIOD_CURRENT,i),
                   iClose(_Symbol,PERIOD_CURRENT,i),
                   //--- OHLC Mid Points
                    (iOpen(_Symbol,PERIOD_CURRENT,i) +  iHigh(_Symbol,PERIOD_CURRENT,i))/2,
                    (iOpen(_Symbol,PERIOD_CURRENT,i) +  iLow(_Symbol,PERIOD_CURRENT,i))/2,
                    (iOpen(_Symbol,PERIOD_CURRENT,i) +  iClose(_Symbol,PERIOD_CURRENT,i))/2,
                    (iHigh(_Symbol,PERIOD_CURRENT,i) +  iLow(_Symbol,PERIOD_CURRENT,i))/2,
                    (iHigh(_Symbol,PERIOD_CURRENT,i) +  iClose(_Symbol,PERIOD_CURRENT,i))/2,
                    (iLow(_Symbol,PERIOD_CURRENT,i) +  iClose(_Symbol,PERIOD_CURRENT,i))/2
                   );
        }
     }
//--- Close the file
   FileClose(file_handle);
  }
//+------------------------------------------------------------------+