//+------------------------------------------------------------------+
//|                                 Automatic Strategy Selection.mq5 |
//|                                               Gamuchirai Ndawana |
//|                    https://www.mql5.com/en/users/gamuchiraindawa |
//+------------------------------------------------------------------+
#property copyright "Gamuchirai Ndawana"
#property link      "https://www.mql5.com/en/users/gamuchiraindawa"
#property version   "1.00"

//+------------------------------------------------------------------+
//| System definiyions                                               |
//+------------------------------------------------------------------+
#define MA_PERIOD     5                    //--- Moving Average Period
#define MA_TYPE       MODE_SMA             //--- Type of moving average 
#define RSI_PERIOD    15                   //--- RSI Period
#define STOCH_K       5                    //--- Stochastich K Period
#define STOCH_D       3                    //--- Stochastich D Period
#define STOCH_SLOWING 3                    //--- Stochastic slowing
#define STOCH_MODE    MODE_EMA             //--- Stochastic mode
#define STOCH_PRICE   STO_LOWHIGH          //--- Stochastic price feeds
#define TOTAL_STRATEGIES 4                 //--- Total strategies we have to choose from

//+------------------------------------------------------------------+
//| System libraries                                                 |
//+------------------------------------------------------------------+
#include <Trade\Trade.mqh>
CTrade Trade;

//+------------------------------------------------------------------+
//| Global variables                                                 |
//+------------------------------------------------------------------+
int ma_c_handle,ma_o_handle,ma_h_handle,ma_l_handle,rsi_handle,stoch_handle,atr_handle;
double ma_c_reading[],ma_o_reading[],ma_h_reading[],ma_l_reading[],rsi_reading[],sto_reading_main[],sto_reading_signal[],atr_reading[];
double long_vote,short_vote;

MqlDateTime ts,tc;
MqlTick     current_tick;

double const weights_1 [] = {1,1,1,1};
double const weights_2 [] = {1,1,0,1};
double const weights_3 [] = {0,0,1,1};
double const weights_4 [] = {0,1,0,0};
double selected_weights[] = {0,0,0,0};

//+------------------------------------------------------------------+
//| Custom enumrations                                               |
//+------------------------------------------------------------------+
enum operation_modes
  {
   HIGH=0,     //High Risk
   MID=1,      //Medium Risk
   LOW=2,      //Low Risk
   MINIMUM=3   //Minimum Risk
  };

//+------------------------------------------------------------------+
//| User inputs                                                      |
//+------------------------------------------------------------------+
input group "User Risk Settings"
input operation_modes  user_mode = 1;//Define Your Risk Settings

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- Setup our risk settings
   switch(user_mode)
     {
      case(0):
         Print("High risk mode selected");
         ArrayCopy(selected_weights,weights_1,0,0,WHOLE_ARRAY);
         break;
      case(1):
         Print("Medium risk mode selected");
         ArrayCopy(selected_weights,weights_2,0,0,WHOLE_ARRAY);
         break;
      case(2):
         Print("Low risk mode selected");
         ArrayCopy(selected_weights,weights_3,0,0,WHOLE_ARRAY);
         break;
      case(3):
         Print("Minimum risk mode selected");
         ArrayCopy(selected_weights,weights_4,0,0,WHOLE_ARRAY);
         break;
      default:
         Print("No risk mode selected! No Trades will be placed");
         break;
     }

//--- Setup the time
   TimeLocal(tc);
   TimeLocal(ts);

//---Setup our technical indicators
   ma_c_handle = iMA(_Symbol,PERIOD_CURRENT,MA_PERIOD,0,MA_TYPE,PRICE_CLOSE);
   ma_o_handle = iMA(_Symbol,PERIOD_CURRENT,MA_PERIOD,0,MA_TYPE,PRICE_OPEN);
   ma_h_handle = iMA(_Symbol,PERIOD_CURRENT,MA_PERIOD,0,MA_TYPE,PRICE_HIGH);
   ma_l_handle = iMA(_Symbol,PERIOD_CURRENT,MA_PERIOD,0,MA_TYPE,PRICE_LOW);
   atr_handle = iATR(_Symbol,PERIOD_CURRENT,14);
   rsi_handle  = iRSI(_Symbol,PERIOD_CURRENT,RSI_PERIOD,PRICE_CLOSE);
   stoch_handle = iStochastic(_Symbol,PERIOD_CURRENT,STOCH_K,STOCH_D,STOCH_SLOWING,STOCH_MODE,STOCH_PRICE);
//---
   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   IndicatorRelease(ma_c_handle);
   IndicatorRelease(ma_o_handle);
   IndicatorRelease(ma_h_handle);
   IndicatorRelease(ma_l_handle);
   IndicatorRelease(rsi_handle);
   IndicatorRelease(stoch_handle);
   IndicatorRelease(atr_handle);
  }

//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   TimeLocal(ts);

   if(ts.day != tc.day)
     {
      //--- Update the time
      TimeLocal(tc);

      //--- Update Our indicator readings
      CopyBuffer(ma_c_handle,0,0,1,ma_c_reading);
      CopyBuffer(ma_o_handle,0,0,1,ma_o_reading);
      CopyBuffer(ma_h_handle,0,0,1,ma_h_reading);
      CopyBuffer(ma_l_handle,0,0,1,ma_l_reading);
      CopyBuffer(rsi_handle,0,0,1,rsi_reading);
      CopyBuffer(stoch_handle,0,0,1,sto_reading_main);
      CopyBuffer(stoch_handle,0,0,1,sto_reading_signal);
      CopyBuffer(atr_handle,0,0,1,atr_reading);

      //--- Copy Market Data
      double close = iClose(Symbol(),PERIOD_CURRENT,0);
      SymbolInfoTick(Symbol(),current_tick);

      //--- Place a position
      if(PositionsTotal() ==0)
        {
         //--- Our strategies will vote on what should be done
         long_vote = 0;
         short_vote = 0;

         for(int i =0; i<TOTAL_STRATEGIES;i++)
           {
            //--- Is the strategy's vote valid?
            if(selected_weights[i] == 1)
              {
               //--- Moving average open close strategy
               if(i == 0)
                 {
                  if(ma_o_reading[0] > ma_c_reading[0])
                     short_vote  += selected_weights[0];

                  else
                     if(ma_o_reading[0] < ma_c_reading[0])
                        long_vote += selected_weights[0];
                 }

               //--- Moving average high low strategy
               if(i == 1)
                 {
                  if(close > ma_h_reading[0])
                     long_vote += selected_weights[1];

                  else
                     if(close < ma_l_reading[0])
                        short_vote += selected_weights[1];
                 }

               //--- RSI Strategy
               if(i == 2)
                 {
                  if(rsi_reading[0] > 50)
                     long_vote += selected_weights[2];

                  else
                     if(rsi_reading[0] < 50)
                        short_vote += selected_weights[2];
                 }

               //--- Stochastic Strategy
               if(i == 3)
                 {
                  if(sto_reading_main[0] > 80)
                     long_vote += selected_weights[3];

                  else
                     if(sto_reading_main[0] < 30)
                        short_vote += selected_weights[3];
                 }
              }
           }
         if(long_vote > short_vote)
            Trade.Buy(0.01,Symbol(),current_tick.ask,current_tick.ask-(1.5*atr_reading[0]),current_tick.ask+(1.5*atr_reading[0]));

         if(long_vote < short_vote)
            Trade.Sell(0.01,Symbol(),current_tick.bid,current_tick.bid+(1.5*atr_reading[0]),current_tick.bid-(1.5*atr_reading[0]));
        }

     }
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Undefine system constants                                        |
//+------------------------------------------------------------------+
#undef MA_PERIOD
#undef MA_TYPE
#undef RSI_PERIOD
#undef STOCH_K
#undef STOCH_D
#undef STOCH_SLOWING
#undef STOCH_MODE
#undef STOCH_PRICE
#undef TOTAL_STRATEGIES
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
