//+------------------------------------------------------------------+
//|                                         ButterFly_Oscillator.mq5 |
//+------------------------------------------------------------------+
#property copyright "Wamek EA"
#property link      "https://www.mql5.com/en/users/wamek/news"
#property version   "1.01"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

//--- plot Butterfly
#property indicator_label1  "Butterfly Oscillator"
#property indicator_type1   DRAW_LINE
#property indicator_color1  DodgerBlue
#property indicator_width1  2
#property indicator_style1  STYLE_SOLID

//--- indicator levels
#property indicator_level1  2.5
#property indicator_level2 -2.5
#property indicator_level3  0.0

//--- buffers
double ButterflyBuffer[];

//--- input parameters
input bool   UsePriceStep = false; // Use ClosePrice as Step size for t increment
input double tmStep       = 0.05;  // Step size for t increment

//+------------------------------------------------------------------+
//| Custom indicator initialization                                  |
//+------------------------------------------------------------------+
int OnInit()
  {
   SetIndexBuffer(0, ButterflyBuffer, INDICATOR_DATA);
   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| Custom indicator calculation                                     |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   if(rates_total < 2) return(0);

   int pStart = prev_calculated == 0 ? 0 : prev_calculated - 1;

   for(int i = pStart; i < rates_total; i++)
     {
      double bar_close = close[i];
      double bar_open  = open[i];
      ButterflyBuffer[i] = CalButterflyValue(i, bar_close, bar_open);
     }

   return(rates_total);
  }

//+------------------------------------------------------------------+
//| Calculate Butterfly Oscillator value                              |
//+------------------------------------------------------------------+
double CalButterflyValue(int bar_index, double bar_close, double bar_open)
  {
   double tStep = UsePriceStep ? MathMod((bar_close - bar_open) / _Point, tmStep) : tmStep;
   double t = bar_index * tStep;

   // Butterfly curve formula
   double x = MathSin(t) *
              (MathExp(MathCos(t)) - 2.0 * MathCos(4.0 * t) - MathPow(MathSin(t / 12.0), 5));

   return (x);
  }
