//+------------------------------------------------------------------+
//|          DeM_MFI_RSI_corr.mq5                                    |
//+------------------------------------------------------------------+
#property copyright "Wamek EA"
#property link      "https://www.mql5.com/en/users/wamek/news"
#property version   "1.00"
#property strict
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots 1
#property indicator_label1  "PseudoPearsonCorr"
#property indicator_type1   DRAW_LINE
#property indicator_style1  STYLE_SOLID
#property indicator_width1  2
#property indicator_color1  clrAquamarine

#property indicator_maximum 1
#property indicator_minimum -1

#property indicator_level1 -0.80
#property indicator_level2 -0.50
#property indicator_level3  0.00
#property indicator_level4  0.50
#property indicator_level5  0.80

//---- Inputs
input int                 CorrPeriod      = 21;   // correlation lookback
input int                 RSIPeriod       = 14;
input int                 MFIPeriod       = 14;
input int                 DeMPeriod       = 14;

//---- Buffers
double CorrBuffer[];

// Handles for technical indicators
int rsi_handle;
int mfi_handle;
int dem_handle;

//+------------------------------------------------------------------+
int OnInit()
{
   SetIndexBuffer(0, CorrBuffer, INDICATOR_DATA);
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, CorrPeriod);
   IndicatorSetString(INDICATOR_SHORTNAME,
      StringFormat("PPr[ Corr=%d  RSI=%d  MFI=%d  DeM=%d ]",
                   CorrPeriod, RSIPeriod, MFIPeriod, DeMPeriod));
   
   // Create indicator handles
   rsi_handle = iRSI(_Symbol, _Period, RSIPeriod, PRICE_CLOSE);
   mfi_handle = iMFI(_Symbol, _Period, MFIPeriod,VOLUME_TICK);
   dem_handle = iDeMarker(_Symbol, _Period, DeMPeriod);
   
   if(rsi_handle == INVALID_HANDLE || mfi_handle == INVALID_HANDLE || dem_handle == INVALID_HANDLE)
   {
      Print("Error creating indicator handles");
      return(INIT_FAILED);
   }

   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   if(rsi_handle != INVALID_HANDLE) IndicatorRelease(rsi_handle);
   if(mfi_handle != INVALID_HANDLE) IndicatorRelease(mfi_handle);
   if(dem_handle != INVALID_HANDLE) IndicatorRelease(dem_handle);
}
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
{
 int Maxlookback =  CorrPeriod + MathMax(MathMax(RSIPeriod, MFIPeriod), DeMPeriod);
   if(rates_total <Maxlookback)
      return(0);

   // Calculate starting position
   int pStart;
   if(prev_calculated == 0)
   {
      pStart =  Maxlookback;
      // Initialize buffer
      ArrayInitialize(CorrBuffer, EMPTY_VALUE);
   }
   else
      pStart = prev_calculated-1 ;

   // Copy indicator values
   double rsi_buffer[];
   double mfi_buffer[];
   double dem_buffer[];
   
   int copied_rsi = CopyBuffer(rsi_handle, 0, 0, rates_total, rsi_buffer);
   int copied_mfi = CopyBuffer(mfi_handle, 0, 0, rates_total, mfi_buffer);
   int copied_dem = CopyBuffer(dem_handle, 0, 0, rates_total, dem_buffer);
   
   if(copied_rsi != rates_total || copied_mfi != rates_total || copied_dem != rates_total)
      return(0);

   for(int i = pStart; i<rates_total; i++)
   {
      double sum_xy = 0.0;
      double sum_x2 = 0.0;
      double sum_y2 = 0.0;

      for(int j = 0; j < CorrPeriod; j++)
      {
         int sh = i - j;

         // Get RSI value
         double rsi = rsi_buffer[sh];

         // Get MFI value
         double mfi = mfi_buffer[sh];

         // Get DeMarker value
         double dem = dem_buffer[sh];

         // Deviations relative to RSI
         double dx = (dem - rsi);
         double dy = (mfi - rsi);

         sum_xy += dx * dy;
         sum_x2 += dx * dx;
         sum_y2 += dy * dy;
      }

      double denom = MathSqrt(sum_x2 * sum_y2);
      if(denom > 0.0)
         CorrBuffer[i] = sum_xy / denom;   //Pseudo Pearson r in [-1, +1]
      else
         CorrBuffer[i] = EMPTY_VALUE;
   }

   return(rates_total);
}
//+------------------------------------------------------------------+