//+------------------------------------------------------------------+
//|                                           SampleNelsonCopula.mq5 |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property script_show_inputs
#include<Copulas/Bivariate/n13.mqh>
#include<Copulas/Bivariate/n14.mqh>
#include<np.mqh>
//+------------------------------------------------------------------+
//|  enum                                                            |
//+------------------------------------------------------------------+
enum ENUM_ARCH_COPULA
 {
  N13=0,//N13
  N14//N14
 };
//--- input parameters
input ENUM_ARCH_COPULA copula_to_sample_from = N13;
input double theta_ = 3.0;
input ulong Size = 1000;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   CBivariateCopula *copula = NULL;
//---
   switch(copula_to_sample_from)
    {
     case N13:
       copula = (CBivariateCopula*)new CN13();
       break;
     case N14:
       copula = (CBivariateCopula*)new CN14();
       break;
    }
//---
   copula.Set_theta(theta_);
//---
   matrix samples = copula.Sample(Size);
   string cname = EnumToString((ENUM_COPULA_TYPE)copula.Type());
//---
   delete copula;
//---display QQ plot
   np::scatter_plot(samples.Col(0),samples.Col(1),cname+" Q-Q plot","U","V",true,0,0,0,0,400,300,true,30);  
//---
  }
//+------------------------------------------------------------------+
