//+------------------------------------------------------------------+
//|                                      SampleArchimedianCopula.mq5 |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property script_show_inputs
#include<Copulas/Bivariate/joe.mqh>
#include<Copulas/Bivariate/frank.mqh>
#include<Copulas/Bivariate/clayton.mqh>
#include<Copulas/Bivariate/gumbel.mqh>
#include<np.mqh>
//+------------------------------------------------------------------+
//|  enum                                                            |
//+------------------------------------------------------------------+
enum ENUM_ARCH_COPULA
 {
  FRANK=0,//Frank
  JOE,//Joe
  CLAYTON,//Clayton
  GUMBEL//Gumbel
 };
//--- input parameters
input ENUM_ARCH_COPULA copula_to_sample_from = FRANK;
input double theta_ = 3.0;
input ulong Size = 1000;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   CBivariateCopula *copula = NULL;
//---
   switch(copula_to_sample_from)
    {
     case FRANK:
       copula = (CBivariateCopula*)new CFrank();
       break;
     case JOE:
       copula = (CBivariateCopula*)new CJoe();
       break;
     case CLAYTON:
       copula = (CBivariateCopula*)new CClayton();
       break;
     case GUMBEL:
       copula = (CBivariateCopula*)new CGumbel();
       break;
    }
//---
  copula.Set_theta(theta_);
//---
   matrix samples = copula.Sample(Size);
   string cname = EnumToString((ENUM_COPULA_TYPE)copula.Type());
//---
   delete copula;
//---display QQ plot
   np::scatter_plot(samples.Col(0),samples.Col(1),cname+" Q-Q plot","U","V",true,0,0,0,0,400,300,true,30);  
//---
  }
//+------------------------------------------------------------------+
