//+------------------------------------------------------------------+
//|                                            GoldCopulaSignals.mq5 |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 4
#property indicator_plots   4
#property indicator_maximum 1.1
#property indicator_minimum -0.1
#property indicator_level1  0.05
#property indicator_level2  0.5
#property indicator_level3  0.95
#include<Copulas\Bivariate\bivariate_copula.mqh>
#include<ECDF\linear_cdf.mqh>
//--- plot S1
#property indicator_label1  "S1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot S2
#property indicator_label2  "S2"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrBlue
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//---
#property indicator_label3  "EURGold"
#property indicator_type3   DRAW_NONE

//---
#property indicator_label4  "USDGold"
#property indicator_type4  DRAW_NONE

//--- input parameters
input ENUM_COPULA_TYPE Copulatype = FRANK_COPULA;
input string   CopulaModelName = "model.copula";
input string   ECDFModelName = "model.ecdf";
//--- 
string   FirstSymbol="XAUUSD";
string   SecondSymbol="XAUEUR";
//--- indicator buffers
double         S1Buffer[];
double         S2Buffer[];
double         S3Buffer[];
double         S4Buffer[];
matrix         mat_;
CLinearCDF* qt;
CBivariateCopula *bcop;
CFileBin savedcop,savedcdf;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {

//---
    qt = new CLinearCDF();
//---
   switch(Copulatype)
    {
     case CLAYTON_COPULA:
      bcop = new CClayton();
      break;
     case FRANK_COPULA:
      bcop = new CFrank();
      break;
     case GUMBEL_COPULA:
      bcop = new CGumbel();
      break;
     case JOE_COPULA:
      bcop = new CJoe();
      break;
     case N13_COPULA:
      bcop = new CN13();
      break;
     case N14_COPULA:
      bcop = new CN14();
      break;
     case GAUSSIAN_COPULA:
      bcop = new CGaussian();
      break;
     case STUDENT_COPULA:
      bcop = new CStudent();
      break;
    }
//---
    savedcop.Open(CopulaModelName,FILE_READ|FILE_BIN|FILE_COMMON);
    if(!bcop.Load(savedcop.Handle()))
     {
      Print("Failed to load copula model ", CopulaModelName, " ", GetLastError());
      return INIT_FAILED;
     }
//---
    if((ENUM_COPULA_TYPE)bcop.Type() != Copulatype)
     {
      Print("Invalid copula model. Instantiated copula is ", EnumToString((ENUM_COPULA_TYPE)bcop.Type()),"\n but specified copula in input settings is ", EnumToString(Copulatype));
      return INIT_FAILED;
     }
//---
    savedcop.Close();
//---
    savedcdf.Open(ECDFModelName,FILE_READ|FILE_BIN|FILE_COMMON);
    if(!qt.load(savedcdf.Handle()))
     {
      Print("Failed to load the ECDF model ", ECDFModelName, " ", GetLastError());
      return INIT_FAILED;
     }
//---
    savedcdf.Close();
//---
    mat_.Resize(1,2);
//--- indicator buffers mapping
   SetIndexBuffer(0,S1Buffer,INDICATOR_DATA);
   SetIndexBuffer(1,S2Buffer,INDICATOR_DATA);
   SetIndexBuffer(2,S3Buffer,INDICATOR_DATA);
   SetIndexBuffer(3,S4Buffer,INDICATOR_DATA);
//---
   ArraySetAsSeries(S1Buffer,true);
   ArraySetAsSeries(S2Buffer,true);
   ArraySetAsSeries(S3Buffer,true);
   ArraySetAsSeries(S4Buffer,true);
//---
   PlotIndexSetString(0,PLOT_LABEL,FirstSymbol);
   PlotIndexSetString(1,PLOT_LABEL,SecondSymbol);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| On deinitialization                                              |
//+------------------------------------------------------------------+
void  OnDeinit( const int  reason )
  {
//---
   if(CheckPointer(qt) == POINTER_DYNAMIC)
     delete qt;
//---
   if(CheckPointer(bcop) == POINTER_DYNAMIC)
     delete bcop;
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {
//---
   int32_t limit;
   if(prev_calculated<=0)
     limit= rates_total-2;
   else 
     limit=rates_total-prev_calculated;
//---
   for(int32_t i =limit; i >=0 ; --i)
    {
     mat_[0,0] = iClose(FirstSymbol,PERIOD_CURRENT,i);
     mat_[0,1] = iClose(SecondSymbol,PERIOD_CURRENT,i);
     S3Buffer[i] = mat_[0,1];
     S4Buffer[i] = mat_[0,0];
     mat_ = qt.to_quantile(mat_);
     S1Buffer[i] = bcop.Conditional_Probability(mat_[0][0],mat_[0][1]);
     S2Buffer[i] = bcop.Conditional_Probability(mat_[0][1],mat_[0][0]);
    }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
